/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import com.biz.crm.visitstep.req.VisitStepPageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@ApiModel(value="\u67e5\u8be2\u5e93\u5b58\u76d8\u70b9\u62a5\u8868")
public class GetStockInventoryReq
extends VisitStepPageReq {
    @ApiModelProperty(value="\u5ba2\u6237\u7f16\u7801")
    private String clientCode;
    @ApiModelProperty(value="\u5ba2\u6237\u7c7b\u578b")
    private String clientType;
    @ApiModelProperty(value="\u5ba2\u6237\u540d\u79f0")
    private String clientName;

    public NativeSearchQuery buildQuery() {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isBlank((CharSequence)this.getStepCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"stepCode.keyword", (String)this.getStepCode()));
        if (StringUtils.isNotEmpty((CharSequence)this.getClientCode())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode.keyword", (String)this.getClientCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getClientName())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientName.keyword", (String)this.getClientName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getClientType())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientType.keyword", (String)this.getClientType()));
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)(this.getPageNum() - 1), (int)this.getPageSize()));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"createDate").order(SortOrder.DESC));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"createDateSecond").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetStockInventoryReq)) {
            return false;
        }
        GetStockInventoryReq other = (GetStockInventoryReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientCode = this.getClientCode();
        String other$clientCode = other.getClientCode();
        if (this$clientCode == null ? other$clientCode != null : !this$clientCode.equals(other$clientCode)) {
            return false;
        }
        String this$clientType = this.getClientType();
        String other$clientType = other.getClientType();
        if (this$clientType == null ? other$clientType != null : !this$clientType.equals(other$clientType)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        return !(this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetStockInventoryReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientCode = this.getClientCode();
        result = result * 59 + ($clientCode == null ? 43 : $clientCode.hashCode());
        String $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : $clientType.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GetStockInventoryReq(clientCode=" + this.getClientCode() + ", clientType=" + this.getClientType() + ", clientName=" + this.getClientName() + ")";
    }
}

