/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.req;

import com.biz.crm.base.BusinessException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@ApiModel(value="\u67e5\u8be2\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6\u5206\u9875-\u53c2\u6570")
public class GetVisitReportsPageReq {
    @ApiModelProperty(value="\u62dc\u8bbf\u5927\u7c7b\uff08VISIT:\u62dc\u8bbf\uff0cHELP_VISIT:\u534f\u8bbf\uff0cUNFAMILIAR_VISIT:\u964c\u62dc\uff09")
    private String visitBigType;
    @ApiModelProperty(value="\u7528\u6237\u540d\u79f0")
    private String visitRealName;
    @ApiModelProperty(value="\u804c\u4f4d\u540d\u79f0")
    private String visitPosName;
    @ApiModelProperty(value="\u5ba2\u6237\u7f16\u7801")
    private String clientCode;
    @ApiModelProperty(value="\u5ba2\u6237\u540d\u79f0")
    private String clientName;
    @ApiModelProperty(value="\u62dc\u8bbf\u5f00\u59cb\u65f6\u95f4")
    private String endVisitDate;
    @ApiModelProperty(value="\u62dc\u8bbf\u7ed3\u675f\u65f6\u95f4")
    private String startVisitDate;
    @ApiModelProperty(value="\u63d0\u4ea4\u65f6\u95f4-\u5f00\u59cb")
    private String outStoreStartTime;
    @ApiModelProperty(value="\u63d0\u4ea4\u65f6\u95f4-\u7ed3\u675f")
    private String outStoreEndTime;
    @ApiModelProperty(value="\u9875\u7801")
    private Integer pageNum = 1;
    @ApiModelProperty(value="\u6bcf\u9875\u957f\u5ea6")
    private Integer pageSize = 15;

    public NativeSearchQuery buildQuery() {
        if (StringUtils.isBlank((CharSequence)this.getVisitBigType())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u62dc\u8bbf\u5927\u7c7b");
        }
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"visitBigType", (String)this.getVisitBigType()));
        if (StringUtils.isNotBlank((CharSequence)this.getClientCode())) {
            builder.must((QueryBuilder)QueryBuilders.fuzzyQuery((String)"clientCode", (String)this.getClientCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getVisitRealName())) {
            builder.must((QueryBuilder)QueryBuilders.fuzzyQuery((String)"visitRealName", (String)this.getVisitRealName()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getVisitPosName())) {
            builder.must((QueryBuilder)QueryBuilders.fuzzyQuery((String)"visitPosName", (String)this.getVisitPosName()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getClientName())) {
            builder.must((QueryBuilder)QueryBuilders.fuzzyQuery((String)"clientName", (String)this.getClientName()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getStartVisitDate())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"visitDate").from((Object)this.getStartVisitDate()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getEndVisitDate())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"visitDate").to((Object)this.getEndVisitDate()));
        }
        RangeQueryBuilder rangeQueryBuilder = null;
        if (StringUtils.isNotBlank((CharSequence)this.getOutStoreStartTime())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"sfaVisitPlanInfoExecuteRedisData.outStore").gte((Object)this.getOutStoreStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getOutStoreEndTime())) {
            if (null == rangeQueryBuilder) {
                rangeQueryBuilder = QueryBuilders.rangeQuery((String)"sfaVisitPlanInfoExecuteRedisData.outStore").lte((Object)this.getOutStoreEndTime());
            } else {
                rangeQueryBuilder.lte((Object)this.getOutStoreEndTime());
            }
        }
        if (null != rangeQueryBuilder) {
            builder.must((QueryBuilder)rangeQueryBuilder);
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)(this.getPageNum() - 1), (int)this.getPageSize()));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"visitDate").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }

    public String getVisitBigType() {
        return this.visitBigType;
    }

    public String getVisitRealName() {
        return this.visitRealName;
    }

    public String getVisitPosName() {
        return this.visitPosName;
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getEndVisitDate() {
        return this.endVisitDate;
    }

    public String getStartVisitDate() {
        return this.startVisitDate;
    }

    public String getOutStoreStartTime() {
        return this.outStoreStartTime;
    }

    public String getOutStoreEndTime() {
        return this.outStoreEndTime;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setVisitBigType(String visitBigType) {
        this.visitBigType = visitBigType;
    }

    public void setVisitRealName(String visitRealName) {
        this.visitRealName = visitRealName;
    }

    public void setVisitPosName(String visitPosName) {
        this.visitPosName = visitPosName;
    }

    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setEndVisitDate(String endVisitDate) {
        this.endVisitDate = endVisitDate;
    }

    public void setStartVisitDate(String startVisitDate) {
        this.startVisitDate = startVisitDate;
    }

    public void setOutStoreStartTime(String outStoreStartTime) {
        this.outStoreStartTime = outStoreStartTime;
    }

    public void setOutStoreEndTime(String outStoreEndTime) {
        this.outStoreEndTime = outStoreEndTime;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetVisitReportsPageReq)) {
            return false;
        }
        GetVisitReportsPageReq other = (GetVisitReportsPageReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$visitBigType = this.getVisitBigType();
        String other$visitBigType = other.getVisitBigType();
        if (this$visitBigType == null ? other$visitBigType != null : !this$visitBigType.equals(other$visitBigType)) {
            return false;
        }
        String this$visitRealName = this.getVisitRealName();
        String other$visitRealName = other.getVisitRealName();
        if (this$visitRealName == null ? other$visitRealName != null : !this$visitRealName.equals(other$visitRealName)) {
            return false;
        }
        String this$visitPosName = this.getVisitPosName();
        String other$visitPosName = other.getVisitPosName();
        if (this$visitPosName == null ? other$visitPosName != null : !this$visitPosName.equals(other$visitPosName)) {
            return false;
        }
        String this$clientCode = this.getClientCode();
        String other$clientCode = other.getClientCode();
        if (this$clientCode == null ? other$clientCode != null : !this$clientCode.equals(other$clientCode)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$endVisitDate = this.getEndVisitDate();
        String other$endVisitDate = other.getEndVisitDate();
        if (this$endVisitDate == null ? other$endVisitDate != null : !this$endVisitDate.equals(other$endVisitDate)) {
            return false;
        }
        String this$startVisitDate = this.getStartVisitDate();
        String other$startVisitDate = other.getStartVisitDate();
        if (this$startVisitDate == null ? other$startVisitDate != null : !this$startVisitDate.equals(other$startVisitDate)) {
            return false;
        }
        String this$outStoreStartTime = this.getOutStoreStartTime();
        String other$outStoreStartTime = other.getOutStoreStartTime();
        if (this$outStoreStartTime == null ? other$outStoreStartTime != null : !this$outStoreStartTime.equals(other$outStoreStartTime)) {
            return false;
        }
        String this$outStoreEndTime = this.getOutStoreEndTime();
        String other$outStoreEndTime = other.getOutStoreEndTime();
        if (this$outStoreEndTime == null ? other$outStoreEndTime != null : !this$outStoreEndTime.equals(other$outStoreEndTime)) {
            return false;
        }
        Integer this$pageNum = this.getPageNum();
        Integer other$pageNum = other.getPageNum();
        if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        return !(this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetVisitReportsPageReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $visitBigType = this.getVisitBigType();
        result = result * 59 + ($visitBigType == null ? 43 : $visitBigType.hashCode());
        String $visitRealName = this.getVisitRealName();
        result = result * 59 + ($visitRealName == null ? 43 : $visitRealName.hashCode());
        String $visitPosName = this.getVisitPosName();
        result = result * 59 + ($visitPosName == null ? 43 : $visitPosName.hashCode());
        String $clientCode = this.getClientCode();
        result = result * 59 + ($clientCode == null ? 43 : $clientCode.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $endVisitDate = this.getEndVisitDate();
        result = result * 59 + ($endVisitDate == null ? 43 : $endVisitDate.hashCode());
        String $startVisitDate = this.getStartVisitDate();
        result = result * 59 + ($startVisitDate == null ? 43 : $startVisitDate.hashCode());
        String $outStoreStartTime = this.getOutStoreStartTime();
        result = result * 59 + ($outStoreStartTime == null ? 43 : $outStoreStartTime.hashCode());
        String $outStoreEndTime = this.getOutStoreEndTime();
        result = result * 59 + ($outStoreEndTime == null ? 43 : $outStoreEndTime.hashCode());
        Integer $pageNum = this.getPageNum();
        result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        return result;
    }

    public String toString() {
        return "GetVisitReportsPageReq(visitBigType=" + this.getVisitBigType() + ", visitRealName=" + this.getVisitRealName() + ", visitPosName=" + this.getVisitPosName() + ", clientCode=" + this.getClientCode() + ", clientName=" + this.getClientName() + ", endVisitDate=" + this.getEndVisitDate() + ", startVisitDate=" + this.getStartVisitDate() + ", outStoreStartTime=" + this.getOutStoreStartTime() + ", outStoreEndTime=" + this.getOutStoreEndTime() + ", pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ")";
    }
}

