/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.mapper.SfaAchievementAccomplishRecordMapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementTimeTotalRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitAndSalesTrendChartRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitRankingDetailedRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitRankingRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoExecuteService;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoRedisDataServiceEsImpl;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitPlanInfoServiceExpandImpl"})
@Transactional
public class SfaVisitPlanInfoServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitPlanInfoMapper, SfaVisitPlanInfoEntity>
implements ISfaVisitPlanInfoService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitPlanInfoServiceImpl.class);
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private RedisService redisService;
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;
    @Resource
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource
    private SfaAchievementAccomplishRecordMapper achievementAccomplishRecordMapper;
    @Resource
    private ISfaVisitPlanInfoExecuteService sfaVisitPlanInfoExecuteService;
    @Resource
    private SfaVisitPlanInfoRedisDataServiceEsImpl sfaVisitPlanInfoRedisDataServiceEsImpl;

    @Override
    public void updateStepStatus(String visitPlanInfoId, SfaCodeEnum.VisitStepCode visitStepCode) {
        UserRedis userRedis = UserUtils.getUser();
        GetVisitListReq req = new GetVisitListReq();
        req.setVisitUserName(userRedis.getUsername());
        req.setVisitPositionCode(userRedis.getPoscode());
        req.setVisitDate(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        Map<String, SfaVisitPlanInfoEntity> planInfoEntities = this.doGetVisitInfoList(req).stream().collect(Collectors.toMap(BaseIdEntity::getId, v -> v, (t, t2) -> t2));
        SfaVisitPlanInfoEntity planInfoEntity = planInfoEntities.get(visitPlanInfoId);
        if (null == planInfoEntity) {
            req.setVisitBigType(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
            planInfoEntities = this.doGetVisitInfoList(req).stream().collect(Collectors.toMap(BaseIdEntity::getId, v -> v, (t, t2) -> t2));
            planInfoEntity = planInfoEntities.get(visitPlanInfoId);
        }
        if (null == planInfoEntity) {
            req.setVisitBigType(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal());
            planInfoEntities = this.doGetVisitInfoList(req).stream().collect(Collectors.toMap(BaseIdEntity::getId, v -> v, (t, t2) -> t2));
            planInfoEntity = planInfoEntities.get(visitPlanInfoId);
        }
        if (null == planInfoEntity) {
            return;
        }
        this.updateStepStatus(planInfoEntity.getRedisHashKey(), visitStepCode.getVal(), planInfoEntity.getVisitBigType());
    }

    @Override
    public void updateStepStatus(String redisHashKey, String stepCode, String visitBigType) {
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate, visitBigType).toString(), (Object)redisHashKey);
        this.changeStepStatus(sfaVisitPlanInfoRedisData, stepCode);
        this.redisService.hmset(sfaVisitPlanInfoRedisData.redisHashCurrent(nowDate, visitBigType).toString(), sfaVisitPlanInfoRedisData.buildRedisDataForWrite(), 691200L);
    }

    @Override
    public void changeStepStatus(SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData, String stepCode) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepCode)) {
            throw new BusinessException("\u6b65\u9aa4\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7c7b\u578b");
        }
        List<VisitStepResp> steps = sfaVisitPlanInfoRedisData.getStep();
        if (null == steps) {
            return;
        }
        for (VisitStepResp step : steps) {
            if (!stepCode.equals(step.getStepCode())) continue;
            step.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
            step.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
            break;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public SfaVisitResp getVisitInfoList(GetVisitListReq req) {
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.doGetVisitInfoList(req);
        List<SfaVisitResp.SfaVisitPlanInfoResp> planInfoResp = this.convertPlanInfoData(planInfoEntities, req);
        SfaVisitResp sfaVisitResp = new SfaVisitResp();
        sfaVisitResp.setPlanInfoEntities(planInfoResp);
        int complete = 0;
        for (SfaVisitPlanInfoEntity planInfoEntity : planInfoEntities) {
            if (!SfaVisitEnum.visitStatus.V3.getVal().equals(planInfoEntity.getVisitStatus()) && !SfaVisitEnum.visitStatus.V4.getVal().equals(planInfoEntity.getVisitStatus())) continue;
            ++complete;
        }
        sfaVisitResp.setTotal(planInfoEntities.size());
        sfaVisitResp.setComplete(complete);
        return sfaVisitResp;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SfaVisitPlanInfoEntity> doGetVisitInfoList(GetVisitListReq req) {
        AssertUtils.isNotEmpty((String)req.getVisitBigType(), (String)"\u8bf7\u6307\u5b9a\u62dc\u8bbf\u5927\u7c7b");
        AssertUtils.isNotEmpty((String)req.getVisitDate(), (String)"\u8bf7\u9009\u62e9\u62dc\u8bbf\u65e5\u671f");
        StringJoiner redisHash = SfaVisitPlanInfoEntity.getInstance().redisHash(req.getVisitDate(), req.getVisitUserName(), req.getVisitPositionCode(), req.getVisitBigType());
        List planInfoEntities = (List)this.redisService.hmValues(redisHash.toString());
        if (null == planInfoEntities) {
            return Lists.newArrayList();
        }
        return planInfoEntities;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SfaVisitPlanInfoEntity> getVisitInfoListByClientType(GetVisitListReq.MoreReq req) {
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.doGetVisitInfoList(req);
        String clientType = req.getClientType();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)clientType)) {
            return planInfoEntities;
        }
        String keyWord = req.getKeyWord();
        return planInfoEntities.stream().filter(v -> {
            if (!clientType.equals(v.getClientType())) {
                return false;
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)keyWord)) {
                if (v.getClientCode().contains(keyWord)) {
                    return true;
                }
                if (v.getClientName().contains(keyWord)) {
                    return true;
                }
            }
            return true;
        }).collect(Collectors.toList());
    }

    private List<SfaVisitResp.SfaVisitPlanInfoResp> convertPlanInfoData(List<SfaVisitPlanInfoEntity> planInfoEntities, GetVisitListReq req) {
        List planInfoResp = CrmBeanUtil.copyList(planInfoEntities, SfaVisitResp.SfaVisitPlanInfoResp.class);
        Map cusType = DictUtil.getDictValueMapsByCodes((String)"sfacusType");
        Map<String, Map<String, VisitStepResp>> stepRespMap = null;
        ArrayList clientTypes = Lists.newArrayList((Iterable)planInfoEntities.stream().map(SfaVisitPlanInfoEntity::getClientType).collect(Collectors.toSet()));
        ArrayList clientSubclassList = Lists.newArrayList((Iterable)planInfoEntities.stream().map(SfaVisitPlanInfoEntity::getClientSubclass).collect(Collectors.toSet()));
        if (planInfoResp.size() > 0) {
            stepRespMap = this.sfaVisitRoleDirectoryService.findRoleVisitStepMapForClientTypes(planInfoEntities.get(0).getVisitPosCode(), clientTypes, req.getVisitBigType(), clientSubclassList);
        }
        for (SfaVisitResp.SfaVisitPlanInfoResp data : planInfoResp) {
            data.setClientTypeName((String)cusType.get(data.getClientType()));
            if (null != data.getDistance()) {
                data.setDistance(data.getDistance().divide(new BigDecimal(1000)).setScale(2, 1));
            }
            String visitUserName = data.getVisitUserName();
            String visitDate = data.getVisitDate();
            Map buttons = SfaVisitEnum.VisitBigType.VISIT.getVal().equals(data.getVisitBigType()) ? SfaVisitEnum.visitButton.buildVisitButton((String)visitUserName, (String)visitDate, (String)data.getVisitStatus()) : (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(data.getVisitBigType()) ? SfaVisitEnum.visitButton.buildHelpVisitButton((String)visitUserName, (String)visitDate, (String)data.getVisitStatus()) : SfaVisitEnum.visitButton.buildVisitUnfamiliarButton((String)visitUserName, (String)visitDate, (String)data.getVisitStatus()));
            data.setButtons(buttons);
            data.buildFormId(stepRespMap);
        }
        return planInfoResp;
    }

    @Override
    public SfaVisitPlanInfoRespVo query(SfaVisitPlanInfoReqVo reqVo) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.getById((Serializable)((Object)reqVo.getId()));
        return (SfaVisitPlanInfoRespVo)CrmBeanUtil.copy((Object)sfaVisitPlanInfoEntity, SfaVisitPlanInfoRespVo.class);
    }

    @Override
    public String checkAddForTempPlan(List<SfaVisitPlanInfoEntity> infoEntities) {
        String redisHash = this.doCheckAddForTempPlan(infoEntities);
        List dbData = (List)this.redisService.hmValues(redisHash);
        if (null == dbData) {
            dbData = Lists.newArrayList();
        }
        Map<String, SfaVisitPlanInfoEntity> objectObjectMap = dbData.stream().collect(Collectors.toMap(SfaVisitPlanInfoEntity::getRedisHashKey, v -> v, (t, t2) -> t2));
        StringJoiner msg = new StringJoiner(",");
        for (SfaVisitPlanInfoEntity infoEntity : infoEntities) {
            if (objectObjectMap.containsKey(infoEntity.getRedisHashKey())) {
                msg.add(infoEntity.getClientName());
            }
            objectObjectMap.put(infoEntity.getRedisHashKey(), infoEntity);
        }
        if (msg.length() > 0) {
            throw new BusinessException("\u5df2\u5b58\u5728[" + msg.toString() + "]\u7684\u62dc\u8bbf\u8ba1\u5212");
        }
        return redisHash;
    }

    @Override
    public void dataDurability(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        this.saveOrUpdate(sfaVisitPlanInfoEntity, sfaVisitPlanInfoRedisData);
        List<VisitStepResp> step = sfaVisitPlanInfoRedisData.getStep();
        if (null != step) {
            ExecutorLoadReq loadReq = new ExecutorLoadReq();
            loadReq.setVisitInfoId(sfaVisitPlanInfoEntity.getId());
            loadReq.setRedisHashKey(sfaVisitPlanInfoEntity.getRedisHashKey());
            for (VisitStepResp stepResp : step) {
                if (SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal().equals(stepResp.getPageCode()) || SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal().equals(stepResp.getPageCode())) {
                    if (!log.isInfoEnabled()) continue;
                    log.info("\u79bb\u5e97\u6253\u5361\u6570\u636e\u4f20\u8f93\u81f3ES:\u5ffd\u7565\u8fdb/\u79bb\u5e97\u6267\u884c\u5668");
                    continue;
                }
                Class<? extends AbstractVisitStepRedisExecutor> clazz = AbstractVisitStepRedisExecutor.VISIT_STEP_EXECUTOR_CLASS_MAPPING.get(stepResp.getPageCode());
                if (null == clazz) {
                    throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[" + stepResp.getPageCode() + "]\u7684\u6267\u884c\u5668\u7c7b\u4fe1\u606f\uff01");
                }
                AbstractVisitStepRedisExecutor visitStepExecutor = (AbstractVisitStepRedisExecutor)SpringApplicationContextUtil.getApplicationContext().getBean(clazz);
                if (null == visitStepExecutor) {
                    throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[" + stepResp.getPageCode() + "]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
                }
                loadReq.setFormId(stepResp.getFormId());
                loadReq.setStepCode(stepResp.getStepCode());
                visitStepExecutor.dataDurability(loadReq, sfaVisitPlanInfoEntity);
            }
        }
        this.sfaVisitPlanInfoServiceEsImpl.save(sfaVisitPlanInfoEntity);
        this.sfaVisitPlanInfoRedisDataServiceEsImpl.save(sfaVisitPlanInfoRedisData);
    }

    @Override
    public void saveOrUpdate(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        this.saveOrUpdate(sfaVisitPlanInfoEntity);
        SfaVisitPlanInfoExecuteRedisData redisData = sfaVisitPlanInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        this.sfaVisitPlanInfoExecuteService.saveOrUpdate((Object)redisData);
    }

    @Override
    @CrmDictMethod
    @Deprecated
    public void update(SfaVisitPlanInfoReqVo reqVo) {
        SfaVisitPlanInfoEntity entity = (SfaVisitPlanInfoEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    public void deleteBatch(List<String> ids) {
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntities = this.deleteBatchCheck(ids);
        HashMap temp = Maps.newHashMap();
        for (SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity : sfaVisitPlanInfoEntities) {
            String redisHash2 = sfaVisitPlanInfoEntity.redisHash().toString();
            List list = (List)temp.get(redisHash2);
            if (null == list) {
                list = Lists.newArrayList();
            }
            list.add(sfaVisitPlanInfoEntity);
            temp.put(redisHash2, list);
        }
        temp.forEach((redisHash, infoEntities) -> {
            List<String> redisHashKeys = infoEntities.stream().map(SfaVisitPlanInfoEntity::getRedisHashKey).collect(Collectors.toList());
            Object[] redisHashKey = redisHashKeys.toArray(new String[redisHashKeys.size()]);
            this.redisService.hdel(redisHash, redisHashKey);
        });
        this.sfaVisitPlanInfoServiceEsImpl.deleteByIds(ids);
    }

    private List<SfaVisitPlanInfoEntity> deleteBatchCheck(List<String> ids) {
        boolean forWebTemp = false;
        if (LoginFromTypeEnum.CONSOLE.getValue().equals(UserUtils.getUser().getFromtype())) {
            forWebTemp = true;
        }
        boolean forWeb = forWebTemp;
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u5b58\u5728\uff01");
        }
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoServiceEsImpl.findByIds(ids);
        if (org.springframework.util.CollectionUtils.isEmpty(sfaVisitPlanInfoEntities)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u8ba1\u5212\u6570\u636e");
        }
        LocalDate nowDate = LocalDate.now();
        sfaVisitPlanInfoEntities.forEach(plan -> {
            LocalDate visitDate = LocalDate.parse(plan.getVisitDate(), CrmDateUtils.yyyyMMdd);
            if (nowDate.compareTo(visitDate) > 0) {
                throw new BusinessException("\u4e0d\u53ef\u5220\u9664\u5386\u53f2\u62dc\u8bbf\u8ba1\u5212");
            }
            if (!SfaVisitEnum.visitStatus.V1.getVal().equals(plan.getVisitStatus())) {
                throw new BusinessException("\u53ea\u80fd\u5220\u9664\u672a\u62dc\u8bbf\u7684\u8ba1\u5212");
            }
            SfaVisitPlanInfoEntity redisData = (SfaVisitPlanInfoEntity)this.redisService.hmget(plan.redisHash().toString(), (Object)plan.getRedisHashKey());
            if (null != redisData && !SfaVisitEnum.visitStatus.V1.getVal().equals(plan.getVisitStatus())) {
                throw new BusinessException("\u53ea\u80fd\u5220\u9664\u672a\u62dc\u8bbf\u7684\u8ba1\u5212");
            }
            if (!forWeb && !SfaVisitEnum.visitType.TEMP_VISIT.getVal().equals(plan.getVisitType()) && nowDate.compareTo(visitDate) == 0) {
                throw new BusinessException("\u4e0d\u80fd\u5728\u79fb\u52a8\u7aef\u5220\u9664\u5f53\u5929\u7684\u975e\u4e34\u65f6\u62dc\u8bbf\u8ba1\u5212");
            }
        });
        return sfaVisitPlanInfoEntities;
    }

    @Override
    @CrmDictMethod
    @Deprecated
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u5b58\u5728\uff01");
        }
        List sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanInfoEntities)) {
            sfaVisitPlanInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }

    @Override
    @CrmDictMethod
    @Deprecated
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u5b58\u5728\uff01");
        }
        List sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanInfoEntities)) {
            sfaVisitPlanInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }

    private String doCheckAddForTempPlan(List<SfaVisitPlanInfoEntity> infoEntities) {
        if (org.springframework.util.CollectionUtils.isEmpty(infoEntities)) {
            throw new BusinessException("\u6ca1\u6709\u53ef\u6dfb\u52a0\u7684\u4e34\u65f6\u8ba1\u5212");
        }
        StringJoiner joiner = new StringJoiner(":");
        joiner.add("SFA_VISIT").add("sfa_visit_plan_info").add(infoEntities.get(0).getVisitUserName()).add(infoEntities.get(0).getVisitPosCode()).add(infoEntities.get(0).getVisitDate());
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode((String)infoEntities.get(0).getVisitOrgCode());
        for (SfaVisitPlanInfoEntity infoEntity : infoEntities) {
            if (null == mdmOrgRespVo) continue;
            infoEntity.setParentOrgCode(mdmOrgRespVo.getParentCode());
            infoEntity.setParentOrgName(mdmOrgRespVo.getParentName());
        }
        return infoEntities.get(0).redisHash().toString();
    }

    @Override
    public List<SfaVisitAndSalesTrendChartRespVo> findVisiAndSalesTrendChart() {
        UserRedis userRedis = UserUtils.getUser();
        String monthsStr = ParamUtil.getParameterValue((String)"visi_sales_months");
        Integer months = ParameterParam.VISI_SALES_MONTHS_DEFAULT_VALUE;
        if (StringUtils.isNotEmpty((String)monthsStr)) {
            months = Integer.valueOf(monthsStr);
        }
        ArrayList<String> monthsList = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        monthsList.add(DateUtil.yyyy_MM.format(calendar.getTime()));
        for (int i = 1; i < months; ++i) {
            calendar.add(2, -1);
            monthsList.add(DateUtil.yyyy_MM.format(calendar.getTime()));
        }
        List<SfaAchievementTimeTotalRespVo> accomplishVisitNum = this.achievementAccomplishRecordMapper.findAccomplishNumByYm(userRedis.getPoscode(), SfaVisitEnum.indexType.WDBF.getCode(), monthsList);
        List visitList = accomplishVisitNum.stream().map(a -> new SfaVisitAndSalesTrendChartRespVo(a.getTimeOfPeriod(), new BigDecimal(a.getAccomplishNum()), new BigDecimal(0))).collect(Collectors.toList());
        Map<String, BigDecimal> visitMap = visitList.stream().collect(Collectors.toMap(SfaVisitAndSalesTrendChartRespVo::getYearMonth, SfaVisitAndSalesTrendChartRespVo::getVisitNumber));
        List<SfaAchievementTimeTotalRespVo> accomplishOrderNum = this.achievementAccomplishRecordMapper.findAccomplishNumByYm(userRedis.getPoscode(), SfaVisitEnum.indexType.XD.getCode(), monthsList);
        List salesList = accomplishOrderNum.stream().map(a -> new SfaVisitAndSalesTrendChartRespVo(a.getTimeOfPeriod(), new BigDecimal(0), new BigDecimal(a.getAccomplishNum()))).collect(Collectors.toList());
        Map<String, BigDecimal> salesMap = salesList.stream().collect(Collectors.toMap(SfaVisitAndSalesTrendChartRespVo::getYearMonth, SfaVisitAndSalesTrendChartRespVo::getSalesNumber));
        ArrayList<SfaVisitAndSalesTrendChartRespVo> voList = new ArrayList<SfaVisitAndSalesTrendChartRespVo>();
        Collections.sort(monthsList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer m1 = Integer.valueOf(o1.split("-")[0]) * 100 + Integer.valueOf(o1.split("-")[1]);
                Integer m2 = Integer.valueOf(o2.split("-")[0]) * 100 + Integer.valueOf(o2.split("-")[1]);
                return Integer.compare(m1, m2);
            }
        });
        String[] CN_CHARS = new String[]{"", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
        for (String monthsx : monthsList) {
            SfaVisitAndSalesTrendChartRespVo vo = new SfaVisitAndSalesTrendChartRespVo();
            vo.setYearMonth(monthsx);
            Integer month = Integer.valueOf(monthsx.split("-")[1]);
            vo.setMonthDes(CN_CHARS[month] + "\u6708");
            if (visitMap.containsKey(monthsx)) {
                vo.setVisitNumber(visitMap.get(monthsx));
            }
            if (salesMap.containsKey(monthsx)) {
                vo.setSalesNumber(salesMap.get(monthsx));
            }
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public SfaVisitRankingRespVo findVisitRankingList() {
        UserRedis userRedis = UserUtils.getUser();
        String daysStr = ParamUtil.getParameterValue((String)"visit_ranking_cycle");
        Integer days = ParameterParam.VISIT_RANKING_CYCLE_DEFAULT_VALUE;
        if (StringUtils.isNotEmpty((String)daysStr)) {
            days = Integer.valueOf(daysStr);
        }
        SfaVisitRankingRespVo respVo = new SfaVisitRankingRespVo();
        respVo.setDays(days);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        String endDate = DateUtil.date_sdf.format(calendar.getTime());
        calendar.add(5, -1 * (days - 1));
        String startDate = DateUtil.date_sdf.format(calendar.getTime());
        List positionRespVoList = PositionUtil.getChildrenPositionListExcludeSelf((String)userRedis.getPoscode());
        ArrayList<String> posCodeList = new ArrayList<String>();
        for (MdmPositionRespVo positionResp : positionRespVoList) {
            posCodeList.add(positionResp.getPositionCode());
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero(posCodeList)) {
            return respVo;
        }
        List positionUserList = (List)this.mdmPositionFeign.detailBatchByPositionCodeList(posCodeList).getResult();
        ArrayList<String> positionCodeList = new ArrayList<String>();
        HashMap<String, MdmPositionUserOrgRespVo> positionUserMap = new HashMap<String, MdmPositionUserOrgRespVo>();
        for (MdmPositionUserOrgRespVo positionUser : positionUserList) {
            positionCodeList.add(positionUser.getPositionCode());
            positionUserMap.put(positionUser.getPositionCode(), positionUser);
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            return respVo;
        }
        List<SfaAchievementTimeTotalRespVo> accomplishNum = this.achievementAccomplishRecordMapper.findPosCodeListAccomplishNum(positionCodeList, SfaVisitEnum.indexType.WDBF.getCode(), startDate, endDate);
        List respVoList = accomplishNum.stream().map(a -> new SfaVisitRankingDetailedRespVo(a.getPosCode(), new BigDecimal(a.getAccomplishNum()))).collect(Collectors.toList());
        ArrayList<SfaVisitRankingDetailedRespVo> detailedList = new ArrayList<SfaVisitRankingDetailedRespVo>();
        String topfewStr = ParamUtil.getParameterValue((String)"visit_ranking_topfew");
        Integer topfew = ParameterParam.VISIT_RANKING_TOPFEW_DEFAULT_VALUE;
        if (StringUtils.isNotEmpty((String)topfewStr)) {
            topfew = Integer.valueOf(topfewStr);
        }
        for (int i = 0; i < topfew && i < respVoList.size(); ++i) {
            SfaVisitRankingDetailedRespVo detailedRespVo = (SfaVisitRankingDetailedRespVo)respVoList.get(i);
            MdmPositionUserOrgRespVo positionUser = (MdmPositionUserOrgRespVo)positionUserMap.get(detailedRespVo.getPoscode());
            detailedRespVo.setPosname(positionUser.getPositionName());
            detailedRespVo.setUsername(positionUser.getUserName());
            detailedRespVo.setRealname(positionUser.getFullName());
            detailedList.add(detailedRespVo);
        }
        respVo.setDetailedList(detailedList);
        return respVo;
    }
}

