/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.enums.SfaWorkSummaryEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderMapper;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEsData;
import com.biz.crm.visitstep.model.SfaVisitStepOrderItemEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepOrderEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.google.common.collect.Lists;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepOrderServiceExpandImpl"})
public class SfaVisitStepOrderServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepOrderMapper, SfaVisitStepOrderEntity>
implements ISfaVisitStepOrderService,
VisitDataDurabilityService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepOrderServiceImpl.class);
    @Resource
    private ISfaVisitStepOrderItemService sfaVisitStepOrderItemService;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;
    @Resource
    private SfaVisitStepOrderEsDataRepositories sfaVisitStepOrderEsDataRepositories;

    @Override
    @Transactional
    public List<? extends VisitStepListener.VisitStepListenerCommittedData> dataDurability(List<? extends VisitStepListener.VisitStepListenerCommittedData> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
        if (CollectionUtils.isEmpty(baseEntity)) {
            return Lists.newArrayList();
        }
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)baseEntity.get(0);
        baseEntity = Lists.newArrayList((Object[])new SfaVisitStepOrderRedisData[]{this.save(redisData)});
        this.doTransToEs(redisData, fromRespVo);
        return baseEntity;
    }

    @Override
    @Transactional
    public SfaVisitStepOrderRedisData save(SfaVisitStepOrderRedisData redisData) {
        if (StringUtils.isBlank((CharSequence)redisData.getOrderCode())) {
            redisData.setOrderCode(CodeUtil.getCodeDefault());
        }
        this.saveOrUpdate(redisData);
        List<OrderAsDataReq.OrderItemAsReqVo> orderItems = redisData.getSfaVisitStepOrderItems();
        if (!CollectionUtils.isEmpty(orderItems)) {
            List itemEntities = orderItems.stream().map(v -> {
                SfaVisitStepOrderItemEntity copy = (SfaVisitStepOrderItemEntity)((Object)((Object)CrmBeanUtil.copy((Object)v, SfaVisitStepOrderItemEntity.class)));
                copy.setOrderId(redisData.getId());
                return copy;
            }).collect(Collectors.toList());
            this.sfaVisitStepOrderItemService.saveBatch(itemEntities);
        }
        return redisData;
    }

    protected void doTransToEs(SfaVisitStepOrderRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepOrderEsData oldData;
        SfaVisitStepOrderEsData dataResp = (SfaVisitStepOrderEsData)CrmBeanUtil.copy((Object)redisData, SfaVisitStepOrderEsData.class);
        dataResp.setSfaVisitStepOrderItems(redisData.getSfaVisitStepOrderItems());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        if (StringUtils.isNotBlank((CharSequence)dataResp.getVisitPlanInfoId()) && null != (oldData = this.sfaVisitStepOrderEsDataRepositories.findByVisitPlanInfoIdAndStepCode(dataResp.getVisitPlanInfoId(), dataResp.getStepCode()))) {
            dataResp.setId(oldData.getId());
            dataResp.setOrderCode(oldData.getOrderCode());
        }
        if (StringUtils.isBlank((CharSequence)dataResp.getOrderCode())) {
            redisData.setOrderCode(CodeUtil.generateCode((String)SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
        }
        this.sfaVisitStepOrderEsDataRepositories.save(dataResp);
    }

    @Override
    public List<MdmTerminalSupplyVo> findTerminalSupplyList(String terminalCode) {
        List mdmTerminalSupplyVos = Lists.newArrayList();
        Result mdmTerminalVoResult = this.mdmTerminalFeign.query(null, terminalCode);
        if (mdmTerminalVoResult.isSuccess() && mdmTerminalVoResult.getResult() != null && CollectionUtil.listNotEmptyNotSizeZero((List)((MdmTerminalVo)mdmTerminalVoResult.getResult()).getSupplys())) {
            mdmTerminalSupplyVos = ((MdmTerminalVo)mdmTerminalVoResult.getResult()).getSupplys();
        }
        return mdmTerminalSupplyVos;
    }

    @Override
    public Integer getOrderNum(String dateFlag2) {
        AssertUtils.isNotEmpty((String)dateFlag2, (String)"\u8bf7\u4f20\u5165\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u7c7b\u578b\u2014\u2014\u672c\u65e5\u3001\u672c\u5468\u3001\u672c\u6708");
        UserRedis user = UserUtils.getUser();
        LocalDate nowTime = LocalDate.now();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(SfaAchievementAccomplishRecordEntity::getIndexCode, (Object)SfaVisitEnum.indexType.XD.getCode())).eq(CrmBaseEntity::getCreateCode, (Object)user.getUsername());
        if (SfaWorkSummaryEnum.dateFlag.TODAY.getCode().equals(dateFlag2)) {
            String dayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
            queryWrapper.eq(CrmBaseEntity::getCreateDate, (Object)dayTime);
        }
        if (SfaWorkSummaryEnum.dateFlag.WEEK.getCode().equals(dateFlag2)) {
            String weekTime = nowTime.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).format(CrmDateUtils.yyyyMMdd);
            String nowDayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
            queryWrapper.between(CrmBaseEntity::getCreateDate, (Object)weekTime, (Object)nowDayTime);
        }
        if (SfaWorkSummaryEnum.dateFlag.MONTH.getCode().equals(dateFlag2)) {
            String monthTime = nowTime.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            queryWrapper.like(CrmBaseEntity::getCreateDate, (Object)monthTime);
        }
        int count = this.sfaAchievementAccomplishRecordService.count((Wrapper)queryWrapper);
        return count;
    }
}

