/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.CrmIdsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelApplyReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.service.ISfaTravelService;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/moblie/SfaTravel"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u5de5\u4f5c\u53f0\u9875\u9762-\u51fa\u5dee "})
public class SfaTravelMoblieController {
    private static final Logger log = LoggerFactory.getLogger(SfaTravelMoblieController.class);
    @Autowired
    private ISfaTravelService iSfaTravelService;

    @ApiOperation(value="\u51fa\u5dee\u7533\u8bf7")
    @PostMapping(value={"/goApplyTravel"})
    @CrmLog
    public Result goApplyTravel(@RequestBody SfaTravelApplyReqVo reqVo) {
        Result result = this.iSfaTravelService.goApplyTravel(reqVo);
        return result;
    }

    @ApiOperation(value="\u6211\u7684\u7533\u8bf7\u5217\u8868")
    @PostMapping(value={"/findSfaTravelList"})
    @CrmLog
    public Result<PageResult<SfaTravelRespVo>> findSfaTravelList(@RequestBody SfaTravelReqVo sfaLeaveReqVo) {
        PageResult<SfaTravelRespVo> result = new PageResult<SfaTravelRespVo>();
        UserRedis userRedis = UserUtils.getUser();
        if (null != userRedis && StringUtil.isNotEmpty((String)userRedis.getUsername())) {
            sfaLeaveReqVo.setMyApply(userRedis.getUsername());
            result = this.iSfaTravelService.findList(sfaLeaveReqVo);
        }
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<SfaTravelRespVo> query(String id) {
        return Result.ok((Object)this.iSfaTravelService.query(id));
    }

    @ApiOperation(value="\u51fa\u5dee-\u8ffd\u56de")
    @PostMapping(value={"/rollback"})
    @CrmLog
    public Result rollback(@RequestBody CrmIdsReqVo idsReqVo) {
        AssertUtils.isNotEmpty((Collection)idsReqVo.getIds(), (String)"\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        return this.iSfaTravelService.rollback((String)idsReqVo.getIds().get(0));
    }
}

