/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.controller;

import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.sfa.customer.req.SfaCustomerBusinessDetailReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfaBusinessDetailSaveMQSend {
    private static final Logger log = LoggerFactory.getLogger(SfaBusinessDetailSaveMQSend.class);
    private static RocketMQProducer rocketMQProducer = (RocketMQProducer)SpringApplicationContextUtil.getApplicationContext().getBean(RocketMQProducer.class);

    public static void saveBusinessDetail(List<? extends VisitStepListener.VisitStepListenerCommittedData> entities) {
        UserRedis user = UserUtils.getUser();
        List reqVos = CrmBeanUtil.copyList(entities, SfaCustomerBusinessDetailReqVo.class);
        reqVos.forEach(o -> {
            o.setBusinessCode(o.getId());
            o.setBusinessType((String)SfaCodeEnum.VisitStepCode.GETMAP.get(o.getStepCode()));
            o.setCreateCode(user.getUsername()).setCreateName(user.getRealname()).setCreatePosCode(user.getPoscode()).setCreatePosName(user.getPosname()).setCreateOrgCode(user.getOrgcode()).setCreateOrgName(user.getOrgname());
        });
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("CUSTOMER_BUSINESS_DETAIL_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)reqVos));
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }
}

