/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.VisitInfoPlanListener;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractVisitInfoPlanListener
implements VisitInfoPlanListener {
    public static final Map<String, List<Class<? extends AbstractVisitInfoPlanListener>>> VISIT_STEP_LISTENER_CLASS_MAPPING = new HashMap<String, List<Class<? extends AbstractVisitInfoPlanListener>>>();

    @PostConstruct
    public final void constructed() {
        String visitBigType = this.visitBigTypeRegistry();
        if (StringUtils.isBlank((CharSequence)visitBigType)) {
            throw new BusinessException("\u62dc\u8bbf\u6b65\u9aa4\u76d1\u542c\u5668\u6ce8\u518c\u5931\u8d25: \u8bf7\u6307\u5b9a\u6b65\u9aa4\u76d1\u542c\u5668[" + this.getClass().getName() + "]\u7684\u62dc\u8bbf\u6b65\u9aa4\u7f16\u7801");
        }
        ArrayList classes = VISIT_STEP_LISTENER_CLASS_MAPPING.get(visitBigType);
        if (null == classes) {
            classes = Lists.newArrayList();
        }
        classes.add(this.getClass());
        VISIT_STEP_LISTENER_CLASS_MAPPING.put(visitBigType, classes);
    }

    protected abstract String visitBigTypeRegistry();

    public void doListenerEvent(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        VisitInfoPlanListener.DoneEvent doneEvent = new VisitInfoPlanListener.DoneEvent();
        doneEvent.setPlanInfoEntity(sfaVisitPlanInfoEntity);
        doneEvent.setSfaVisitPlanInfoRedisData(sfaVisitPlanInfoRedisData);
        if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitBigType())) {
            if (SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.begin(doneEvent);
            }
            if (SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus()) || SfaVisitEnum.HelpVisitStatus.EX.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.committed(doneEvent);
            }
            if (SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.noCommit(doneEvent);
            }
            if (SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.overdue(doneEvent);
            }
        } else {
            if (SfaVisitEnum.visitStatus.V2.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.begin(doneEvent);
            }
            if (SfaVisitEnum.visitStatus.V3.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus()) || SfaVisitEnum.visitStatus.V4.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.committed(doneEvent);
            }
            if (SfaVisitEnum.visitStatus.V5.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.noCommit(doneEvent);
            }
            if (SfaVisitEnum.visitStatus.V6.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.overdue(doneEvent);
            }
        }
    }
}

