/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.req.PlanInfoSettlementReq;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class VisitPlanInfoHelper {
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    private RedisService redisService;

    public void planInfoSettlementForWeb(PlanInfoSettlementReq req) {
        this.planInfoSettlement(req);
    }

    public void planInfoSettlement(PlanInfoSettlementReq req) {
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.loadUserVisitPlan(req);
        for (SfaVisitPlanInfoEntity planInfoEntity : planInfoEntities) {
            SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = null;
            if (this.hasRedisData(planInfoEntity)) {
                sfaVisitPlanInfoRedisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(planInfoEntity.getVisitDate(), planInfoEntity.getVisitBigType()).toString(), (Object)planInfoEntity.getRedisHashKey());
            }
            this.sfaVisitPlanInfoService.dataDurability(planInfoEntity, sfaVisitPlanInfoRedisData);
            this.redisService.hmset(planInfoEntity.redisHashCurrent(planInfoEntity.getVisitDate(), planInfoEntity.getVisitBigType()).toString(), planInfoEntity.buildRedisDataForWrite(), 1296000L);
            if (null == sfaVisitPlanInfoRedisData) continue;
            this.redisService.hmset(sfaVisitPlanInfoRedisData.redisHashCurrent(planInfoEntity.getVisitDate(), planInfoEntity.getVisitBigType()).toString(), sfaVisitPlanInfoRedisData.buildRedisDataForWrite(), 1296000L);
        }
    }

    private boolean hasRedisData(SfaVisitPlanInfoEntity planInfoEntity) {
        return SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(planInfoEntity.getVisitBigType()) ? SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(planInfoEntity.getVisitStatus()) : SfaVisitEnum.visitStatus.V5.getVal().equals(planInfoEntity.getVisitStatus());
    }

    private List<SfaVisitPlanInfoEntity> loadUserVisitPlan(PlanInfoSettlementReq settlementReq) {
        GetVisitListReq req = (GetVisitListReq)CrmBeanUtil.copy((Object)settlementReq, GetVisitListReq.class);
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        List<SfaVisitPlanInfoEntity> planInfoTemps = this.sfaVisitPlanInfoService.doGetVisitInfoList(req);
        req.setVisitBigType(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
        planInfoTemps.addAll(this.sfaVisitPlanInfoService.doGetVisitInfoList(req));
        req.setVisitBigType(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal());
        planInfoTemps.addAll(this.sfaVisitPlanInfoService.doGetVisitInfoList(req));
        List<SfaVisitPlanInfoEntity> planInfoEntities = planInfoTemps.stream().filter(v -> {
            if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(v.getVisitBigType())) {
                if (SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal());
                    v.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getDesc());
                    return true;
                }
                if (SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal());
                    v.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getDesc());
                    v.setRemarks("\u8be5\u7528\u6237\u5728\u6267\u884c\u4e1a\u52a1\u65f6\u672a\u4e3b\u52a8\u63d0\u4ea4\u6267\u884c\u6570\u636e\uff08\u4efb\u52a1/\u540e\u53f0\u6279\u91cf\u7ed3\u7b97\uff09");
                    return true;
                }
            } else {
                if (SfaVisitEnum.visitStatus.V1.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.visitStatus.V6.getVal());
                    v.setVisitStatusName(SfaVisitEnum.visitStatus.V6.getDesc());
                    return true;
                }
                if (SfaVisitEnum.visitStatus.V2.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.visitStatus.V5.getVal());
                    v.setVisitStatusName(SfaVisitEnum.visitStatus.V5.getDesc());
                    v.setRemarks("\u8be5\u7528\u6237\u5728\u6267\u884c\u4e1a\u52a1\u65f6\u672a\u4e3b\u52a8\u63d0\u4ea4\u6267\u884c\u6570\u636e\uff08\u4efb\u52a1/\u540e\u53f0\u6279\u91cf\u7ed3\u7b97\uff09");
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        return planInfoEntities;
    }
}

