/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.component.resolver.impl;

import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;
import com.biz.crm.visitnote.service.component.resolver.impl.AbstractSfaVisitPlanResolver;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="outletsResolver")
public class SfaVisitPlanOutletsResolver
extends AbstractSfaVisitPlanResolver {
    @Override
    public void doResolve(SfaVisitPlanExecuteContext context) {
        LocalDate visitDate;
        SfaVisitPlanExecuteContext.FuturePlanInfo futurePlanInfo = new SfaVisitPlanExecuteContext.FuturePlanInfo();
        SfaVisitPlanEntity currentPlanEntity = context.getCurrentPlanEntity();
        while (null != (visitDate = this.visitDateNext(context, futurePlanInfo))) {
            List<SfaVisitPlanInfoEntity> planInfoEntities = this.produceOutlets(context);
            futurePlanInfo.putPlan(visitDate, planInfoEntities);
        }
        context.getPlanCodeMapFuturePlanInfo().put(currentPlanEntity.getVisitPlanCode(), futurePlanInfo);
    }

    private List<SfaVisitPlanInfoEntity> produceOutlets(SfaVisitPlanExecuteContext context) {
        Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange = context.getPlanCodeMapPlanRange();
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        List<SfaVisitPlanRangeEntity> planRangeEntities = planCodeMapPlanRange.get(sfaVisitPlanEntity.getVisitPlanCode());
        ArrayList planInfoEntities = Lists.newArrayList();
        planRangeEntities.forEach(data -> {
            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanEntity), SfaVisitPlanInfoEntity.class);
            sfaVisitPlanInfoEntity.setVisitType(sfaVisitPlanEntity.getPlanType());
            sfaVisitPlanInfoEntity.setVisitTypeName((String)SfaVisitEnum.visitType.GETMAP.get(sfaVisitPlanEntity.getPlanType()));
            sfaVisitPlanInfoEntity.setClientType(data.getClientType());
            sfaVisitPlanInfoEntity.setClientTypeName((String)SfaVisitEnum.ClientType.GETMAP.get(sfaVisitPlanInfoEntity.getClientType()));
            sfaVisitPlanInfoEntity.setClientCode(data.getClientCode());
            sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
            sfaVisitPlanInfoEntity.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
            sfaVisitPlanInfoEntity.setVisitDate(context.getVisitDate().format(CrmDateUtils.yyyyMMdd));
            sfaVisitPlanInfoEntity.setVisitDateOfYearMonth(context.getVisitDate().format(CrmDateUtils.yyyyMM));
            sfaVisitPlanInfoEntity.setVisitDateOfYear(context.getVisitDate().format(CrmDateUtils.yyyy));
            sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
            sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.VISIT.getDesc());
            sfaVisitPlanInfoEntity.setId(UUIDGenerator.generate());
            CrmBaseEntity.buildDefEntityData((CrmBaseEntity)sfaVisitPlanInfoEntity);
            planInfoEntities.add(sfaVisitPlanInfoEntity);
        });
        return planInfoEntities;
    }
}

