/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.req;

import com.biz.crm.util.StringUtils;
import com.biz.crm.visitstep.req.VisitStepPageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@ApiModel(value="\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u62a5\u8868")
public class GetOrderPageTableReq
extends VisitStepPageReq {
    @ApiModelProperty(value="\u8ba2\u5355\u7f16\u53f7")
    private String orderCode;
    @ApiModelProperty(value="\u5ba2\u6237\u7f16\u7801")
    private String clientCode;
    @ApiModelProperty(value="\u4eba\u5458\u540d\u79f0")
    private String realName;

    public NativeSearchQuery buildQuery() {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty((String)this.getClientCode())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode.keyword", (String)this.getClientCode()));
        }
        if (StringUtils.isNotEmpty((String)this.getOrderCode())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderCode.keyword", (String)this.getOrderCode()));
        }
        if (StringUtils.isNotEmpty((String)this.getRealName())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"realName.keyword", (String)this.getRealName()));
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)(this.getPageNum() - 1), (int)this.getPageSize()));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"orderTime").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetOrderPageTableReq)) {
            return false;
        }
        GetOrderPageTableReq other = (GetOrderPageTableReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$orderCode = this.getOrderCode();
        String other$orderCode = other.getOrderCode();
        if (this$orderCode == null ? other$orderCode != null : !this$orderCode.equals(other$orderCode)) {
            return false;
        }
        String this$clientCode = this.getClientCode();
        String other$clientCode = other.getClientCode();
        if (this$clientCode == null ? other$clientCode != null : !this$clientCode.equals(other$clientCode)) {
            return false;
        }
        String this$realName = this.getRealName();
        String other$realName = other.getRealName();
        return !(this$realName == null ? other$realName != null : !this$realName.equals(other$realName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetOrderPageTableReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $orderCode = this.getOrderCode();
        result = result * 59 + ($orderCode == null ? 43 : $orderCode.hashCode());
        String $clientCode = this.getClientCode();
        result = result * 59 + ($clientCode == null ? 43 : $clientCode.hashCode());
        String $realName = this.getRealName();
        result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GetOrderPageTableReq(orderCode=" + this.getOrderCode() + ", clientCode=" + this.getClientCode() + ", realName=" + this.getRealName() + ")";
    }
}

