/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepStoreCheckMapper;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEntity;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEsData;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepStoreCheckEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepStoreCheckService;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepStoreCheckServiceExpandImpl"})
public class SfaVisitStepStoreCheckServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepStoreCheckMapper, SfaVisitStepStoreCheckEntity>
implements ISfaVisitStepStoreCheckService,
VisitDataDurabilityService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepStoreCheckServiceImpl.class);
    @Resource
    private SfaVisitStepStoreCheckEsDataRepositories sfaVisitStepStoreCheckEsDataRepositories;

    @Override
    @Transactional
    public List<? extends VisitStepListener.VisitStepListenerCommittedData> dataDurability(List<? extends VisitStepListener.VisitStepListenerCommittedData> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
        if (CollectionUtils.isEmpty(baseEntity)) {
            return Lists.newArrayList();
        }
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)baseEntity.get(0);
        baseEntity = Lists.newArrayList((Object[])new SfaVisitStepStoreCheckRedisData[]{this.save(redisData)});
        this.doTransToEs(redisData, fromRespVo);
        return baseEntity;
    }

    @Override
    @Transactional
    public SfaVisitStepStoreCheckRedisData save(SfaVisitStepStoreCheckRedisData redisData) {
        redisData.setId(redisData.getVisitPlanInfoId());
        this.saveOrUpdate(redisData);
        SfaAttachmentUtil.insert(this.buildAttachmentList(redisData));
        return redisData;
    }

    protected List<SfaAttachmentEntity> buildAttachmentList(SfaVisitStepStoreCheckRedisData redisData) {
        List<SfaAttachmentEntity> entities = SfaAttachmentUtil.build(redisData.getRegularShelfDisplayList(), AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY, redisData.getId());
        entities.addAll(SfaAttachmentUtil.build(redisData.getMaterialDisplayList(), AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY, redisData.getId()));
        entities.addAll(SfaAttachmentUtil.build(redisData.getPriceList(), AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE, redisData.getId()));
        return entities;
    }

    protected void doTransToEs(SfaVisitStepStoreCheckRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepStoreCheckEsData oldData;
        SfaVisitStepStoreCheckEsData dataResp = (SfaVisitStepStoreCheckEsData)CrmBeanUtil.copy((Object)redisData, SfaVisitStepStoreCheckEsData.class);
        dataResp.setRegularShelfDisplayList(redisData.getRegularShelfDisplayList());
        dataResp.setMaterialDisplayList(redisData.getMaterialDisplayList());
        dataResp.setPriceList(redisData.getPriceList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        if (StringUtils.isNotBlank((CharSequence)dataResp.getVisitPlanInfoId()) && null != (oldData = this.sfaVisitStepStoreCheckEsDataRepositories.findByVisitPlanInfoIdAndStepCode(dataResp.getVisitPlanInfoId(), dataResp.getStepCode()))) {
            dataResp.setId(oldData.getId());
        }
        this.sfaVisitStepStoreCheckEsDataRepositories.save(dataResp);
    }
}

