/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DistanceUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.mapper.SfaVisitCompleteInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitCompleteInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoEntityRepositories;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoRedisDataRepositories;
import com.biz.crm.visitinfo.req.VisitCompleteInfoSearchReqVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitCompleteInfoRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitPlanRouteRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitRealRouteRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitRouteRespVo;
import com.biz.crm.visitinfo.service.ISfaVisitCompleteInfoService;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitCompleteInfoServiceExpandImpl"})
public class SfaVisitCompleteInfoServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitCompleteInfoMapper, SfaVisitCompleteInfoEntity>
implements ISfaVisitCompleteInfoService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitCompleteInfoServiceImpl.class);
    @Resource
    private SfaVisitPlanInfoEntityRepositories sfaVisitPlanInfoEntityRepositories;
    @Resource
    private SfaVisitCompleteInfoMapper sfaVisitCompleteInfoMapper;
    @Resource
    private SfaVisitPlanInfoRedisDataRepositories sfaVisitPlanInfoRedisDataRepositories;
    @Resource
    private MdmUserFeign mdmUserFeign;

    @Override
    public PageResult<SfaVisitCompleteInfoRespVo> getVisitCompleteInfoDailyList(VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        Page page = new Page((long)visitCompleteInfoSearchReqVo.getPageNum().intValue(), (long)visitCompleteInfoSearchReqVo.getPageSize().intValue());
        LambdaQueryWrapper<SfaVisitCompleteInfoEntity> queryWrapper = this.getQueryToGetList(visitCompleteInfoSearchReqVo);
        Page infoEntityPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        List result = CrmBeanUtil.copyList((List)infoEntityPage.getRecords(), SfaVisitCompleteInfoRespVo.class);
        return PageResult.builder().count(Long.valueOf(infoEntityPage.getTotal())).data(result).build();
    }

    @Override
    public PageResult<SfaVisitCompleteInfoRespVo> getVisitCompleteInfoMonthList(VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        Page page = new Page((long)visitCompleteInfoSearchReqVo.getPageNum().intValue(), (long)visitCompleteInfoSearchReqVo.getPageSize().intValue());
        List<SfaVisitCompleteInfoEntity> visitCompleteInfoMonthList = this.sfaVisitCompleteInfoMapper.getVisitCompleteInfoMonthList((Page<SfaVisitCompleteInfoRespVo>)page, visitCompleteInfoSearchReqVo);
        visitCompleteInfoMonthList.forEach(data -> data.countNotCompleteNumAndPercent());
        List sfaVisitCompleteInfoRespVos = CrmBeanUtil.copyList(visitCompleteInfoMonthList, SfaVisitCompleteInfoRespVo.class);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(sfaVisitCompleteInfoRespVos).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addVisitCompleteInfoDaily(String visitStatus2, String visitBigType, SfaVisitCompleteInfoEntity sfaVisitCompleteInfoEntity) {
        if (!SfaVisitEnum.VisitBigType.VISIT.getVal().equals(visitBigType) && !SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(visitBigType)) {
            return;
        }
        SfaVisitCompleteInfoEntity updateEntity = (SfaVisitCompleteInfoEntity)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaVisitCompleteInfoEntity.class).eq(SfaVisitCompleteInfoEntity::getVisitDate, (Object)sfaVisitCompleteInfoEntity.getVisitDate())).eq(SfaVisitCompleteInfoEntity::getVisitPosCode, (Object)sfaVisitCompleteInfoEntity.getVisitPosCode())));
        if (updateEntity == null) {
            updateEntity = sfaVisitCompleteInfoEntity;
        }
        this.updateCompleteInfo(visitStatus2, visitBigType, updateEntity);
        if (StringUtils.isEmpty((String)updateEntity.getVisitDate())) {
            throw new BusinessException("\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u7a7a");
        }
        updateEntity.setVisitYearMonth(updateEntity.getVisitDate().substring(0, 7));
        this.saveOrUpdate((Object)updateEntity);
    }

    @Override
    public Result<SfaVisitRouteRespVo> dailyCompleteInfo(String date, String posCode) {
        SfaVisitPlanRouteRespVo sfaVisitPlanRouteRespVo;
        MdmUserRespVo mdmUserRespVo;
        AssertUtils.isNotEmpty((String)date, (String)"\u5165\u53c2date\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)posCode, (String)"\u5165\u53c2posCode\u4e3a\u7a7a");
        List<SfaVisitPlanInfoEntity> visitPlanInfoEntities = this.sfaVisitPlanInfoEntityRepositories.findByVisitPosCodeAndVisitDateAndVisitBigType(posCode, date, SfaVisitEnum.VisitBigType.VISIT.getVal());
        List sfaVisitPlanRouteRespVos = CrmBeanUtil.copyList(visitPlanInfoEntities, SfaVisitPlanRouteRespVo.class);
        if (CollectionUtil.listNotEmpty((List)sfaVisitPlanRouteRespVos) && (mdmUserRespVo = (MdmUserRespVo)ApiResultUtil.objResult((Result)this.mdmUserFeign.query(new MdmUserReqVo().setUserName((sfaVisitPlanRouteRespVo = (SfaVisitPlanRouteRespVo)sfaVisitPlanRouteRespVos.get(0)).getVisitUserName())))) != null) {
            String visitUserPhone = mdmUserRespVo.getUserPhone();
            sfaVisitPlanRouteRespVos.forEach(data -> data.setVisitUserPhone(visitUserPhone));
        }
        ArrayList<SfaVisitRealRouteRespVo> sfaVisitRealRouteRespVos = new ArrayList<SfaVisitRealRouteRespVo>();
        List<SfaVisitPlanInfoRedisData> visitRealInfoEntities = this.sfaVisitPlanInfoRedisDataRepositories.findByVisitPosCodeAndVisitDateAndVisitBigTypeAndVisitStatus(posCode, date, SfaVisitEnum.VisitBigType.VISIT.getVal(), SfaVisitEnum.visitStatus.V3.getVal());
        if (CollectionUtil.listNotEmpty(visitRealInfoEntities)) {
            visitRealInfoEntities.forEach(item -> {
                SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = item.getSfaVisitPlanInfoExecuteRedisData();
                SfaVisitRealRouteRespVo routeRespVo = (SfaVisitRealRouteRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanInfoExecuteRedisData), SfaVisitRealRouteRespVo.class);
                routeRespVo.setClientAddress(sfaVisitPlanInfoExecuteRedisData.getInStoreAddress());
                routeRespVo.setLatitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLatitude());
                routeRespVo.setLongitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLongitude());
                routeRespVo.setVisitDate(sfaVisitPlanInfoExecuteRedisData.getInStore());
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime inStore = LocalDateTime.parse(sfaVisitPlanInfoExecuteRedisData.getInStore(), df);
                LocalDateTime outStore = LocalDateTime.parse(sfaVisitPlanInfoExecuteRedisData.getOutStore(), df);
                long inStoreMilli = inStore.toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
                long outStoreMilli = outStore.toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
                LocalDateTime inStoreTimeOut = Instant.ofEpochMilli(outStoreMilli - inStoreMilli).atZone(ZoneOffset.ofHours(8)).toLocalDateTime();
                routeRespVo.setInStoreTime(inStoreTimeOut.format(CrmDateUtils.HHmmss));
                if (item.getLatitude() != null || item.getLongitude() != null) {
                    double latitude = item.getLatitude().doubleValue();
                    double longitude = item.getLongitude().doubleValue();
                    double outStoreLatitude = sfaVisitPlanInfoExecuteRedisData.getOutStoreLatitude().doubleValue();
                    double outStoreLongitude = sfaVisitPlanInfoExecuteRedisData.getOutStoreLongitude().doubleValue();
                    double distance = DistanceUtil.getDistance((double)latitude, (double)longitude, (double)outStoreLatitude, (double)outStoreLongitude);
                    routeRespVo.setDistanceToPlan(distance + "");
                }
                sfaVisitRealRouteRespVos.add(routeRespVo);
            });
        }
        if (CollectionUtil.listNotEmpty(sfaVisitRealRouteRespVos)) {
            sfaVisitRealRouteRespVos.sort(Comparator.comparing(SfaVisitRealRouteRespVo::getOutStore));
        }
        SfaVisitRouteRespVo sfaVisitRouteRespVo = new SfaVisitRouteRespVo();
        sfaVisitRouteRespVo.setPlanInfoList(sfaVisitPlanRouteRespVos);
        sfaVisitRouteRespVo.setRealInfoList(sfaVisitRealRouteRespVos);
        return Result.ok((Object)sfaVisitRouteRespVo);
    }

    private void updateCompleteInfo(String visitStatus2, String visitBigType, SfaVisitCompleteInfoEntity completeInfoEntity) {
        if (SfaVisitEnum.VisitBigType.VISIT.getVal().equals(visitBigType)) {
            if (SfaVisitEnum.visitStatus.V3.getVal().equals(visitStatus2)) {
                completeInfoEntity.addRealCompleteVisitNum();
            }
            if (SfaVisitEnum.visitStatus.V4.getVal().equals(visitStatus2)) {
                completeInfoEntity.addErrorCompleteVisitNum();
            }
            if (SfaVisitEnum.visitStatus.V5.getVal().equals(visitStatus2) || SfaVisitEnum.visitStatus.V6.getVal().equals(visitStatus2) || SfaVisitEnum.visitStatus.V1.getVal().equals(visitStatus2)) {
                completeInfoEntity.addNotCompleteVisitNum();
            }
        } else if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(visitBigType)) {
            if (SfaVisitEnum.visitStatus.V3.getVal().equals(visitStatus2)) {
                completeInfoEntity.addRealCompleteHelpVisitNum();
            }
            if (SfaVisitEnum.visitStatus.V4.getVal().equals(visitStatus2)) {
                completeInfoEntity.addErrorCompleteHelpVisitNum();
            }
            if (SfaVisitEnum.visitStatus.V5.getVal().equals(visitStatus2) || SfaVisitEnum.visitStatus.V6.getVal().equals(visitStatus2) || SfaVisitEnum.visitStatus.V1.getVal().equals(visitStatus2)) {
                completeInfoEntity.addNotCompleteHelpVisitNum();
            }
        } else {
            throw new BusinessException("\u751f\u6210\u62dc\u8bbf\u5b8c\u6210\u62a5\u8868\u6570\u636e\u5f02\u5e38");
        }
        completeInfoEntity.countNotCompleteNumAndPercent();
    }

    private LambdaQueryWrapper<SfaVisitCompleteInfoEntity> getQueryToGetList(VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(SfaVisitCompleteInfoEntity.class);
        if (StringUtils.isNotEmpty((String)visitCompleteInfoSearchReqVo.getVisitRealName())) {
            queryWrapper.like(SfaVisitCompleteInfoEntity::getVisitRealName, (Object)visitCompleteInfoSearchReqVo.getVisitRealName());
        }
        if (StringUtils.isNotEmpty((String)visitCompleteInfoSearchReqVo.getVisitPosName())) {
            queryWrapper.like(SfaVisitCompleteInfoEntity::getVisitPosName, (Object)visitCompleteInfoSearchReqVo.getVisitPosName());
        }
        if (StringUtils.isNotEmpty((String)visitCompleteInfoSearchReqVo.getStartTime())) {
            queryWrapper.ge(SfaVisitCompleteInfoEntity::getVisitDate, (Object)visitCompleteInfoSearchReqVo.getStartTime());
        }
        if (StringUtils.isNotEmpty((String)visitCompleteInfoSearchReqVo.getEndTime())) {
            queryWrapper.le(SfaVisitCompleteInfoEntity::getVisitDate, (Object)visitCompleteInfoSearchReqVo.getEndTime());
        }
        queryWrapper.orderByDesc(SfaVisitCompleteInfoEntity::getVisitDate);
        return queryWrapper;
    }
}

