/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.calculatesalary.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.calculatesalary.mapper.SfaCalculateSalaryDateMapper;
import com.biz.crm.calculatesalary.model.SfaCalculateSalaryDateEntity;
import com.biz.crm.calculatesalary.service.ISfaCalculateSalaryDateService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryDateReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryDateRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaCalculateSalaryDateServiceExpandImpl"})
public class SfaCalculateSalaryDateServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaCalculateSalaryDateMapper, SfaCalculateSalaryDateEntity>
implements ISfaCalculateSalaryDateService {
    private static final Logger log = LoggerFactory.getLogger(SfaCalculateSalaryDateServiceImpl.class);
    @Resource
    private SfaCalculateSalaryDateMapper sfaCalculateSalaryDateMapper;

    @Override
    public PageResult<SfaCalculateSalaryDateRespVo> findList(SfaCalculateSalaryDateReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaCalculateSalaryDateRespVo> list = this.sfaCalculateSalaryDateMapper.findList((Page<SfaCalculateSalaryDateRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaCalculateSalaryDateRespVo query(SfaCalculateSalaryDateReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaCalculateSalaryDateReqVo reqVo) {
        SfaCalculateSalaryDateEntity entity = (SfaCalculateSalaryDateEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaCalculateSalaryDateEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaCalculateSalaryDateReqVo reqVo) {
        SfaCalculateSalaryDateEntity entity = (SfaCalculateSalaryDateEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaCalculateSalaryDateReqVo reqVo) {
        List sfaCalculateSalaryDateEntities = this.sfaCalculateSalaryDateMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaCalculateSalaryDateEntities)) {
            sfaCalculateSalaryDateEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaCalculateSalaryDateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaCalculateSalaryDateReqVo reqVo) {
        List sfaCalculateSalaryDateEntities = this.sfaCalculateSalaryDateMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaCalculateSalaryDateEntities)) {
            sfaCalculateSalaryDateEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaCalculateSalaryDateEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaCalculateSalaryDateReqVo reqVo) {
        List sfaCalculateSalaryDateEntities = this.sfaCalculateSalaryDateMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaCalculateSalaryDateEntities)) {
            sfaCalculateSalaryDateEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaCalculateSalaryDateEntities);
    }

    @Override
    public List<SfaCalculateSalaryDateRespVo> findHoliday(String year) {
        SfaCalculateSalaryDateReqVo reqVo = new SfaCalculateSalaryDateReqVo();
        reqVo.setYear(year);
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<SfaCalculateSalaryDateRespVo> list = this.sfaCalculateSalaryDateMapper.findList(null, reqVo);
        return list;
    }

    @Override
    public List<SfaCalculateSalaryDateRespVo> findHolidayByDate(String date) {
        return this.findHoliday(LocalDate.parse(date).getYear() + "");
    }

    @Override
    public boolean isHoliday(String date) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(SfaCalculateSalaryDateEntity::getDay, (Object)date);
        SfaCalculateSalaryDateEntity entity = (SfaCalculateSalaryDateEntity)((Object)this.sfaCalculateSalaryDateMapper.selectOne((Wrapper)wrapper));
        return entity != null;
    }

    @Override
    public boolean isCalculateSalary(String date) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(SfaCalculateSalaryDateEntity::getDay, (Object)date);
        SfaCalculateSalaryDateEntity entity = (SfaCalculateSalaryDateEntity)((Object)this.sfaCalculateSalaryDateMapper.selectOne((Wrapper)wrapper));
        return entity != null && YesNoEnum.yesNoEnum.ONE.getValue().equals(entity.getIsCalculationSalary());
    }
}

