/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaCustomerDistanceEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.gaode.vo.QueryAroundVo;
import com.biz.crm.mdm.map.MdmTerminalCustomerElasticsearchFeign;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.moblie.service.ISfaNearbyCustomerService;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalCustomerElasticsearchPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalCustomerElasticsearchRespVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaNearbyCustomerReqVo;
import com.biz.crm.sfa.map.GaoDeFeign;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SfaNearbyCustomerServiceImpl
implements ISfaNearbyCustomerService {
    private static final Logger log = LoggerFactory.getLogger(SfaNearbyCustomerServiceImpl.class);
    @Autowired
    private GaoDeFeign gaoDeFeign;
    @Resource
    private MdmTerminalCustomerElasticsearchFeign mdmTerminalCustomerElasticsearchFeign;
    @Autowired
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;

    @Override
    public SfaVisitResp findNotCooperationCustomerList(SfaNearbyCustomerReqVo reqVo) {
        List<SfaVisitResp.SfaVisitPlanInfoResp> planInfoEntities;
        List list;
        List keywordList;
        this.doCheckParam(reqVo);
        QueryAroundVo queryAroundVo = new QueryAroundVo();
        queryAroundVo.setLocation(reqVo.getLocation()).setRadius(null).setKeywords(null).setOffset(reqVo.getPageSize().toString()).setPage(reqVo.getPageNum().toString());
        List distanceList = DictUtil.list((String)SfaCustomerDistanceEnum.SFA_CUSTOMER_DISTANCE_ENUM.getDesc());
        if (CollectionUtil.listNotEmpty((List)distanceList)) {
            String radius = ((DictDataVo)distanceList.get(0)).getDictValue();
            queryAroundVo.setRadius(radius);
        }
        if (CollectionUtil.listNotEmpty((List)(keywordList = DictUtil.list((String)SfaVisitEnum.customerKeyword.CUSTOMER_KEYWORD_ENUM.getDesc())))) {
            String keywords = keywordList.stream().map(e -> e.getDictValue()).collect(Collectors.joining("|"));
            queryAroundVo.setKeywords(keywords);
        }
        queryAroundVo.setRadius(null).setKeywords(null);
        PageResult result = (PageResult)ApiResultUtil.objResult((Result)this.gaoDeFeign.queryAround(queryAroundVo));
        AssertUtils.isNotNull((Object)result, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        List gaodeData = result.getData();
        List<SfaVisitResp.SfaVisitPlanInfoResp> respList = gaodeData.stream().map(m -> {
            SfaVisitResp.SfaVisitPlanInfoResp o = new SfaVisitResp.SfaVisitPlanInfoResp();
            o.setClientCode(m.getId());
            o.setRedisHashKey("NONE");
            o.setLongitude(new BigDecimal(m.getLongitude()));
            o.setLatitude(new BigDecimal(m.getLatitude()));
            o.setClientAddress(m.getAddress());
            o.setClientPhone(m.getTel());
            o.setClientName(m.getName());
            o.setDistance(new BigDecimal(m.getDistance()));
            return o;
        }).collect(Collectors.toList());
        respList.forEach(o -> {
            Map map = SfaVisitEnum.visitButton.buildVisitUnfamiliarButton((String)UserUtils.getUser().getUsername(), (String)LocalDate.now().toString(), (String)SfaVisitEnum.visitStatus.V1.getVal());
            o.setButtons(map);
        });
        LinkedHashMap collect = respList.stream().collect(Collectors.toMap(SfaVisitResp.SfaVisitPlanInfoResp::getClientCode, Function.identity(), (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        MdmTerminalCustomerElasticsearchPageReqVo mdmTerminalCustomerElasticsearchPageReqVo = new MdmTerminalCustomerElasticsearchPageReqVo();
        mdmTerminalCustomerElasticsearchPageReqVo.setDistance(Double.valueOf(Double.parseDouble(SfaCustomerDistanceEnum.TS.getDesc())));
        String[] split = reqVo.getLocation().split(",");
        mdmTerminalCustomerElasticsearchPageReqVo.setLongitude(split[0]).setLatitude(split[1]);
        PageResult mdmResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmTerminalCustomerElasticsearchFeign.list(mdmTerminalCustomerElasticsearchPageReqVo));
        if (mdmResult != null && CollectionUtil.listNotEmpty((List)(list = mdmResult.getData()))) {
            list.forEach(o -> {
                if (collect.containsKey(o.getAmapId())) {
                    collect.remove(o.getAmapId(), collect.get(o.getAmapId()));
                }
            });
        }
        if (CollectionUtil.listNotEmpty(planInfoEntities = this.visitPlanToday(split, SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal(), reqVo.getVisitTime()))) {
            planInfoEntities.forEach(plan -> {
                if (collect.containsKey(plan.getClientCode())) {
                    SfaVisitResp.SfaVisitPlanInfoResp sfaVisitPlanInfoResp = (SfaVisitResp.SfaVisitPlanInfoResp)((Object)((Object)collect.get(plan.getClientCode())));
                    plan.setDistance(sfaVisitPlanInfoResp.getDistance());
                    plan.setClientAddress(sfaVisitPlanInfoResp.getClientAddress());
                    plan.setClientPhone(sfaVisitPlanInfoResp.getClientPhone());
                    plan.setLongitude(sfaVisitPlanInfoResp.getLongitude());
                    plan.setLatitude(sfaVisitPlanInfoResp.getLatitude());
                    collect.put(plan.getClientCode(), plan);
                }
            });
        }
        List<SfaVisitResp.SfaVisitPlanInfoResp> respVos = collect.values().stream().collect(Collectors.toList());
        SfaVisitResp sfaVisitResp = new SfaVisitResp();
        sfaVisitResp.setPlanInfoEntities(respVos);
        if (StringUtils.isNotEmpty((String)reqVo.getClientName()) && CollectionUtil.listNotEmpty(respVos)) {
            return this.searchByClientName(reqVo, sfaVisitResp);
        }
        return sfaVisitResp;
    }

    public List<SfaVisitResp.SfaVisitPlanInfoResp> visitPlanToday(String[] split, String visitBigType, String visitTime) {
        UserRedis userRedis = UserUtils.getUser();
        GetVisitListReq req = new GetVisitListReq();
        req.setVisitUserName(userRedis.getUsername());
        req.setVisitPositionCode(userRedis.getPoscode());
        req.setVisitDate(LocalDate.now().toString());
        if (StringUtils.isNotEmpty((String)visitTime)) {
            try {
                LocalDate.parse(visitTime, CrmDateUtils.yyyyMMdd);
            }
            catch (Exception e) {
                throw new BusinessException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
            req.setVisitDate(visitTime);
        }
        req.setLongitude(new BigDecimal(split[0]));
        req.setLatitude(new BigDecimal(split[1]));
        req.setVisitBigType(visitBigType);
        List<SfaVisitResp.SfaVisitPlanInfoResp> planInfoEntities = this.sfaVisitPlanInfoService.getVisitInfoList(req).getPlanInfoEntities();
        return planInfoEntities;
    }

    @Override
    public SfaVisitResp findCooperationCustomerList(SfaNearbyCustomerReqVo reqVo) {
        this.doCheckParam(reqVo);
        List distanceList = DictUtil.list((String)SfaVisitEnum.customerKeyword.CUSTOMER_KEYWORD_ENUM.getDesc());
        AssertUtils.isNotEmpty((Collection)distanceList, (String)"\u7f3a\u5931\u6570\u636e\u5b57\u5178");
        String radius = ((DictDataVo)distanceList.get(0)).getDictValue();
        UserRedis userRedis = UserUtils.getUser();
        MdmTerminalCustomerElasticsearchPageReqVo mdmTerminalCustomerElasticsearchPageReqVo = new MdmTerminalCustomerElasticsearchPageReqVo();
        String[] split = reqVo.getLocation().split(",");
        mdmTerminalCustomerElasticsearchPageReqVo.setLongitude(split[0]).setLatitude(split[1]).setDistance(Double.valueOf(Double.parseDouble(radius))).setPositionCodes(userRedis.getPoscode()).setPageNum(reqVo.getPageNum()).setPageSize(reqVo.getPageSize());
        List list = ((PageResult)ApiResultUtil.objResult((Result)this.mdmTerminalCustomerElasticsearchFeign.list(mdmTerminalCustomerElasticsearchPageReqVo))).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitResp();
        }
        Map<String, MdmTerminalCustomerElasticsearchRespVo> clientMap = list.stream().collect(Collectors.toMap(MdmTerminalCustomerElasticsearchRespVo::getCode, a -> a, (k1, k2) -> k1));
        List<SfaVisitResp.SfaVisitPlanInfoResp> planInfoEntities = this.visitPlanToday(split, SfaVisitEnum.VisitBigType.VISIT.getVal(), reqVo.getVisitTime());
        Map<Object, Object> collect = new HashMap();
        if (CollectionUtil.listNotEmpty(planInfoEntities)) {
            collect = planInfoEntities.stream().collect(Collectors.toMap(SfaVisitResp.SfaVisitPlanInfoResp::getClientCode, a -> a, (k1, k2) -> k1));
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (String o : clientMap.keySet()) {
            if (!CollectionUtils.isEmpty(collect) && collect.containsKey(o)) {
                map.put(o, collect.get(o));
            }
            Map mapButton = SfaVisitEnum.visitButton.buildVisitButton((String)userRedis.getUsername(), (String)LocalDate.now().toString(), (String)SfaVisitEnum.visitStatus.V1.getVal());
            SfaVisitResp.SfaVisitPlanInfoResp resp = (SfaVisitResp.SfaVisitPlanInfoResp)((Object)CrmBeanUtil.copy((Object)clientMap.get(o), SfaVisitResp.SfaVisitPlanInfoResp.class));
            resp.setDistance(BigDecimal.valueOf(clientMap.get(o).getDistance()));
            resp.setLongitude(new BigDecimal(clientMap.get(o).getLongitude()));
            resp.setLatitude(new BigDecimal(clientMap.get(o).getLatitude()));
            resp.setClientContacts(clientMap.get(o).getContactName());
            resp.setClientCode(clientMap.get(o).getCode());
            resp.setClientName(clientMap.get(o).getName());
            resp.setClientPhone(clientMap.get(o).getContactPhone());
            resp.setClientAddress(clientMap.get(o).getAddress());
            resp.setRedisHashKey("NONE");
            resp.setButtons(mapButton);
            resp.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
            resp.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
            map.put(o, (Object)resp);
        }
        if (map.size() == clientMap.size()) {
            map.putAll(collect);
        }
        if (MapUtils.isEmpty(map)) {
            return new SfaVisitResp();
        }
        List sfaVisitPlanInfoRespVos = map.values().stream().collect(Collectors.toList());
        List<SfaVisitResp.SfaVisitPlanInfoResp> result = sfaVisitPlanInfoRespVos.stream().sorted(Comparator.nullsLast(Comparator.comparing(SfaVisitResp.SfaVisitPlanInfoResp::getDistance, Comparator.nullsLast(BigDecimal::compareTo)))).collect(Collectors.toList());
        SfaVisitResp sfaVisitResp = new SfaVisitResp();
        sfaVisitResp.setPlanInfoEntities(result);
        if (StringUtils.isNotEmpty((String)reqVo.getClientName()) && CollectionUtil.listNotEmpty(result)) {
            return this.searchByClientName(reqVo, sfaVisitResp);
        }
        return sfaVisitResp;
    }

    public void doCheckParam(SfaNearbyCustomerReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getLocation(), (String)"location\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPageNum().toString(), (String)"\u6bcf\u9875\u6570\u636e\u7684\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPageSize().toString(), (String)"\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public SfaVisitResp searchByClientName(SfaNearbyCustomerReqVo reqVo, SfaVisitResp sfaVisitResp) {
        Map<String, SfaVisitResp.SfaVisitPlanInfoResp> clientNameMap = sfaVisitResp.getPlanInfoEntities().stream().collect(Collectors.toMap(SfaVisitResp.SfaVisitPlanInfoResp::getClientName, a -> a, (k1, k2) -> k2));
        SfaVisitResp result = new SfaVisitResp();
        if (!clientNameMap.isEmpty()) {
            ArrayList<SfaVisitResp.SfaVisitPlanInfoResp> resp = new ArrayList<SfaVisitResp.SfaVisitPlanInfoResp>();
            for (String key : clientNameMap.keySet()) {
                if (!key.contains(reqVo.getClientName())) continue;
                resp.add(clientNameMap.get(key));
            }
            result.setPlanInfoEntities(resp);
        }
        return result;
    }
}

