/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageDataAdviser;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.req.PlanInfoSettlementReq;
import com.biz.crm.visitinfo.req.SettlementJobInfo;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDate;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class VisitPlanInfoHelper {
    private static final Logger log = LoggerFactory.getLogger(VisitPlanInfoHelper.class);
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    private RedisService redisService;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private RocketMQProducer rocketMQProducer;
    private static final int PAGE_SIZE = 1000;
    private static final int JOB_TIME = 21600;
    private static final String PLAN_INFO_SETTLEMENT_JOB = "PLAN_INFO_SETTLEMENT_JOB";
    private static final String REDIS_HASH = new StringJoiner(":").add("SFA_VISIT").add("PLAN_INFO_SETTLEMENT_JOB").toString();

    @Scheduled(cron="0 30 0 * * ?")
    public void planInfoSettlementJobBegin() {
        log.warn("#######################\u62dc\u8bbf\u8ba1\u5212\u7ed3\u7b97\u4efb\u52a1\u5f00\u59cb####################");
        this.planInfoSettlementJob(null, false);
        log.warn("#######################\u62dc\u8bbf\u8ba1\u5212\u7ed3\u7b97\u4efb\u52a1\u7ed3\u675f####################");
    }

    public void planInfoSettlementJob(String visitDate, Boolean compulsive) {
        if (StringUtils.isBlank((CharSequence)visitDate)) {
            visitDate = LocalDate.now().plusDays(-1L).format(CrmDateUtils.yyyyMMdd);
        }
        String key = PLAN_INFO_SETTLEMENT_JOB + visitDate;
        if (compulsive.booleanValue()) {
            this.compulsiveJob(visitDate, key);
            return;
        }
        this.jobIsDone(visitDate, key);
        this.doPlanInfoSettlementJob(visitDate, key);
        this.updateJobEndStatus(key);
    }

    private void updateJobEndStatus(String key) {
        SettlementJobInfo jobInfo = new SettlementJobInfo();
        jobInfo.setIp(this.getIp());
        jobInfo.setEndStatus(true);
        this.redisService.put(REDIS_HASH, key, (Object)jobInfo, 21600L);
    }

    private void compulsiveJob(String visitDate, String key) {
        SettlementJobInfo jobInfo = (SettlementJobInfo)this.redisService.hmget(REDIS_HASH, (Object)key);
        if (null != jobInfo && !jobInfo.getEndStatus().booleanValue()) {
            throw new BusinessException("\u62dc\u8bbf\u8ba1\u5212\u7ed3\u7b97\u4efb\u52a1\u542f\u52a8\u5931\u8d25\uff0c\u5df2\u6709\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        jobInfo = new SettlementJobInfo();
        jobInfo.setIp(this.getIp());
        jobInfo.setEndStatus(false);
        this.redisService.put(REDIS_HASH, key, (Object)jobInfo, 21600L);
        this.doPlanInfoSettlementJob(visitDate, key);
        this.updateJobEndStatus(key);
    }

    private void doPlanInfoSettlementJob(String visitDate, String key) {
        try {
            UserUtils.doTokenForUserName((String)"admin", (long)21600L);
            PageDataAdviser pageDataAdviser = new PageDataAdviser(1000);
            long total = 1000L;
            while (pageDataAdviser.hasNext(Long.valueOf(total))) {
                MdmPositionPageReqVo reqVo = new MdmPositionPageReqVo();
                reqVo.setPageNum(pageDataAdviser.nextPage());
                reqVo.setPageSize(pageDataAdviser.getPageSize());
                PageResult pageResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmPositionFeign.positionAndUserPage(reqVo), (boolean)true);
                List users = pageResult.getData();
                this.sendMq(users, visitDate);
                total = pageResult.getCount();
            }
        }
        catch (Exception e) {
            if (this.redisService.hmHasKey(REDIS_HASH, (Object)key).booleanValue()) {
                this.redisService.hmDelete(REDIS_HASH, new Object[]{key});
            }
            log.error("\u62dc\u8bbf\u8ba1\u5212\u7ed3\u7b97\u4efb\u52a1\u542f\u52a8\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u62dc\u8bbf\u8ba1\u5212\u7ed3\u7b97\u4efb\u52a1\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (Throwable)e);
        }
    }

    private void jobIsDone(String visitDate, String key) {
        SettlementJobInfo jobInfo = new SettlementJobInfo();
        jobInfo.setIp(this.getIp());
        jobInfo.setEndStatus(false);
        boolean result = this.redisService.putIfAbsent(REDIS_HASH, key, (Object)jobInfo, 21600L);
        if (!result) {
            jobInfo = (SettlementJobInfo)this.redisService.hmget(REDIS_HASH, (Object)key);
            throw new BusinessException("\u5e94\u7528\u670d\u52a1[" + jobInfo.getIp() + "]\u5df2\u7ecf\u6267\u884c\u8fc7[" + visitDate + "]\u7684\u7ed3\u7b97\u4efb\u52a1,\u4f60\u53ef\u9009\u62e9\u5f3a\u5236\u542f\u52a8\u7ed3\u7b97\u4efb\u52a1\uff01");
        }
    }

    private String getIp() {
        String ip = "do not get ip";
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("\u62dc\u8bbf\u8ba1\u5212\u7ed3\u7b97\u4efb\u52a1\uff1a\u672a\u83b7\u53d6\u5230\u672c\u673aip", (Throwable)e);
        }
        return ip;
    }

    private void sendMq(List<MdmPositionPageRespVo> users, String visitDate) {
        RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
        for (MdmPositionPageRespVo mdmPositionPageRespVo : users) {
            PlanInfoSettlementReq settlementReq = new PlanInfoSettlementReq();
            settlementReq.setVisitDate(visitDate);
            String visitUserName = mdmPositionPageRespVo.getUserName();
            String visitPositionCode = mdmPositionPageRespVo.getPositionCode();
            if (StringUtils.isBlank((CharSequence)visitPositionCode) || StringUtils.isBlank((CharSequence)visitUserName)) continue;
            settlementReq.setVisitPositionCode(visitPositionCode);
            settlementReq.setVisitUserName(visitUserName);
            mqMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)settlementReq));
            mqMessageBody.setTag("VISIT_PLAN_INFO_SETTLEMENT");
            this.rocketMQProducer.convertAndSend(mqMessageBody);
        }
    }

    public void planInfoSettlementForWeb(PlanInfoSettlementReq req) {
        this.planInfoSettlement(req);
    }

    public void planInfoSettlementForJob(PlanInfoSettlementReq req) {
        this.planInfoSettlement(req);
    }

    public void planInfoSettlement(PlanInfoSettlementReq req) {
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.loadUserVisitPlan(req);
        for (SfaVisitPlanInfoEntity planInfoEntity : planInfoEntities) {
            SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = null;
            if (this.hasRedisData(planInfoEntity)) {
                sfaVisitPlanInfoRedisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), (Object)planInfoEntity.getRedisHashKey());
            }
            this.sfaVisitPlanInfoService.dataDurability(planInfoEntity, sfaVisitPlanInfoRedisData);
            this.redisService.hmset(planInfoEntity.redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), planInfoEntity.buildRedisDataForWrite(), 1296000L);
            if (null == sfaVisitPlanInfoRedisData) continue;
            this.redisService.hmset(sfaVisitPlanInfoRedisData.redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), sfaVisitPlanInfoRedisData.buildRedisDataForWrite(), 1296000L);
        }
    }

    private boolean hasRedisData(SfaVisitPlanInfoEntity planInfoEntity) {
        return SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(planInfoEntity.getVisitBigType()) ? SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(planInfoEntity.getVisitStatus()) : SfaVisitEnum.visitStatus.V5.getVal().equals(planInfoEntity.getVisitStatus());
    }

    private List<SfaVisitPlanInfoEntity> loadUserVisitPlan(PlanInfoSettlementReq settlementReq) {
        GetVisitListReq req = (GetVisitListReq)CrmBeanUtil.copy((Object)settlementReq, GetVisitListReq.class);
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        List<SfaVisitPlanInfoEntity> planInfoTemps = this.sfaVisitPlanInfoService.doGetVisitInfoList(req);
        req.setVisitBigType(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
        planInfoTemps.addAll(this.sfaVisitPlanInfoService.doGetVisitInfoList(req));
        req.setVisitBigType(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal());
        planInfoTemps.addAll(this.sfaVisitPlanInfoService.doGetVisitInfoList(req));
        List<SfaVisitPlanInfoEntity> planInfoEntities = planInfoTemps.stream().filter(v -> {
            if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(v.getVisitBigType())) {
                if (SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal());
                    v.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getDesc());
                    return true;
                }
                if (SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal());
                    v.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getDesc());
                    v.setRemarks("\u8be5\u7528\u6237\u5728\u6267\u884c\u4e1a\u52a1\u65f6\u672a\u4e3b\u52a8\u63d0\u4ea4\u6267\u884c\u6570\u636e\uff08\u4efb\u52a1/\u540e\u53f0\u6279\u91cf\u7ed3\u7b97\uff09");
                    return true;
                }
            } else {
                if (SfaVisitEnum.visitStatus.V1.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.visitStatus.V6.getVal());
                    v.setVisitStatusName(SfaVisitEnum.visitStatus.V6.getDesc());
                    return true;
                }
                if (SfaVisitEnum.visitStatus.V2.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.visitStatus.V5.getVal());
                    v.setVisitStatusName(SfaVisitEnum.visitStatus.V5.getDesc());
                    v.setRemarks("\u8be5\u7528\u6237\u5728\u6267\u884c\u4e1a\u52a1\u65f6\u672a\u4e3b\u52a8\u63d0\u4ea4\u6267\u884c\u6570\u636e\uff08\u4efb\u52a1/\u540e\u53f0\u6279\u91cf\u7ed3\u7b97\uff09");
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        return planInfoEntities;
    }
}

