/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoEntityRepositories;
import com.biz.crm.visitinfo.req.GetVisitReportsPageReq;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SfaVisitPlanInfoServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitPlanInfoServiceEsImpl.class);
    @Resource
    private SfaVisitPlanInfoEntityRepositories sfaVisitPlanInfoEntityRepositories;

    public List<SfaVisitPlanInfoEntity> findByVisitPosCodeAndVisitDateAndVisitBigType(String visitPosCode, String visitDate, String visitBigType, Sort sort) {
        if (StringUtils.isBlank((CharSequence)visitBigType)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u62dc\u8bbf\u5927\u7c7b");
        }
        if (StringUtils.isBlank((CharSequence)visitPosCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u7528\u6237\u804c\u4f4d\u7f16\u7801");
        }
        if (StringUtils.isBlank((CharSequence)visitDate)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u65e5\u671f");
        }
        if (null == sort) {
            sort = Sort.by((String[])new String[]{"visitSort"}).ascending();
        }
        List<SfaVisitPlanInfoEntity> list = this.sfaVisitPlanInfoEntityRepositories.findByVisitPosCodeAndVisitDateAndVisitBigType(visitPosCode, visitDate, visitBigType, sort);
        return Lists.newArrayList(list);
    }

    public PageResult<SfaVisitPlanInfoRespVo> getVisitPlanInfoReportPage(GetVisitReportsPageReq req) {
        Page list = this.sfaVisitPlanInfoEntityRepositories.search((SearchQuery)req.buildQuery());
        return PageResult.builder().data(CrmBeanUtil.copyList((List)list.getContent(), SfaVisitPlanInfoRespVo.class)).count(Long.valueOf(list.getTotalElements())).build();
    }

    public void saveAll(Collection<SfaVisitPlanInfoEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.saveAll(entities);
    }

    public void save(SfaVisitPlanInfoEntity entity) {
        if (null == entity) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.save(entity);
    }

    public List<SfaVisitPlanInfoEntity> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)QueryBuilders.termsQuery((String)"id", (String[])ids.toArray(new String[ids.size()])));
        Page list = this.sfaVisitPlanInfoEntityRepositories.search((SearchQuery)nativeSearchQueryBuilder.build());
        return Lists.newArrayList((Iterable)list);
    }

    public SfaVisitPlanInfoEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u62dc\u8bbf\u8ba1\u5212ID");
        }
        Optional optional = this.sfaVisitPlanInfoEntityRepositories.findById(id);
        if (optional.isPresent()) {
            return (SfaVisitPlanInfoEntity)optional.get();
        }
        return null;
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.deleteByIdIn(ids);
    }

    public void deleteByVisitUserNameAndVisitPosCodeAndAndVisitDateAndVisitBigType(String visitUserName, String visitPosCode, String visitDate, String visitBigType) {
        if (StringUtils.isBlank((CharSequence)visitUserName) || StringUtils.isBlank((CharSequence)visitPosCode) || StringUtils.isBlank((CharSequence)visitDate) || StringUtils.isBlank((CharSequence)visitBigType)) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.deleteByVisitUserNameAndVisitPosCodeAndVisitDateAndVisitBigType(visitUserName, visitPosCode, visitDate, visitBigType);
    }

    public List<SfaVisitPlanInfoEntity> findByVisitUserNameAndVisitPosCodeAndAndVisitDateAndVisitBigType(String visitUserName, String visitPosCode, String visitDate, String visitBigType) {
        if (StringUtils.isBlank((CharSequence)visitUserName) || StringUtils.isBlank((CharSequence)visitPosCode) || StringUtils.isBlank((CharSequence)visitDate) || StringUtils.isBlank((CharSequence)visitBigType)) {
            return Lists.newArrayList();
        }
        return this.sfaVisitPlanInfoEntityRepositories.findByVisitUserNameAndVisitPosCodeAndVisitDateAndVisitBigType(visitUserName, visitPosCode, visitDate, visitBigType);
    }

    public List<SfaVisitPlanInfoEntity> findByVisitPlanCode(String visitPlanCode) {
        if (StringUtils.isBlank((CharSequence)visitPlanCode)) {
            return Lists.newArrayList();
        }
        return this.sfaVisitPlanInfoEntityRepositories.findByVisitPlanCode(visitPlanCode);
    }

    public void deleteByVisitPlanCode(String visitPlanCode) {
        if (StringUtils.isBlank((CharSequence)visitPlanCode)) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.deleteByVisitPlanCode(visitPlanCode);
    }

    public List<SfaVisitPlanInfoEntity> findByVisitPlanCodeAndVisitDate(String visitPlanCode, String visitDate) {
        if (StringUtils.isBlank((CharSequence)visitPlanCode) || StringUtils.isBlank((CharSequence)visitDate)) {
            return Lists.newArrayList();
        }
        return this.sfaVisitPlanInfoEntityRepositories.findByVisitPlanCodeAndVisitDate(visitPlanCode, visitDate);
    }

    public void deleteByVisitPlanCodeAndVisitDate(String visitPlanCode, String visitDate) {
        if (StringUtils.isBlank((CharSequence)visitPlanCode) || StringUtils.isBlank((CharSequence)visitDate)) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.deleteByVisitPlanCodeAndVisitDate(visitPlanCode, visitDate);
    }
}

