/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cache.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkSignUtil {
    public static final String redisKey = "SFA_WORK_SIGN_RECORD:v1:";
    @Autowired
    private RedisService redisService;

    public String getKey(String userName, String ruleDate) {
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)ruleDate)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        return redisKey + userName + ruleDate;
    }

    public void deleteKey(String userName, String ruleDate) {
        this.redisService.del(new String[]{this.getKey(userName, ruleDate)});
    }

    public void setObj(SfaWorkSignRuleInfoEntity vo) {
        String key = this.getKey(vo.getUserName(), vo.getRuleDate());
        this.redisService.setDays(key, (Object)vo, 30L);
    }

    public SfaWorkSignRuleInfoEntity getObj(String userName, String ruleDate) {
        Object o = this.redisService.get(this.getKey(userName, ruleDate));
        if (o == null) {
            return this.compensate(userName, ruleDate);
        }
        SfaWorkSignRuleInfoEntity entity = (SfaWorkSignRuleInfoEntity)((Object)o);
        if (StringUtils.isEmpty((String)entity.getUserName())) {
            return null;
        }
        return entity;
    }

    public SfaWorkSignRuleInfoEntity compensate(String userName, String ruleDate) {
        return null;
    }
}

