/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelApplyReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelUserReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelUserRespVo;
import com.biz.crm.util.AssertDateTimeUtils;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.SfaActivitiUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaTravelMapper;
import com.biz.crm.worksign.model.SfaTravelEntity;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.biz.crm.worksign.service.ISfaTravelService;
import com.biz.crm.worksign.service.ISfaTravelUserService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"sfaTravelServiceExpandImpl"})
public class SfaTravelServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaTravelMapper, SfaTravelEntity>
implements ISfaTravelService {
    private static final Logger log = LoggerFactory.getLogger(SfaTravelServiceImpl.class);
    @Resource
    private SfaTravelMapper sfaTravelMapper;
    @Autowired
    private ISfaTravelUserService sfaTravelUserService;
    @Autowired
    private TaActBaseFeign taActBaseFeign;
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private ISfaSignFormsService formsService;

    @Override
    public PageResult<SfaTravelRespVo> findList(SfaTravelReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaTravelRespVo> list = this.sfaTravelMapper.findList((Page<SfaTravelRespVo>)page, reqVo);
        if (list != null && list.size() > 0 && list.get(0) != null) {
            list.forEach(vo -> {
                List<SfaTravelUserRespVo> userRespVos = this.sfaTravelUserService.findList(vo.getId());
                vo.setSfaTravelUserRespVos(userRespVos);
                if (CollectionUtil.listNotEmpty(userRespVos)) {
                    vo.setTravelUserNames(userRespVos.stream().map(SfaTravelUserRespVo::getRealName).collect(Collectors.joining(",")));
                }
                vo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<SfaTravelRespVo> findDataList(SfaTravelReqVo reqVo) {
        List<SfaTravelRespVo> list = this.sfaTravelMapper.findDataList(reqVo);
        return list;
    }

    @Override
    public SfaTravelRespVo query(String id) {
        SfaTravelReqVo reqVo = new SfaTravelReqVo();
        reqVo.setId(id);
        PageResult<SfaTravelRespVo> pageResult = this.findList(reqVo);
        if (pageResult == null || pageResult.getCount() != 1L) {
            throw new BusinessException("\u51fa\u5dee\u4fe1\u606fID\u9519\u8bef");
        }
        return (SfaTravelRespVo)pageResult.getData().get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result goApplyTravel(SfaTravelApplyReqVo reqVo) {
        this.checkInfo(reqVo);
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null) {
            throw new BusinessException("\u8bf7\u767b\u5f55");
        }
        SfaTravelEntity entity = (SfaTravelEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaTravelEntity.class));
        if (StringUtils.isNotEmpty((String)entity.getId())) {
            SfaTravelEntity old = (SfaTravelEntity)((Object)this.sfaTravelMapper.selectOne((Wrapper)Wrappers.lambdaQuery(SfaTravelEntity.class).eq(BaseIdEntity::getId, (Object)entity.getId())));
            if (old == null) {
                throw new BusinessException("\u51fa\u5dee\u4fe1\u606fid\u9519\u8bef");
            }
            if (SfaCommonEnum.dataBpmStatus.REJECT.getValue().equals(old.getBpmStatus())) {
                entity.setId(null);
            } else if (SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue().equals(old.getBpmStatus())) {
                entity.setId(old.getId());
            } else {
                return Result.error((String)"\u8be5\u7533\u8bf7\u4e0d\u652f\u6301\u7f16\u8f91");
            }
            entity.setApplyUserName(old.getApplyUserName());
        } else {
            entity.setApplyUserName(userRedis.getUsername());
        }
        MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo = this.formsService.getUserOrgInfo(entity.getApplyUserName());
        entity.setApplyRealName(mdmPositionUserOrgRespVo.getFullName());
        entity.setApplyOrgCode(mdmPositionUserOrgRespVo.getOrgCode());
        entity.setApplyOrgName(mdmPositionUserOrgRespVo.getOrgName());
        entity.setApplyPosCode(mdmPositionUserOrgRespVo.getPositionCode());
        entity.setApplyPosName(mdmPositionUserOrgRespVo.getPositionName());
        entity.setApplyParentOrgCode(mdmPositionUserOrgRespVo.getParentOrgCode());
        entity.setApplyParentOrgName(mdmPositionUserOrgRespVo.getParentOrgName());
        entity.setApplicationDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        this.saveOrUpdate((Object)entity);
        this.sfaTravelUserService.saveTravelUser(reqVo.getSfaTravelUserReqVos(), entity);
        entity.setAuditTaskId(entity.getId());
        StartProcessReqVo startProcessReqVO = SfaActivitiUtils.createStartProcessReqVO((String)entity.getApplyUserName(), (String)entity.getApplyPosCode(), (String)entity.getAuditTaskId(), (ActivitiEnum.FormTypeEnum)ActivitiEnum.FormTypeEnum.TRAVEL, (String)entity.getBeginTime(), (String)entity.getEndTime(), (String)entity.getApplyOrgCode());
        Result result = this.taActBaseFeign.startProcess(startProcessReqVO);
        if (!result.isSuccess()) {
            return result;
        }
        this.saveOrUpdate((Object)entity);
        return Result.ok();
    }

    @Override
    public PageResult<SfaAuditListTravelRespVo> findAuditList(PageResult<TaskRspVO> taskRspVOPageResult, SfaTravelReqVo reqVo) {
        if (taskRspVOPageResult != null && taskRspVOPageResult.getCount() > 0L) {
            Map<String, TaskRspVO> taskMap = taskRspVOPageResult.getData().stream().collect(Collectors.toMap(TaskRspVO::getFormNo, vo -> vo, (key1, key2) -> key2));
            reqVo.setAuditTaskIdList(new ArrayList<String>(taskMap.keySet()));
            PageResult<SfaTravelRespVo> pageResult = this.findList(reqVo);
            if (pageResult.getCount() > 0L) {
                List data = pageResult.getData().stream().sorted((x, y) -> CrmDateUtils.parseyyyyMMddHHmmss((String)y.getApplicationDate()).compareTo(CrmDateUtils.parseyyyyMMddHHmmss((String)x.getApplicationDate()))).collect(Collectors.toList());
                pageResult.setData(data);
                ArrayList list = new ArrayList();
                pageResult.getData().forEach(vo -> list.add(new SfaAuditListTravelRespVo(vo, (TaskRspVO)taskMap.get(vo.getAuditTaskId()))));
                return PageResult.builder().data(list).count(pageResult.getCount()).build();
            }
        }
        return PageResult.builder().data(null).count(Long.valueOf(0L)).build();
    }

    @Override
    public Result rollback(String id) {
        SfaTravelEntity entity = (SfaTravelEntity)((Object)this.sfaTravelMapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u51fa\u5dee\u7533\u8bf7\u4e3b\u952eid\u9519\u8bef");
        }
        if (!SfaCommonEnum.dataBpmStatus.COMMIT.getValue().equals(entity.getBpmStatus())) {
            return Result.error((String)"\u5f53\u524d\u7533\u8bf7\u4e0d\u80fd\u8ffd\u56de");
        }
        CancelProcessReqVO reqVO = new CancelProcessReqVO(entity.getAuditTaskId(), UserUtils.getUser().getUsername(), ActivitiEnum.FormTypeEnum.TRAVEL.getCostType(), ActivitiEnum.FormTypeEnum.TRAVEL.getFormType());
        Result result = this.mobileFeign.cancelProcess(reqVO);
        if (!result.isSuccess()) {
            return result;
        }
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue());
        this.saveOrUpdate((Object)entity);
        return Result.ok();
    }

    @Override
    public Result auditCommit(String id) {
        SfaTravelEntity entity = (SfaTravelEntity)((Object)this.sfaTravelMapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u51fa\u5dee\u7533\u8bf7\u4e3b\u952eid\u9519\u8bef");
        }
        if (!entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.COMMIT.getValue()) && !entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue())) {
            return Result.error((String)"\u8be5\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u9519\u8bef");
        }
        if (!SfaCommonEnum.dataBpmStatus.APPROVAL.getValue().equals(entity.getBpmStatus())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue());
            this.saveOrUpdate((Object)entity);
        }
        return Result.ok();
    }

    @Override
    public void auditFinish(SfaAuditFinishReqVo reqVo) {
        SfaTravelEntity entity = (SfaTravelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaTravelEntity::getAuditTaskId, (Object)reqVo.getFormId())).one());
        if (ActivitiEnum.AuditResultType.PASS.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.PASS.getValue());
            entity.setPassStatusDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
        } else if (ActivitiEnum.AuditResultType.REJECT.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.REJECT.getValue());
        } else if (ActivitiEnum.AuditResultType.RECOVER.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue());
        } else {
            throw new BusinessException("\u5ba1\u6279\u5931\u8d25");
        }
        this.saveOrUpdate((Object)entity);
    }

    @Override
    public SfaTravelRespVo queryByAuditTaskId(String auditTaskId) {
        SfaTravelReqVo reqVo = new SfaTravelReqVo();
        reqVo.setAuditTaskIdList(Arrays.asList(auditTaskId));
        PageResult<SfaTravelRespVo> result = this.findList(reqVo);
        if (result == null || result.getCount() != 1L) {
            throw new BusinessException("\u5ba1\u6838\u4efb\u52a1ID\u9519\u8bef");
        }
        return (SfaTravelRespVo)result.getData().get(0);
    }

    private void checkInfo(SfaTravelApplyReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getSfaTravelUserReqVos(), (String)"\u51fa\u5dee\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        for (int r = 0; r < reqVo.getSfaTravelUserReqVos().size(); ++r) {
            SfaTravelUserReqVo vo = (SfaTravelUserReqVo)reqVo.getSfaTravelUserReqVos().get(r);
            AssertUtils.isNotEmpty((String)vo.getUserName(), (String)("\u7b2c" + (r + 1) + "\u7ec4\u51fa\u5dee\u4eba\u5458:\u4eba\u5458\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
            AssertUtils.isNotEmpty((String)vo.getRealName(), (String)("\u7b2c" + (r + 1) + "\u7ec4\u51fa\u5dee\u4eba\u5458:\u4eba\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        AssertDateTimeUtils.checkDateAndNull((String)reqVo.getBeginTime(), (String)"\u8bf7\u9009\u62e9\u51fa\u5dee\u5f00\u59cb\u65f6\u95f4", (String)"\u51fa\u5dee\u5f00\u59cb\u65f6\u95f4\u9519\u8bef");
        AssertDateTimeUtils.checkDateAndNull((String)reqVo.getEndTime(), (String)"\u8bf7\u9009\u62e9\u51fa\u5dee\u7ed3\u675f\u65f6\u95f4", (String)"\u51fa\u5dee\u7ed3\u675f\u65f6\u95f4\u9519\u8bef");
        AssertDateTimeUtils.notAfterDate((String)reqVo.getBeginTime(), (String)reqVo.getEndTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5728\u7ed3\u675f\u65f6\u95f4\u4e4b\u540e");
        AssertUtils.isNotEmpty((String)reqVo.getAddress(), (String)"\u8bf7\u586b\u5199\u51fa\u5dee\u5730\u70b9");
        AssertUtils.isNotEmpty((String)reqVo.getTravelObjective(), (String)"\u8bf7\u586b\u5199\u51fa\u5dee\u76ee\u7684");
    }
}

