/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.map.service;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.map.mapper.SfaTencentMapDataMapper;
import com.biz.crm.map.model.SfaTencentMapDataEntity;
import com.biz.crm.map.model.req.SfaTencentMapData;
import com.biz.crm.map.model.resp.SfaTencentMapDataRespVo;
import com.biz.crm.map.service.SfaTencentMapDataService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SfaTencentMapDataServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaTencentMapDataMapper, SfaTencentMapDataEntity>
implements SfaTencentMapDataService {
    private static final Logger log = LoggerFactory.getLogger(SfaTencentMapDataServiceImpl.class);
    @Resource
    private SfaTencentMapDataMapper sfaTencentMapDataMapper;
    private static final double PI = 3.14159265;
    private static final double EARTH_RADIUS = 6378.137;

    @Override
    public void save(List<SfaTencentMapDataEntity> reqVo) {
        HashSet data = new HashSet();
        reqVo.forEach(o -> {
            if (StringUtils.isEmpty((String)o.getMapId()) || StringUtils.isEmpty((String)o.getLongitude()) || StringUtils.isEmpty((String)o.getLatitude()) || StringUtils.isEmpty((String)o.getName())) {
                return;
            }
            data.add(o);
        });
        ArrayList entities = Lists.newArrayList(data);
        List idList = entities.stream().map(SfaTencentMapDataEntity::getMapId).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(SfaTencentMapDataEntity::getMapId, idList)).remove();
        this.saveBatch(CrmBeanUtil.copyList((List)entities, SfaTencentMapDataEntity.class));
    }

    @Override
    public PageResult<SfaTencentMapDataRespVo> findList(SfaTencentMapData.SfaTencentMapDataReqVo reqVo) {
        double lat = Double.parseDouble(reqVo.getLat());
        double lng = Double.parseDouble(reqVo.getLng());
        List<String> around = this.getAround(lat, lng, Integer.parseInt(reqVo.getDistance()));
        reqVo.setMaxLng(around.get(0));
        reqVo.setMinLng(around.get(1));
        reqVo.setMaxLat(around.get(2));
        reqVo.setMinLat(around.get(3));
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaTencentMapDataRespVo> result = this.sfaTencentMapDataMapper.findList((Page<SfaTencentMapDataRespVo>)page, reqVo);
        result.forEach(o -> o.setDistance(this.getDistance(lat, lng, Double.parseDouble(o.getLatitude()), Double.parseDouble(o.getLongitude()))));
        List data = result.stream().sorted(Comparator.comparing(SfaTencentMapDataRespVo::getDistance)).collect(Collectors.toList());
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(data).build();
    }

    public List<String> getAround(double lat, double lon, int raidus) {
        LinkedList list = Lists.newLinkedList();
        Double degree = 111293.63611111112;
        Double dpmLat = 1.0 / degree;
        Double radiusLat = dpmLat * (double)raidus;
        Double minLat = lat - radiusLat;
        Double maxLat = lat + radiusLat;
        Double mpdLng = degree * Math.cos(lat * 0.017453292500000002);
        Double dpmLng = 1.0 / mpdLng;
        Double radiusLng = dpmLng * (double)raidus;
        Double minLng = lon - radiusLng;
        Double maxLng = lon + radiusLng;
        list.add(maxLng.toString());
        list.add(minLng.toString());
        list.add(maxLat.toString());
        list.add(minLat.toString());
        return list;
    }

    public String getDistance(double lat, double lon, double lat2, double lon2) {
        double a = Math.toRadians(lat) - Math.toRadians(lat2);
        double b = Math.toRadians(lon) - Math.toRadians(lon2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(lat) * Math.cos(lat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s = BigDecimal.valueOf(s * 6378.137).setScale(4, 4).doubleValue();
        return String.valueOf(s);
    }
}

