/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.SummaryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.SummaryStepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"summaryVisitStepExecutorExpandImpl"})
public class SummaryVisitStepExecutor
extends AbstractVisitStepRedisExecutor<SummaryStepExecuteData, SummaryStepExecuteDataResp, ExecutorLoadReq> {
    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_SUMMARY.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SummaryStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitPlanInfoRedisData redisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString(), (Object)visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = redisData.getSfaVisitPlanInfoExecuteRedisData();
        sfaVisitPlanInfoExecuteRedisData.setFormIdAsSummary(visitStepExecuteReq.getFormId());
        sfaVisitPlanInfoExecuteRedisData.setVisitSummary(executeData.getVisitSummary());
        this.changeStepStatus(redisData, SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_SUMMARY.getVal());
        sfaVisitPlanInfoExecuteRedisData.setVisitDetailStep(redisData.summaryStepStatus());
        this.redisService.hmset(redisData.redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        SummaryStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getVisitSummary())) {
            throw new BusinessException("\u8bf7\u586b\u5199\u62dc\u8bbf\u603b\u7ed3");
        }
    }

    @Override
    protected SummaryStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        if (StringUtils.isBlank((CharSequence)redisHashKey.getRedisHashKey())) {
            throw new BusinessException("redisHashKey\u4e3a\u7a7a");
        }
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoRedisData redisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString(), (Object)redisHashKey.getRedisHashKey());
        if (null == redisData) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u62dc\u8bbf\u8ba1\u5212\uff0c\u6216\u8be5\u8ba1\u5212\u4e0d\u5728\u4eca\u65e5\u8ba1\u5212\u5185\uff01");
        }
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = redisData.getSfaVisitPlanInfoExecuteRedisData();
        SummaryStepExecuteDataResp dataResp = (SummaryStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanInfoExecuteRedisData), SummaryStepExecuteDataResp.class);
        dataResp.setVisitDetailStep(redisData.summaryStepStatus());
        return dataResp;
    }

    @Override
    protected SummaryStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        return null;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        return null;
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        return null;
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
    }
}

