/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.customer.controller.SfaBusinessDetailListener;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepListener;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.HelpScoreStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.HelpScoreStepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreEsData;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepHelpScoreEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.impl.SfaVisitStepHelpScoreServiceImpl;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"helpScoreVisitStepExecutorExpandImpl"})
public class HelpScoreVisitStepExecutor<ExecuteReq extends HelpScoreStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, HelpScoreStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(HelpScoreVisitStepExecutor.class);
    @Resource
    private SfaVisitStepHelpScoreEsDataRepositories sfaVisitStepHelpScoreEsDataRepositories;
    @Resource
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource
    private SfaVisitStepHelpScoreServiceImpl visitDataDurabilityService;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return this.visitDataDurabilityService;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_HELP_SCORE.getVal();
    }

    @Override
    protected List<AbstractVisitStepListener> customerListeners(List<AbstractVisitStepListener> listeners) {
        if (null == listeners) {
            return null;
        }
        return listeners.stream().filter(v -> !(v instanceof SfaBusinessDetailListener)).collect(Collectors.toList());
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepHelpScoreRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setCoverHelpOrgCode(sfaVisitPlanInfoEntity.getCoverHelpOrgCode());
        redisData.setCoverHelpOrgName(sfaVisitPlanInfoEntity.getCoverHelpOrgName());
        redisData.setCoverHelpPosCode(sfaVisitPlanInfoEntity.getCoverHelpPosCode());
        redisData.setCoverHelpPosName(sfaVisitPlanInfoEntity.getCoverHelpPosName());
        redisData.setCoverHelpRealName(sfaVisitPlanInfoEntity.getCoverHelpRealName());
        redisData.setCoverHelpUserName(sfaVisitPlanInfoEntity.getCoverHelpUserName());
        redisData.setHelpDefenseId(sfaVisitPlanInfoEntity.getVisitPlanCode());
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    protected SfaVisitStepHelpScoreRedisData buildRedisData(VisitStepExecuteReq<? extends HelpScoreStepExecuteData> visitStepExecuteReq) {
        HelpScoreStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepHelpScoreRedisData redisData = (SfaVisitStepHelpScoreRedisData)CrmBeanUtil.copy((Object)executeData, SfaVisitStepHelpScoreRedisData.class);
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setAttachmentExt1(executeData.getAttachmentExt1());
        redisData.setAttachmentExt2(executeData.getAttachmentExt2());
        redisData.setHelpScoreDetailList(executeData.getHelpScoreDetailList());
        return redisData;
    }

    @Override
    protected HelpScoreStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        final SfaVisitPlanInfoEntity planInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepHelpScoreRedisData redisData = (SfaVisitStepHelpScoreRedisData)this.redisService.hmget(SfaVisitStepHelpScoreRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey());
        if (null == redisData) {
            redisData = new SfaVisitStepHelpScoreRedisData(){
                {
                    this.setHelpScoreDetailList(HelpScoreVisitStepExecutor.this.loadCoverVisitStepList(planInfoEntity));
                    ArrayList list = Lists.newArrayList();
                    this.setAttachmentExt1(list);
                    this.setAttachmentExt2(list);
                }
            };
        }
        HelpScoreStepExecuteDataResp dataResp = (HelpScoreStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, HelpScoreStepExecuteDataResp.class);
        dataResp.setHelpScoreDetailList(redisData.getHelpScoreDetailList());
        dataResp.setAttachmentExt1(redisData.getAttachmentExt1());
        dataResp.setAttachmentExt2(redisData.getAttachmentExt2());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    protected List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> loadCoverVisitStepList(SfaVisitPlanInfoEntity planInfoEntity) {
        Map<String, VisitStepResp> roleVisitStepMap = this.sfaVisitRoleDirectoryService.findRoleVisitStepMap(SfaVisitEnum.VisitBigType.VISIT.getVal(), planInfoEntity.getCoverHelpPosCode(), planInfoEntity.getClientType(), planInfoEntity.getClientSubclass());
        List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> helpScoreDetailList = roleVisitStepMap.values().stream().map(v -> {
            HelpScoreStepExecuteData.HelpScoreDetailReqVo temp = (HelpScoreStepExecuteData.HelpScoreDetailReqVo)((Object)((Object)CrmBeanUtil.copy((Object)v, HelpScoreStepExecuteData.HelpScoreDetailReqVo.class)));
            temp.setQualified(YesNoEnum.yesNoEnum.ONE.getValue());
            temp.setQualifiedName(YesNoEnum.yesNoEnum.ONE.getDes());
            return temp;
        }).sorted(Comparator.comparing(HelpScoreStepExecuteData.HelpScoreDetailReqVo::getSort)).collect(Collectors.toList());
        return helpScoreDetailList;
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        SfaVisitStepHelpScoreEsData esData = this.sfaVisitStepHelpScoreEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional optional = this.sfaVisitStepHelpScoreEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (StepExecuteDataResp)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
    }

    @Override
    protected HelpScoreStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (StringUtils.isNotBlank((CharSequence)visitPlanInfoId)) {
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            SfaVisitStepHelpScoreEsData redisData = (SfaVisitStepHelpScoreEsData)this.getEsDataByVisitPlanInfo(visitPlanInfoId, loadParam.getStepCode());
            return this.buildDataResp(redisData);
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u4e1a\u52a1ID!");
        }
        SfaVisitStepHelpScoreEsData esData = (SfaVisitStepHelpScoreEsData)this.getEsDataById(bizId);
        return this.buildDataResp(esData);
    }

    private HelpScoreStepExecuteDataResp buildDataResp(SfaVisitStepHelpScoreEsData esData) {
        if (null == esData) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
        }
        HelpScoreStepExecuteDataResp dataResp = (HelpScoreStepExecuteDataResp)CrmBeanUtil.copy((Object)esData, HelpScoreStepExecuteDataResp.class);
        dataResp.setHelpScoreDetailList(esData.getHelpScoreDetailList());
        dataResp.setAttachmentExt1(esData.getAttachmentExt1());
        dataResp.setAttachmentExt2(esData.getAttachmentExt2());
        dataResp.setSfaVisitStepFrom(esData.getSfaVisitStepFrom());
        return dataResp;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepHelpScoreRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        redisData.setScoreTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setScoreDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        redisData.setScoreYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        redisData.setScoreYear(LocalDateTime.now().format(CrmDateUtils.yyyy));
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        HelpScoreStepExecuteData executeData = (HelpScoreStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == executeData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)executeData.getKeyQuestions())) {
            throw new BusinessException("\u91cd\u70b9\u95ee\u9898\u8bb0\u5f55\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)executeData.getHelpDefenseSummary())) {
            throw new BusinessException("\u534f\u8bbf\u603b\u7ed3\u4e3a\u7a7a");
        }
        this.checkHelpScoreDetail(sfaVisitPlanInfoEntity, executeData);
    }

    protected void checkHelpScoreDetail(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, HelpScoreStepExecuteData executeData) {
        List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> helpScoreDetailList = executeData.getHelpScoreDetailList();
        if (null == helpScoreDetailList) {
            return;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (HelpScoreStepExecuteData.HelpScoreDetailReqVo helpScoreDetailReqVo : helpScoreDetailList) {
            if (StringUtils.isBlank((CharSequence)helpScoreDetailReqVo.getIcon())) {
                throw new BusinessException("\u534f\u8bbf\u8bc4\u4ef7\u6b65\u9aa4\u56fe\u7247\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)helpScoreDetailReqVo.getStepCode())) {
                throw new BusinessException("\u534f\u8bbf\u8bc4\u4ef7\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)helpScoreDetailReqVo.getStepName())) {
                throw new BusinessException("\u534f\u8bbf\u8bc4\u4ef7\u6b65\u9aa4\u540d\u79f0\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)helpScoreDetailReqVo.getQualified())) continue;
            joiner.add(helpScoreDetailReqVo.getStepName());
        }
        if (joiner.length() > 0) {
            throw new BusinessException("\u6b65\u9aa4[" + joiner.toString() + "]\u672a\u5b8c\u6210\u534f\u8bbf\u8bc4\u4ef7");
        }
    }

    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepHelpScoreRedisData redisData = (SfaVisitStepHelpScoreRedisData)this.redisService.hmget(SfaVisitStepHelpScoreRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), (Object)loadParam.getRedisHashKey());
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)loadParam)));
            return null;
        }
        return Lists.newArrayList((Object[])new SfaVisitStepHelpScoreRedisData[]{redisData});
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        SfaVisitStepHelpScoreRedisData redisData = (SfaVisitStepHelpScoreRedisData)this.redisService.hmget(SfaVisitStepHelpScoreRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey(), executorLoadReq.getStepCode()).toString(), (Object)executorLoadReq.getRedisHashKey());
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)executorLoadReq)));
            return;
        }
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(executorLoadReq.getFormId());
        this.doTransToEs(redisData, fromRespVo);
    }

    protected void doTransToEs(SfaVisitStepHelpScoreRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepHelpScoreEsData oldData;
        SfaVisitStepHelpScoreEsData dataResp = (SfaVisitStepHelpScoreEsData)CrmBeanUtil.copy((Object)redisData, SfaVisitStepHelpScoreEsData.class);
        dataResp.setHelpScoreDetailList(redisData.getHelpScoreDetailList());
        dataResp.setAttachmentExt1(redisData.getAttachmentExt1());
        dataResp.setAttachmentExt2(redisData.getAttachmentExt2());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        if (StringUtils.isNotBlank((CharSequence)dataResp.getVisitPlanInfoId()) && null != (oldData = (SfaVisitStepHelpScoreEsData)this.getEsDataByVisitPlanInfo(dataResp.getVisitPlanInfoId(), dataResp.getStepCode()))) {
            dataResp.setId(oldData.getId());
        }
        this.sfaVisitStepHelpScoreEsDataRepositories.save(dataResp);
    }
}

