/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.assistant.service.ISfaWorkSummaryService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.checkin.model.SfaCheckInSignRecordPictureEntity;
import com.biz.crm.checkin.service.ISfaCheckInSignRecordPictureService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.SfaWorkSummaryEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInSignRecordPictureRespVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaExceptionReportDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplyDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplySummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaMonthSignReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignAddRecordSearchReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeSummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaExceptionReportDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplyDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplySummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignDaysInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaSignAddRecordInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaSignDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeSummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditListLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAddSignTypeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkOvertimeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.SfaSignUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaLeaveMapper;
import com.biz.crm.worksign.mapper.SfaSignFormsMapper;
import com.biz.crm.worksign.mapper.SfaWorkOvertimeMapper;
import com.biz.crm.worksign.model.SfaWorkSignPictureEntity;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaExceptionReportService;
import com.biz.crm.worksign.service.ISfaLeaveCancelService;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.biz.crm.worksign.service.ISfaTravelService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import com.biz.crm.worksign.service.ISfaWorkSignPictureService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SfaSignFormsServiceImpl
implements ISfaSignFormsService {
    @Resource
    private SfaSignFormsMapper mapper;
    @Autowired
    private ISfaWorkOvertimeService overtimeService;
    @Resource
    private SfaWorkOvertimeMapper overtimeMapper;
    @Autowired
    private ISfaLeaveService leaveService;
    @Autowired
    private ISfaLeaveCancelService cancelService;
    @Resource
    private SfaLeaveMapper leaveMapper;
    @Autowired
    private ISfaExceptionReportService exceptionService;
    @Autowired
    private ISfaTravelService travelService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Autowired
    ISfaLeaveCancelService leaveCancelService;
    @Autowired
    ISfaCheckInSignRecordPictureService pictureService;
    @Resource
    ISfaWorkSignRuleInfoService sfaWorkSignRuleInfoService;
    @Resource
    ISfaWorkSignRecordService sfaWorkSignRecordService;
    @Autowired
    private ISfaWorkSummaryService sfaWorkSummaryService;
    @Resource
    private ISfaWorkSignPictureService sfaWorkSignPictureService;
    @Resource
    private ISfaCheckInSignRecordPictureService sfaCheckInSignRecordPictureService;
    private static final String PLUS_STR = "+";
    private static final String LEAVE_STATUS_STATIC = "\u8bf7\u5047";
    private static final String WEEKEND_STATUS_STATIC = "\u4f11\u606f";
    private static final String OVERTIME_STATUS_STATIC = "\u52a0\u73ed";

    @Override
    public SfaSignAddRecordInfoRespVo getSignAddRecordInfo(SfaSignAddRecordSearchReqVo sfaSignAddRecordSearchReqVo) {
        if (StringUtils.isEmpty((String)sfaSignAddRecordSearchReqVo.getPosCode()) || StringUtils.isEmpty((String)sfaSignAddRecordSearchReqVo.getOrgCode()) || StringUtils.isEmpty((String)sfaSignAddRecordSearchReqVo.getRuleDate()) || StringUtils.isEmpty((String)sfaSignAddRecordSearchReqVo.getUserName())) {
            throw new BusinessException("\u4f20\u5165\u53c2\u6570\uff0c\u5b58\u5728\u7a7a\u503c");
        }
        SfaWorkSignRuleInfoEntity ruleInfoEntity = (SfaWorkSignRuleInfoEntity)((Object)this.sfaWorkSignRuleInfoService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRuleInfoEntity.class).eq(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)sfaSignAddRecordSearchReqVo.getRuleDate())).eq(SfaWorkSignRuleInfoEntity::getUserName, (Object)sfaSignAddRecordSearchReqVo.getUserName())).eq(SfaWorkSignRuleInfoEntity::getOrgCode, (Object)sfaSignAddRecordSearchReqVo.getOrgCode())).eq(SfaWorkSignRuleInfoEntity::getPosCode, (Object)sfaSignAddRecordSearchReqVo.getPosCode())));
        if (ruleInfoEntity == null) {
            throw new BusinessException("\u672a\u627e\u5230\u76f8\u5173\u89c4\u5219");
        }
        List recordEntities = this.sfaWorkSignRecordService.list((Wrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)ruleInfoEntity.getId()));
        List signTypeRespVos = CrmBeanUtil.copyList((List)recordEntities, SfaAddSignTypeRespVo.class);
        signTypeRespVos.forEach(data -> data.setWorkSignTypeName(SfaWorkSignEnum.WorkSignType.getDesc((String)data.getWorkSignType())));
        SfaSignAddRecordInfoRespVo infoRespVo = (SfaSignAddRecordInfoRespVo)CrmBeanUtil.copy((Object)((Object)ruleInfoEntity), SfaSignAddRecordInfoRespVo.class);
        infoRespVo.setRuleTypeName(SfaWorkSignEnum.WorkSignRuleType.getDesc((String)infoRespVo.getRuleType()));
        infoRespVo.setSfaAddSignTypeRespVoList(signTypeRespVos);
        return infoRespVo;
    }

    @Override
    public List<Map<String, String>> getWorkSignType() {
        List<Map<String, String>> list = this.mapper.getWorkSignType();
        if (CollectionUtil.listEmpty(list)) {
            list = new ArrayList<Map<String, String>>();
        }
        HashMap<String, String> clockInMap = new HashMap<String, String>();
        clockInMap.put("typeKey", SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal());
        clockInMap.put("typeValue", SfaWorkSignEnum.WorkSignType.CLOCK_IN.getDesc());
        list.add(clockInMap);
        HashMap<String, String> clockOutMap = new HashMap<String, String>();
        clockOutMap.put("typeKey", SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal());
        clockOutMap.put("typeValue", SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getDesc());
        list.add(clockOutMap);
        return list;
    }

    @Override
    public SfaSignDetailRespVo getSignInfo(String id, String ruleType) {
        AssertUtils.isNotEmpty((String)id, (String)"\u5165\u53c2id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)ruleType, (String)"\u5165\u53c2ruleType\u4e0d\u80fd\u4e3a\u7a7a");
        SfaSignDetailRespVo signInfo = this.mapper.getSignInfo(id, ruleType);
        if (null == signInfo) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be6\u60c5");
        }
        signInfo.setWorkSignStatusDesc(SfaWorkSignEnum.WorkSignStatus.getDesc((String)signInfo.getWorkSignStatus()));
        signInfo.setRuleTypeDesc(SfaWorkSignEnum.WorkSignRuleType.getDesc((String)signInfo.getRuleType()));
        if (StringUtils.isNotEmpty((String)signInfo.getWorkSignTime())) {
            signInfo.setWorkSignTime(signInfo.getRuleDate() + " " + signInfo.getWorkSignTime());
        } else {
            signInfo.setWorkSignTime(signInfo.getRuleDate());
        }
        if (SfaWorkSignEnum.WorkSignRuleType.FREE.getVal().equals(ruleType)) {
            List pictureEntities = this.sfaCheckInSignRecordPictureService.list((Wrapper)Wrappers.lambdaQuery(SfaCheckInSignRecordPictureEntity.class).eq(SfaCheckInSignRecordPictureEntity::getSignRecordId, (Object)id));
            List recordPictureRespVos = CrmBeanUtil.copyList((List)pictureEntities, SfaCheckInSignRecordPictureRespVo.class);
            signInfo.setSignPictures(recordPictureRespVos);
        } else {
            List pictureEntities = this.sfaWorkSignPictureService.list((Wrapper)Wrappers.lambdaQuery(SfaWorkSignPictureEntity.class).eq(SfaWorkSignPictureEntity::getWsRecordId, (Object)id));
            List recordPictureRespVos = CrmBeanUtil.copyList((List)pictureEntities, SfaCheckInSignRecordPictureRespVo.class);
            signInfo.setSignPictures(recordPictureRespVos);
        }
        signInfo.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.getDesc((String)signInfo.getWsPlaceStatus()));
        return signInfo;
    }

    @Override
    public PageResult<SfaSignDetailRespVo> signDetail(SfaSignDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaSignDetailRespVo> list = this.mapper.signDetail((Page<SfaSignDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> {
                vo.setWorkSignStatusDesc(SfaWorkSignEnum.WorkSignStatus.getDesc((String)vo.getWorkSignStatus()));
                vo.setRuleTypeDesc(SfaWorkSignEnum.WorkSignRuleType.getDesc((String)vo.getRuleType()));
                if (StringUtils.isNotEmpty((String)vo.getWorkSignTime())) {
                    vo.setWorkSignTime(vo.getRuleDate() + " " + vo.getWorkSignTime());
                } else {
                    vo.setWorkSignTime(vo.getRuleDate());
                }
                if (SfaWorkSignEnum.WorkSignRuleType.FREE.getVal().equals(vo.getRuleType())) {
                    if (StringUtils.isNotEmpty((String)vo.getId())) {
                        vo.setSignPictures(this.pictureService.findList(vo.getId()));
                    }
                } else if (StringUtils.isNotEmpty((String)vo.getPicPath()) || StringUtils.isNotEmpty((String)vo.getPicUrl())) {
                    SfaCheckInSignRecordPictureRespVo pictureRespVo = new SfaCheckInSignRecordPictureRespVo();
                    pictureRespVo.setPicPath(vo.getPicPath());
                    pictureRespVo.setPicUrl(vo.getPicUrl());
                    vo.setSignPictures(Arrays.asList(pictureRespVo));
                }
                vo.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.getDesc((String)vo.getWsPlaceStatus()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaMonthSignRespVo> monthSign(SfaMonthSignReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaMonthSignRespVo> list = this.mapper.monthSignUserInfo((Page<SfaMonthSignRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            String nowDay = new Integer(LocalDate.now().getDayOfMonth()).toString();
            LocalDate localDate = LocalDate.parse(reqVo.getYearMonth() + "-01");
            if (LocalDate.now().getMonthValue() != localDate.getMonthValue()) {
                nowDay = localDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth() + "";
            }
            HashMap<String, SfaMonthSignRespVo> userInfoMap = new HashMap<String, SfaMonthSignRespVo>();
            for (SfaMonthSignRespVo vo : list) {
                userInfoMap.put(vo.getUserName(), vo);
                vo.setNowDay(nowDay);
            }
            List<SfaMonthSignDaysInfoRespVo> daysInfoList = this.mapper.monthSignDaysInfo(reqVo.getYearMonth(), new ArrayList<String>(userInfoMap.keySet()));
            if (daysInfoList != null && daysInfoList.size() > 0) {
                for (SfaMonthSignDaysInfoRespVo vo : daysInfoList) {
                    SfaMonthSignRespVo monthSign = (SfaMonthSignRespVo)userInfoMap.get(vo.getUserName());
                    if (YesNoEnum.yesNoEnum.YES.getValue().equals(vo.getSignMust())) {
                        String leaveType = this.getLeaveType(vo.getLeaveJson(), vo.getCancelDayJson(), vo.getRuleDate());
                        this.signRuleStatus(monthSign, vo, vo.getCiSignStatus(), vo.getCoSignStatus(), vo.getRuleDate(), leaveType);
                        continue;
                    }
                    this.nonSifnRuleStatus(monthSign, vo, vo.getRuleDate(), vo.getOvertimeType());
                }
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private String getLeaveType(String leaveJson, String cancelDayJson, String ruleDate) {
        String leaveType = SfaApplyTimeInfoReqVo.getTypeByDate((String)leaveJson, (String)ruleDate);
        String cancelType = SfaApplyTimeInfoReqVo.getTypeByDate((String)cancelDayJson, (String)ruleDate);
        if (StringUtils.isEmpty((String)leaveType)) {
            return null;
        }
        if (leaveType.equals(cancelType)) {
            return null;
        }
        if (StringUtils.isEmpty((String)cancelType)) {
            return leaveType;
        }
        if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(cancelType)) {
            return SfaCommonEnum.dataTimeType.AFTERNOON.getValue();
        }
        return SfaCommonEnum.dataTimeType.FORENOON.getValue();
    }

    private void signRuleStatus(SfaMonthSignRespVo monthSign, SfaMonthSignDaysInfoRespVo dayInfo, String ciSignStatus, String coSignStatus, String date, String leaveType) {
        if ("21".equals(dayInfo.getSignOrNonType())) {
            ciSignStatus = SfaWorkSignEnum.WorkSignStatus.OK.getVal();
            coSignStatus = SfaWorkSignEnum.WorkSignStatus.OK.getVal();
            dayInfo.setCiSignTime(dayInfo.getGotoTime());
            dayInfo.setCoSignTime(dayInfo.getGooffTime());
        }
        String statusStr = SfaWorkSignEnum.SignRuleStatus.getDesc((String)(ciSignStatus + PLUS_STR + coSignStatus));
        if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(leaveType)) {
            statusStr = LEAVE_STATUS_STATIC;
            monthSign.addLeaveDays(BigDecimal.ONE);
        } else if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(leaveType)) {
            statusStr = "\u8bf7\u5047+" + statusStr;
            monthSign.addLeaveDays(new BigDecimal(0.5));
        } else if (SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(leaveType)) {
            statusStr = statusStr + PLUS_STR + LEAVE_STATUS_STATIC;
            monthSign.addLeaveDays(new BigDecimal(0.5));
        }
        this.setMonthSignValue(monthSign, "day" + LocalDate.parse(date).getDayOfMonth(), statusStr);
        if (StringUtils.isEmpty((String)leaveType)) {
            monthSign.addGoToWorkDaysl(BigDecimal.ONE);
            if (SfaWorkSignEnum.WorkSignStatus.BE_LATE.getVal().equals(ciSignStatus)) {
                monthSign.addLateDays(1);
            }
            if (SfaWorkSignEnum.WorkSignStatus.LEAVE_EARLY.getVal().equals(coSignStatus)) {
                monthSign.addEarlyDays(1);
            }
            if (!SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(ciSignStatus) || !SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(coSignStatus)) {
                monthSign.addWeekDays(1);
            }
            if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(ciSignStatus) && SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(coSignStatus)) {
                monthSign.addAbsenteeismDays(BigDecimal.ONE);
            } else if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(ciSignStatus) || SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(coSignStatus)) {
                monthSign.addAbsenteeismDays(BigDecimal.ONE);
            }
            if (SfaWorkSignEnum.WorkSignStatus.OK.getVal().equals(ciSignStatus) && SfaWorkSignEnum.WorkSignStatus.OK.getVal().equals(coSignStatus)) {
                monthSign.addNormal(BigDecimal.ONE);
            }
        }
        if (StringUtils.isNotEmpty((String)dayInfo.getCiSignTime()) && StringUtils.isNotEmpty((String)dayInfo.getCoSignTime())) {
            long time = ChronoUnit.MINUTES.between(LocalTime.parse(dayInfo.getCiSignTime()), LocalTime.parse(dayInfo.getCoSignTime()));
            int hour = (int)time / 6;
            float endTime = (float)hour / 10.0f;
            BigDecimal dayTime = new BigDecimal(endTime + "");
            monthSign.addAllTimes(dayTime);
            this.setMonthSignValue(monthSign, "dayTime" + LocalDate.parse(date).getDayOfMonth(), dayTime);
        }
        if (dayInfo.isExceptionReport()) {
            BigDecimal dayTime = new BigDecimal(0);
            long time = ChronoUnit.MINUTES.between(LocalTime.parse(dayInfo.getGotoTime()), LocalTime.parse(dayInfo.getGooffTime()));
            if (dayInfo.getCiSignStatus().equals(dayInfo.getCoSignStatus())) {
                int hour = (int)time / 6;
                float endTime = (float)hour / 10.0f;
                dayTime = new BigDecimal(endTime + "");
                monthSign.addAllTimes(dayTime);
            } else {
                int hour = (int)time / 12;
                float endTime = (float)hour / 10.0f;
                dayTime = new BigDecimal(endTime + "");
                monthSign.addAllTimes(dayTime);
            }
            this.setMonthSignValue(monthSign, "dayTime" + LocalDate.parse(date).getDayOfMonth(), dayTime);
        }
    }

    private void nonSifnRuleStatus(SfaMonthSignRespVo monthSign, SfaMonthSignDaysInfoRespVo dayInfo, String date, String overtimeType) {
        String statusStr = WEEKEND_STATUS_STATIC;
        if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(overtimeType)) {
            statusStr = OVERTIME_STATUS_STATIC;
            monthSign.addOvertimeDays(new BigDecimal(1));
        } else if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(overtimeType)) {
            statusStr = "\u52a0\u73ed+" + statusStr;
            monthSign.addOvertimeDays(new BigDecimal(0.5));
            monthSign.addOffDays(new BigDecimal(0.5));
        } else if (SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(overtimeType)) {
            statusStr = statusStr + PLUS_STR + OVERTIME_STATUS_STATIC;
            monthSign.addOvertimeDays(new BigDecimal(0.5));
            monthSign.addOffDays(new BigDecimal(0.5));
        } else {
            monthSign.addOffDays(BigDecimal.ONE);
        }
        this.setMonthSignValue(monthSign, "day" + LocalDate.parse(date).getDayOfMonth(), statusStr);
        if (StringUtils.isNotEmpty((String)overtimeType)) {
            monthSign.addGoToWorkDaysl(BigDecimal.ONE);
            if (!SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(dayInfo.getCiSignStatus()) || !SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(dayInfo.getCoSignStatus())) {
                monthSign.addWeekDays(1);
            }
            if (SfaWorkSignEnum.WorkSignStatus.OK.getVal().equals(dayInfo.getCiSignStatus()) && SfaWorkSignEnum.WorkSignStatus.OK.getVal().equals(dayInfo.getCoSignStatus())) {
                monthSign.addNormal(BigDecimal.ONE);
            }
            if (StringUtils.isNotEmpty((String)dayInfo.getCiSignTime()) && StringUtils.isNotEmpty((String)dayInfo.getCoSignTime())) {
                LocalTime.parse(dayInfo.getCiSignTime());
                long time = ChronoUnit.HOURS.between(LocalTime.parse(dayInfo.getCiSignTime()), LocalTime.parse(dayInfo.getCoSignTime()));
                BigDecimal dayTime = new BigDecimal(time);
                monthSign.addAllTimes(dayTime);
                this.setMonthSignValue(monthSign, "dayTime" + LocalDate.parse(date).getDayOfMonth(), dayTime);
            }
        }
    }

    private void setMonthSignValue(SfaMonthSignRespVo monthSign, String key, Object value) {
        try {
            Class<?> c = monthSign.getClass();
            Field f = c.getDeclaredField(key);
            f.setAccessible(true);
            f.set(monthSign, value);
        }
        catch (Exception e) {
            throw new BusinessException("\u8003\u52e4\u540e\u53f0\u62a5\u9519");
        }
    }

    @Override
    public PageResult<SfaLeaveApplyDetailRespVo> leaveApplyDetail(SfaLeaveApplyDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveApplyDetailRespVo> list = this.leaveMapper.leaveApplyDetail((Page<SfaLeaveApplyDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> {
                vo.setLeaveCancelRespVo(this.leaveCancelService.findList(new SfaLeaveCancelReqVo(vo.getId())));
                vo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus()));
                vo.setLeaveTypeName(SfaCommonEnum.leaveTypeEnum.getDesc((String)vo.getLeaveType()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaLeaveApplySummaryRespVo> leaveApplySummary(SfaLeaveApplySummaryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveApplySummaryRespVo> summarylist = this.leaveMapper.leaveApplySummary((Page<SfaLeaveApplySummaryRespVo>)page, reqVo);
        if (summarylist != null && summarylist.size() > 0) {
            Map<String, MdmPositionUserOrgRespVo> mdmUserMap = this.getUserOrgInfoByUserNames(summarylist.stream().map(SfaLeaveApplySummaryRespVo::getUserName).collect(Collectors.toList()));
            SfaLeaveApplyDetailReqVo detailReqVo = (SfaLeaveApplyDetailReqVo)CrmBeanUtil.copy((Object)reqVo, SfaLeaveApplyDetailReqVo.class);
            detailReqVo.setBeginTime(reqVo.getLeaveDateStart());
            detailReqVo.setEndTime(reqVo.getLeaveDateEnd());
            detailReqVo.setBpmStatus(SfaCommonEnum.dataBpmStatus.PASS.getValue());
            List<SfaLeaveApplyDetailRespVo> detailRespVoList = this.leaveMapper.leaveApplyDetail(null, detailReqVo);
            Map<String, List<SfaLeaveApplyDetailRespVo>> userDetailMap = detailRespVoList.stream().collect(Collectors.groupingBy(SfaLeaveApplyDetailRespVo::getUserName));
            SfaLeaveCancelReqVo cancelReqVo = new SfaLeaveCancelReqVo();
            cancelReqVo.setLeaveIdList(detailRespVoList.stream().map(SfaLeaveApplyDetailRespVo::getId).collect(Collectors.toList()));
            List<SfaLeaveCancelRespVo> leaveCancelRespVoList = this.cancelService.findList(cancelReqVo);
            Map<String, List<SfaLeaveCancelRespVo>> leaveCancelMap = leaveCancelRespVoList.stream().collect(Collectors.groupingBy(SfaLeaveCancelRespVo::getLeaveId));
            String beginTime = reqVo.getLeaveDateStart();
            String endTime = reqVo.getLeaveDateEnd();
            for (SfaLeaveApplySummaryRespVo summaryVo : summarylist) {
                MdmPositionUserOrgRespVo mdmUser = mdmUserMap.get(summaryVo.getUserName());
                if (mdmUser != null) {
                    summaryVo.setPosName(mdmUser.getPositionName());
                    summaryVo.setParentOrgName(mdmUser.getParentOrgName());
                    summaryVo.setOrgName(mdmUser.getOrgName());
                }
                List<SfaLeaveApplyDetailRespVo> list = userDetailMap.get(summaryVo.getUserName());
                for (SfaLeaveApplyDetailRespVo vo : list) {
                    BigDecimal count = SfaSignUtils.countCreateNewTimeInfo((String)beginTime, (String)endTime, (List)JSON.parseArray((String)vo.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class));
                    if (StringUtils.isNotEmpty((String)vo.getNonWorkDateListJson())) {
                        List nonWorkTimeInfoList = JSON.parseArray((String)vo.getNonWorkDateListJson(), SfaApplyTimeInfoReqVo.class);
                        for (SfaApplyTimeInfoReqVo sfaApplyTimeInfoReqVo : nonWorkTimeInfoList) {
                            BigDecimal nonWorkCount = SfaSignUtils.countCreateNewTimeInfo((String)beginTime, (String)endTime, Arrays.asList(sfaApplyTimeInfoReqVo));
                            count = count.subtract(nonWorkCount);
                        }
                    }
                    if (leaveCancelMap.get(vo.getId()) != null) {
                        List<SfaLeaveCancelRespVo> leaveCancelRespVoList1 = leaveCancelMap.get(vo.getId());
                        for (SfaLeaveCancelRespVo sfaLeaveCancelRespVo : leaveCancelRespVoList1) {
                            BigDecimal cancelWorkCount = SfaSignUtils.countCreateNewTimeInfo((String)beginTime, (String)endTime, (List)sfaLeaveCancelRespVo.getTimeInfoList());
                            count = count.subtract(cancelWorkCount);
                        }
                    }
                    if (SfaCommonEnum.leaveTypeEnum.ANNUAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setAnnualLeave(summaryVo.getAnnualLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.PERSONAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setPersonalLeave(summaryVo.getPersonalLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.MARRIAGE_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setMarriageLeave(summaryVo.getMarriageLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.FUNERAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setFuneralLeave(summaryVo.getFuneralLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.PATERNITY_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setPaternityLeave(summaryVo.getPaternityLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.DAYS_OFF.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setDaysOff(summaryVo.getDaysOff().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.SICK_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setSickLeave(summaryVo.getSickLeave().add(count));
                        continue;
                    }
                    if (!SfaCommonEnum.leaveTypeEnum.MATERNITY_LEAVE.getVal().equals(vo.getLeaveType())) continue;
                    summaryVo.setMaternityLeave(summaryVo.getMaternityLeave().add(count));
                }
            }
        }
        return PageResult.builder().data(summarylist).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaWorkOvertimeDetailRespVo> workOvertimeDetail(SfaWorkOvertimeDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkOvertimeDetailRespVo> list = this.overtimeMapper.workOvertimeDetail((Page<SfaWorkOvertimeDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> vo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaWorkOvertimeSummaryRespVo> workOvertimeSummary(SfaWorkOvertimeSummaryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        reqVo.setIndate(Integer.valueOf(this.overtimeService.getOvertimeIndate()));
        List<SfaWorkOvertimeSummaryRespVo> list = this.overtimeMapper.workOvertimeSummary((Page<SfaWorkOvertimeSummaryRespVo>)page, reqVo);
        if (list != null && list.size() > 0 && list.get(0) != null) {
            Map<String, MdmPositionUserOrgRespVo> mdmUserMap = this.getUserOrgInfoByUserNames(list.stream().map(SfaWorkOvertimeSummaryRespVo::getUserName).collect(Collectors.toList()));
            list.forEach(vo -> {
                MdmPositionUserOrgRespVo mdmUser = (MdmPositionUserOrgRespVo)mdmUserMap.get(vo.getUserName());
                if (mdmUser != null) {
                    vo.setPosName(mdmUser.getPositionName());
                    vo.setParentOrgName(mdmUser.getParentOrgName());
                    vo.setOrgName(mdmUser.getOrgName());
                    String orgCode = mdmUser.getOrgCode();
                    vo.setOrgName(mdmUser.getOrgName());
                    MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode((String)orgCode);
                    if (null != mdmOrgRespVo) {
                        vo.setParentOrgName(mdmOrgRespVo.getParentName());
                    }
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaExceptionReportDetailRespVo> exceptionReportDetail(SfaExceptionReportDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaExceptionReportDetailRespVo> list = this.mapper.exceptionReportDetail((Page<SfaExceptionReportDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> {
                List<String> ids = Stream.of(vo.getExceptionRecordIds().split(",")).collect(Collectors.toList());
                List<SfaWorkSignRecordRespVo> recordRespVos = this.mapper.findRecordsById(ids);
                AssertUtils.isNotNull(recordRespVos, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
                String collect = recordRespVos.stream().map(e -> e.getWorkSignDesc() + "(" + e.getWorkSignTime() + ")").collect(Collectors.joining("\u3001"));
                vo.setExceptionRecordType(collect);
                vo.setClockDate(vo.getBeginTime());
                vo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaTravelRespVo> travelDetail(SfaTravelReqVo reqVo) {
        return this.travelService.findList(reqVo);
    }

    @Override
    public MdmPositionUserOrgRespVo getUserOrgInfo(String userName) {
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setUserName(userName);
        positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        List userList = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), (boolean)true);
        if (userList == null || userList.size() == 0 || userList.get(0) == null) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (userList.size() != 1) {
            throw new BusinessException("\u7528\u6237\u4e3b\u804c\u4f4d\u5b58\u5728\u591a\u4e2a");
        }
        return (MdmPositionUserOrgRespVo)userList.get(0);
    }

    public Map<String, MdmPositionUserOrgRespVo> getUserOrgInfoByUserNames(List<String> userNameList) {
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setUserNameList(userNameList);
        positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        List userList = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), (boolean)true);
        if (userList == null || userList.size() == 0 || userList.get(0) == null) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return userList.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getUserName, v -> v, (t, t2) -> t2));
    }

    @Override
    public SfaWorkOvertimeRespVo queryOvertiem(String auditTaskId) {
        return this.overtimeService.queryByAuditTaskId(auditTaskId);
    }

    @Override
    public SfaLeaveRespVo queryleave(String auditTaskId) {
        return this.leaveService.queryByAuditTaskId(auditTaskId);
    }

    @Override
    public SfaExceptionReportDetailRespVo queryException(String auditTaskId) {
        SfaExceptionReportDetailRespVo respVo = this.mapper.queryByAuditTaskId(auditTaskId);
        AssertUtils.isNotNull((Object)respVo, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        List<String> ids = Stream.of(respVo.getExceptionRecordIds().split(",")).collect(Collectors.toList());
        List<SfaWorkSignRecordRespVo> recordRespVos = this.mapper.findRecordsById(ids);
        AssertUtils.isNotNull(recordRespVos, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        String collect = recordRespVos.stream().map(e -> e.getWorkSignDesc() + "(" + e.getWorkSignTime() + ")").collect(Collectors.joining("\u3001"));
        respVo.setExceptionRecordType(collect);
        respVo.setClockDate(respVo.getBeginTime());
        respVo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc((String)respVo.getBpmStatus()));
        return respVo;
    }

    @Override
    public SfaLeaveCancelInfoRespVo queryLeaveCancel(final String auditTaskId) {
        SfaAuditListLeaveCancelReqVo reqVo = new SfaAuditListLeaveCancelReqVo(){
            {
                this.setAuditTaskIdList(Arrays.asList(auditTaskId));
            }
        };
        PageResult<SfaLeaveCancelInfoRespVo> pageResult = this.leaveCancelService.findInfoList(reqVo);
        if (pageResult == null || pageResult.getCount() != 1L) {
            throw new BusinessException("\u5ba1\u6838\u4efb\u52a1ID\u9519\u8bef");
        }
        return (SfaLeaveCancelInfoRespVo)pageResult.getData().get(0);
    }

    @Override
    public SfaTravelRespVo queryTravel(String auditTaskId) {
        return this.travelService.queryByAuditTaskId(auditTaskId);
    }

    @Override
    public SfaMonthSignRespVo appUserByMonthSign(SfaMonthSignReqVo reqVo) {
        SfaMonthSignRespVo respVo = new SfaMonthSignRespVo();
        if (null == reqVo) {
            reqVo = new SfaMonthSignReqVo();
            reqVo.setUserName(UserUtils.getUser().getUsername());
            reqVo.setYearMonth(DateUtil.yyyy_MM.format(new Date()));
        }
        if (null != reqVo && StringUtils.isEmpty((String)reqVo.getUserName())) {
            reqVo.setUserName(UserUtils.getUser().getUsername());
        }
        if (null != reqVo && StringUtils.isNotEmpty((String)reqVo.getTimeType()) && WorkSignEnum.TimeType.SY.getVal().equals(reqVo.getTimeType())) {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(2, -1);
            Date m = c.getTime();
            reqVo.setYearMonth(DateUtil.yyyy_MM.format(m));
        } else {
            reqVo.setYearMonth(DateUtil.yyyy_MM.format(new Date()));
        }
        List<SfaMonthSignRespVo> list = this.mapper.monthSignUserInfoByUsername(reqVo);
        if (list != null && list.size() > 0) {
            String nowDay = new Integer(LocalDate.now().getDayOfMonth()).toString();
            LocalDate localDate = LocalDate.parse(reqVo.getYearMonth() + "-01");
            if (LocalDate.now().getMonthValue() != localDate.getMonthValue()) {
                nowDay = localDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth() + "";
            }
            HashMap<String, SfaMonthSignRespVo> userInfoMap = new HashMap<String, SfaMonthSignRespVo>();
            for (SfaMonthSignRespVo sfaMonthSignRespVo : list) {
                userInfoMap.put(sfaMonthSignRespVo.getUserName(), sfaMonthSignRespVo);
                sfaMonthSignRespVo.setNowDay(nowDay);
            }
            List<SfaMonthSignDaysInfoRespVo> daysInfoList = this.mapper.monthSignDaysInfo(reqVo.getYearMonth(), new ArrayList<String>(userInfoMap.keySet()));
            if (daysInfoList != null && daysInfoList.size() > 0) {
                for (SfaMonthSignDaysInfoRespVo vo : daysInfoList) {
                    SfaMonthSignRespVo monthSign = (SfaMonthSignRespVo)userInfoMap.get(vo.getUserName());
                    if (YesNoEnum.yesNoEnum.YES.getValue().equals(vo.getSignMust())) {
                        String leaveType = this.getLeaveType(vo.getLeaveJson(), vo.getCancelDayJson(), vo.getRuleDate());
                        this.signRuleStatus(monthSign, vo, vo.getCiSignStatus(), vo.getCoSignStatus(), vo.getRuleDate(), leaveType);
                        continue;
                    }
                    this.nonSifnRuleStatus(monthSign, vo, vo.getRuleDate(), vo.getOvertimeType());
                }
            }
            respVo = (SfaMonthSignRespVo)userInfoMap.get(reqVo.getUserName());
            SfaTravelReqVo sfaTravelReqVo = new SfaTravelReqVo();
            sfaTravelReqVo.setTravelUserNames(reqVo.getUserName());
            sfaTravelReqVo.setYearMonth(reqVo.getYearMonth());
            List<SfaTravelRespVo> sfaTravelRespVoList = this.travelService.findDataList(sfaTravelReqVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaTravelRespVoList)) {
                Integer travelDays = 0;
                for (SfaTravelRespVo travelRespVo : sfaTravelRespVoList) {
                    try {
                        int datsInt;
                        Date endDate = DateUtil.date_sdf.parse(travelRespVo.getEndTime());
                        Date beginDate = DateUtil.date_sdf.parse(travelRespVo.getBeginTime());
                        if (!travelRespVo.getBeginTime().contains(sfaTravelReqVo.getYearMonth())) {
                            beginDate = DateUtil.date_sdf.parse(sfaTravelReqVo.getYearMonth() + "-01");
                        }
                        if (endDate.getTime() > new Date().getTime()) {
                            endDate = new Date();
                        }
                        if ((datsInt = DateUtil.getDayCount((Date)beginDate, (Date)endDate)) < 0) {
                            datsInt = -1 * datsInt;
                        }
                        travelDays = travelDays + datsInt;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                respVo.setTravelDays(travelDays);
            }
            SfaWorkSummaryReqVo sfaWorkSummaryReqVo = new SfaWorkSummaryReqVo();
            sfaWorkSummaryReqVo.setUserCode(reqVo.getUserName());
            sfaWorkSummaryReqVo.setYearMonth(reqVo.getYearMonth());
            sfaWorkSummaryReqVo.setSummaryType(SfaWorkSummaryEnum.LectureType.DAILY.getVal());
            Integer dailyDays = this.sfaWorkSummaryService.getSfaWorkSummaryPrimaryByCount(sfaWorkSummaryReqVo);
            if (null == dailyDays) {
                dailyDays = 0;
            }
            respVo.setDailyDays(dailyDays);
            BigDecimal goToWorkDays = respVo.getGoToWorkDays();
            Integer notDailyDays = Integer.valueOf(goToWorkDays.toString()) - dailyDays;
            respVo.setNotDailyDays(notDailyDays);
        }
        return respVo;
    }
}

