/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.integral.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.integral.mapper.SfaIntegralDetailMapper;
import com.biz.crm.integral.model.SfaIntegralDetailEntity;
import com.biz.crm.integral.model.SfaIntegralRangeEntity;
import com.biz.crm.integral.model.SfaIntegralRuleEntity;
import com.biz.crm.integral.model.SfaIntegralTaskEntity;
import com.biz.crm.integral.service.SfaIntegralDetailService;
import com.biz.crm.integral.service.SfaIntegralRangeService;
import com.biz.crm.integral.service.SfaIntegralRuleService;
import com.biz.crm.integral.service.SfaIntegralTaskService;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralDetailMqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralDetailReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralDetailUserReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralRankAppReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralRankReqVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralDetailRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRankRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralUserRankRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"SfaIntegralDetailServiceExpandImpl"})
public class SfaIntegralDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaIntegralDetailMapper, SfaIntegralDetailEntity>
implements SfaIntegralDetailService {
    private static final Logger log = LoggerFactory.getLogger(SfaIntegralDetailServiceImpl.class);
    @Autowired
    MdmPositionFeign mdmPositionFeign;
    @Autowired
    SfaIntegralRangeService sfaIntegralRangeService;
    @Autowired
    SfaIntegralTaskService sfaIntegralTaskService;
    @Autowired
    SfaIntegralRuleService sfaIntegralRuleService;
    @Autowired
    SfaIntegralDetailMapper sfaIntegralDetailMapper;
    @Autowired
    MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmUserFeign mdmUserFeign;

    @Override
    public PageResult<SfaIntegralDetailRespVo> pageIntegralDetail(SfaIntegralDetailReqVo sfaIntegralDetailReqVo) {
        Page page = new Page((long)sfaIntegralDetailReqVo.getPageNum().intValue(), (long)sfaIntegralDetailReqVo.getPageSize().intValue());
        LambdaQueryWrapper wrapper = this.getWrapper(sfaIntegralDetailReqVo);
        Page detailEntityPage = (Page)this.page((IPage)page, (Wrapper)wrapper);
        List records = detailEntityPage.getRecords();
        List sfaIntegralDetailRespVos = CrmBeanUtil.copyList((List)records, SfaIntegralDetailRespVo.class);
        return PageResult.builder().data(sfaIntegralDetailRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveIntegralDetail(SfaIntegralDetailMqVo reqVo) {
        MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo;
        if (reqVo.getIntegralType() == null) {
            log.info("\u8bf7\u4f20\u5165\u679a\u4e3e\u503c");
        }
        UserRedis user = UserUtils.getUser();
        if (!StringUtils.isEmpty((String)reqVo.getPosCode()) && !ObjectUtils.isEmpty((Object)(mdmPositionUserOrgRespVo = (MdmPositionUserOrgRespVo)ApiResultUtil.objResult((Result)this.mdmPositionFeign.getPositionUserOrgByPositionCode(reqVo.getPosCode()), (boolean)true)))) {
            user.setPoscode(mdmPositionUserOrgRespVo.getPositionCode()).setPosname(mdmPositionUserOrgRespVo.getPositionName()).setOrgcode(mdmPositionUserOrgRespVo.getOrgCode()).setOrgname(mdmPositionUserOrgRespVo.getOrgName()).setRealname(mdmPositionUserOrgRespVo.getFullName());
        }
        List sfaIntegralRangeEntities = Lists.newArrayList();
        Result detail = this.mdmPositionFeign.detail(null, user.getPoscode());
        if (!ObjectUtils.isEmpty((Object)detail)) {
            String positionLevelCode = ((MdmPositionRespVo)detail.getResult()).getPositionLevelCode();
            String orgCode = user.getOrgcode();
            sfaIntegralRangeEntities = this.sfaIntegralRangeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaIntegralRangeEntity.class).eq(SfaIntegralRangeEntity::getCode, (Object)positionLevelCode)).or()).eq(SfaIntegralRangeEntity::getCode, (Object)orgCode));
        }
        if (CollectionUtil.listEmpty((List)sfaIntegralRangeEntities) || sfaIntegralRangeEntities.size() > 2) {
            log.info("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u88ab\u79ef\u5206\u89c4\u5219\u8986\u76d6");
        }
        String integralRuleId = ((SfaIntegralRangeEntity)((Object)sfaIntegralRangeEntities.get(0))).getIntegralRuleId();
        SfaIntegralRuleEntity ruleEntity = (SfaIntegralRuleEntity)((Object)this.sfaIntegralRuleService.getOne((Wrapper)Wrappers.lambdaQuery(SfaIntegralRuleEntity.class).eq(BaseIdEntity::getId, (Object)integralRuleId)));
        SfaIntegralTaskEntity task = (SfaIntegralTaskEntity)((Object)this.sfaIntegralTaskService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaIntegralTaskEntity.class).eq(SfaIntegralTaskEntity::getIntegralRuleId, (Object)integralRuleId)).eq(SfaIntegralTaskEntity::getIntegralTaskType, (Object)reqVo.getIntegralType())));
        if (task == null) {
            log.info("\u6ca1\u6709\u76f8\u5e94\u7684\u8ba1\u7b97\u89c4\u5219\uff0c\u4e0d\u52a0\u79ef\u5206");
        }
        SfaIntegralDetailEntity sfaDetailEntity = this.getSfaDetailEntity(ruleEntity, task, reqVo.getIntegralType(), user, (Result<MdmPositionRespVo>)detail);
        this.save((Object)sfaDetailEntity);
    }

    @Override
    public PageResult<SfaIntegralRankRespVo> pageIntegralRank(SfaIntegralRankReqVo sfaIntegralRankReqVo) {
        Page page = new Page((long)sfaIntegralRankReqVo.getPageNum().intValue(), (long)sfaIntegralRankReqVo.getPageSize().intValue());
        List<SfaIntegralDetailEntity> sfaIntegralDetailEntities = this.sfaIntegralDetailMapper.pageDetailNum(page, sfaIntegralRankReqVo);
        List sfaIntegralRankRespVos = CrmBeanUtil.copyList(sfaIntegralDetailEntities, SfaIntegralRankRespVo.class);
        int rank = 0;
        for (SfaIntegralRankRespVo sfaIntegralRankRespVo : sfaIntegralRankRespVos) {
            MdmPositionRespVo result = (MdmPositionRespVo)this.mdmPositionFeign.getPrimaryPositionByUserName(sfaIntegralRankRespVo.getUserName()).getResult();
            if (ObjectUtils.isEmpty((Object)result)) continue;
            sfaIntegralRankRespVo.setFullName(result.getFullName());
            sfaIntegralRankRespVo.setPosName(result.getPositionName());
            Result detail = this.mdmPositionFeign.detail(null, result.getPositionCode());
            sfaIntegralRankRespVo.setOrgName(result.getOrgName());
            sfaIntegralRankRespVo.setPosLevelName(((MdmPositionRespVo)detail.getResult()).getPositionLevelName());
            sfaIntegralRankRespVo.setRank(Integer.valueOf(++rank));
        }
        return PageResult.builder().data(sfaIntegralRankRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaIntegralDetailRespVo> pageDetailByLoginUser(SfaIntegralDetailUserReqVo sfaIntegralDetailUserReqVo) {
        if (StringUtils.isEmpty((String)sfaIntegralDetailUserReqVo.getUserName())) {
            UserRedis user = UserUtils.getUser();
            sfaIntegralDetailUserReqVo.setUserName(user.getUsername());
        }
        Page page = new Page((long)sfaIntegralDetailUserReqVo.getPageNum().intValue(), (long)sfaIntegralDetailUserReqVo.getPageSize().intValue());
        Page integralDetailEntityPage = (Page)this.page((IPage)page, (Wrapper)Wrappers.lambdaQuery(SfaIntegralDetailEntity.class).eq(SfaIntegralDetailEntity::getUserName, (Object)sfaIntegralDetailUserReqVo.getUserName()));
        List detailEntityPageRecords = integralDetailEntityPage.getRecords();
        List sfaIntegralDetailRespVos = CrmBeanUtil.copyList((List)detailEntityPageRecords, SfaIntegralDetailRespVo.class);
        return PageResult.builder().data(sfaIntegralDetailRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaIntegralUserRankRespVo countIntegralNumByUserNameRedis(String userName) {
        if (StringUtils.isEmpty((String)userName)) {
            UserRedis user = UserUtils.getUser();
            userName = user.getUsername();
        }
        List<SfaIntegralUserRankRespVo> sfaIntegralUserRankRespVos = this.sfaIntegralDetailMapper.listIntegralRank();
        String finalUserName = userName;
        List collect = sfaIntegralUserRankRespVos.stream().filter(data -> finalUserName.equals(data.getUserName())).collect(Collectors.toList());
        if (CollectionUtil.listEmpty(collect)) {
            return new SfaIntegralUserRankRespVo().setUserName(userName).setIntegralNum("0").setRank(Integer.valueOf(0));
        }
        return (SfaIntegralUserRankRespVo)collect.get(0);
    }

    @Override
    public PageResult<SfaIntegralRankRespVo> pageIntegralRankToApp(SfaIntegralRankAppReqVo sfaIntegralRankAppReqVo) {
        String userOrgCode = UserUtils.getUser().getOrgcode();
        SfaIntegralRankReqVo sfaIntegralRankReqVo = (SfaIntegralRankReqVo)CrmBeanUtil.copy((Object)sfaIntegralRankAppReqVo, SfaIntegralRankReqVo.class);
        if (StringUtils.isNotEmpty((String)sfaIntegralRankAppReqVo.getOrgRange())) {
            sfaIntegralRankReqVo = this.getSearchVo(userOrgCode, sfaIntegralRankReqVo, sfaIntegralRankAppReqVo.getOrgRange());
        }
        return this.pageIntegralRank(sfaIntegralRankReqVo);
    }

    private SfaIntegralRankReqVo getSearchVo(String userOrgCode, SfaIntegralRankReqVo sfaIntegralRankReqVo, String orgRange) {
        if (IntegralEnum.orgSearchRange.NOW_ORG.getDes().equals(orgRange)) {
            ArrayList<String> orgCodeList = new ArrayList<String>();
            orgCodeList.add(userOrgCode);
            sfaIntegralRankReqVo.setOrgCodeList(orgCodeList);
        }
        if (IntegralEnum.orgSearchRange.ALL_ORG.getDes().equals(orgRange)) {
            MdmOrgRespVo topParentOrgByCode = OrgUtil.getTopParentOrgByCode((String)userOrgCode);
            List childrenOrgCodeListIncludeSelf = OrgUtil.getChildrenOrgCodeListIncludeSelf((String)topParentOrgByCode.getOrgCode());
            sfaIntegralRankReqVo.setOrgCodeList(childrenOrgCodeListIncludeSelf);
        }
        if (IntegralEnum.orgSearchRange.AFTER_ORG.getDes().equals(orgRange)) {
            Result result = this.mdmOrgFeign.findAllChildrenOrgList(new MdmOrgReqVo().setOrgCode(userOrgCode));
            List allChildrenOrgList = ((List)result.getResult()).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            sfaIntegralRankReqVo.setOrgCodeList(allChildrenOrgList);
        }
        return sfaIntegralRankReqVo;
    }

    private SfaIntegralDetailEntity getSfaDetailEntity(SfaIntegralRuleEntity ruleEntity, SfaIntegralTaskEntity task, String integralEnum, UserRedis user, Result<MdmPositionRespVo> detail) {
        SfaIntegralDetailEntity sfaIntegralDetailEntity = new SfaIntegralDetailEntity();
        sfaIntegralDetailEntity.setIntegralNum(String.valueOf(task.getIntegralTaskReward()));
        sfaIntegralDetailEntity.setIntegralRuleId(ruleEntity.getId());
        sfaIntegralDetailEntity.setIntegralTaskType(integralEnum);
        sfaIntegralDetailEntity.setIntegralRuleName(ruleEntity.getIntegralRuleName());
        sfaIntegralDetailEntity.setPosName(user.getPosname());
        sfaIntegralDetailEntity.setPosCode(((MdmPositionRespVo)detail.getResult()).getPositionLevelCode());
        sfaIntegralDetailEntity.setUserName(((MdmPositionRespVo)detail.getResult()).getPositionLevelName());
        sfaIntegralDetailEntity.setFullName(user.getRealname());
        sfaIntegralDetailEntity.setOrgCode(user.getOrgcode());
        sfaIntegralDetailEntity.setOrgName(user.getOrgname());
        sfaIntegralDetailEntity.setIntegralRuleCode(ruleEntity.getIntegralRuleCode());
        return sfaIntegralDetailEntity;
    }

    private LambdaQueryWrapper getWrapper(SfaIntegralDetailReqVo sfaIntegralDetailReqVo) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery(SfaIntegralDetailEntity.class);
        if (StringUtils.isNotEmpty((String)sfaIntegralDetailReqVo.getFullName())) {
            lambdaQueryWrapper.like(SfaIntegralDetailEntity::getFullName, (Object)sfaIntegralDetailReqVo.getFullName());
        }
        if (StringUtils.isNotEmpty((String)sfaIntegralDetailReqVo.getIntegralRuleId())) {
            lambdaQueryWrapper.like(SfaIntegralDetailEntity::getIntegralRuleId, (Object)sfaIntegralDetailReqVo.getIntegralRuleId());
        }
        if (StringUtils.isNotEmpty((String)sfaIntegralDetailReqVo.getIntegralRuleName())) {
            lambdaQueryWrapper.like(SfaIntegralDetailEntity::getIntegralRuleName, (Object)sfaIntegralDetailReqVo.getIntegralRuleName());
        }
        if (StringUtils.isNotEmpty((String)sfaIntegralDetailReqVo.getFullName())) {
            lambdaQueryWrapper.like(SfaIntegralDetailEntity::getFullName, (Object)sfaIntegralDetailReqVo.getFullName());
        }
        if (StringUtils.isNotEmpty((String)sfaIntegralDetailReqVo.getPosName())) {
            lambdaQueryWrapper.like(SfaIntegralDetailEntity::getPosName, (Object)sfaIntegralDetailReqVo.getPosName());
        }
        return lambdaQueryWrapper;
    }
}

