/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.visitstep.model.SfaVisitStepActivityCostExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityDisplayExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityDisplayExecutionEsDataRepositories;
import com.biz.crm.visitstep.req.GetCompleteActivityPageReq;
import com.biz.crm.visitstep.req.GetCompleteActivityReq;
import com.biz.crm.visitstep.req.GetCompleteActivityTablePageReq;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreCostActivityTableRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreDisplayActivityTableRespVo;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class SfaVisitStepActivityExecutionServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepActivityExecutionServiceEsImpl.class);
    @Resource
    private SfaVisitStepActivityDisplayExecutionEsDataRepositories sfaVisitStepActivityDisplayExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;

    public PageResult<SfaVisitStepActivityExecutionRespVo> getCompleteActivityPage(GetCompleteActivityPageReq req) {
        if (SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal().equals(req.getActivityType())) {
            Page list = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search((SearchQuery)req.buildQuery());
            return PageResult.builder().data(CrmBeanUtil.copyList((List)list.getContent(), SfaVisitStepActivityExecutionRespVo.class)).count(Long.valueOf(list.getTotalElements())).build();
        }
        Page list = this.sfaVisitStepActivityCostExecutionEsDataRepositories.search((SearchQuery)req.buildQuery());
        return PageResult.builder().data(CrmBeanUtil.copyList((List)list.getContent(), SfaVisitStepActivityExecutionRespVo.class)).count(Long.valueOf(list.getTotalElements())).build();
    }

    public List<SfaVisitStepActivityCostExecutionEsData> getCompleteCostActivityList(GetCompleteActivityReq req) {
        Iterable list = this.sfaVisitStepActivityCostExecutionEsDataRepositories.search((QueryBuilder)req.buildQuery());
        return Lists.newArrayList((Iterable)list);
    }

    public Set<String> getCompleteCostActivityIdsBeforeDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setEndActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "23:59:59");
        return this.getCompleteCostActivityList(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }

    public Set<String> getCompleteCostActivityIdsAfterDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setStartActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "00:00:00");
        return this.getCompleteCostActivityList(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }

    public List<SfaVisitStepActivityDisplayExecutionEsData> getCompleteDisplayActivityList(GetCompleteActivityReq req) {
        Iterable list = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search((QueryBuilder)req.buildQuery());
        return Lists.newArrayList((Iterable)list);
    }

    public Set<String> getCompleteDisplayActivityIdsBeforeDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setEndActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "23:59:59");
        return this.getCompleteDisplayActivityList(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }

    public SfaVisitStepActivityDisplayExecutionEsData getLastActivityTimeRecord(String stepCode, String clientCode, LocalDateTime activityTime, String currentId) {
        if (StringUtils.isBlank((CharSequence)stepCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        if (StringUtils.isBlank((CharSequence)clientCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u7f16\u7801");
        }
        if (null == activityTime) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6267\u884c\u65f6\u95f4");
        }
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"stepCode.keyword", (String)stepCode));
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode.keyword", (String)clientCode));
        builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"activityTime").lte((Object)activityTime.format(CrmDateUtils.yyyyMMddHHmmss)));
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)0, (int)2));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"activityTime").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        List list = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search((SearchQuery)query).getContent();
        if (list.size() > 0) {
            SfaVisitStepActivityDisplayExecutionEsData data;
            SfaVisitStepActivityDisplayExecutionEsData dataCurrent = (SfaVisitStepActivityDisplayExecutionEsData)list.get(0);
            SfaVisitStepActivityDisplayExecutionEsData sfaVisitStepActivityDisplayExecutionEsData = data = list.size() > 1 ? (SfaVisitStepActivityDisplayExecutionEsData)list.get(1) : null;
            if (dataCurrent.getId().equals(currentId)) {
                return data;
            }
            return dataCurrent;
        }
        return null;
    }

    public Set<String> getCompleteDisplayActivityIdsAfterDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setStartActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "00:00:00");
        return this.getCompleteDisplayActivityList(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }

    public PageResult<SfaVisitStepStoreCostActivityTableRespVo> findVisitStepCostActivityExecutionEsList(GetCompleteActivityTablePageReq req) {
        Page costList = this.sfaVisitStepActivityCostExecutionEsDataRepositories.search((SearchQuery)req.buildQuery());
        List result = CrmBeanUtil.copyList((List)costList.getContent(), SfaVisitStepStoreCostActivityTableRespVo.class);
        return PageResult.builder().data(result).count(Long.valueOf(costList.getTotalElements())).build();
    }

    public SfaVisitStepActivityCostExecutionEsData findVisitStepCostActivityExecutionDetailEs(String id) {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)id));
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        Page list = this.sfaVisitStepActivityCostExecutionEsDataRepositories.search((SearchQuery)query);
        if (CollectionUtil.listEmpty((List)list.getContent())) {
            return new SfaVisitStepActivityCostExecutionEsData();
        }
        return (SfaVisitStepActivityCostExecutionEsData)list.getContent().get(0);
    }

    public PageResult<SfaVisitStepStoreDisplayActivityTableRespVo> findVisitStepDisplayActivityExecutionEsList(GetCompleteActivityTablePageReq req) {
        Page displayList = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search((SearchQuery)req.buildQuery());
        List result = CrmBeanUtil.copyList((List)displayList.getContent(), SfaVisitStepStoreDisplayActivityTableRespVo.class);
        return PageResult.builder().data(result).count(Long.valueOf(displayList.getTotalElements())).build();
    }

    public SfaVisitStepActivityDisplayExecutionEsData findVisitStepDisplayActivityExecutionDetailEs(String id) {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)id));
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        Page list = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search((SearchQuery)query);
        if (CollectionUtil.listEmpty((List)list.getContent())) {
            return new SfaVisitStepActivityDisplayExecutionEsData();
        }
        return (SfaVisitStepActivityDisplayExecutionEsData)list.getContent().get(0);
    }
}

