/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaExceptionReportDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplyDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplySummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaMonthSignReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignAddRecordSearchReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeSummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaExceptionReportDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplyDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplySummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaSignAddRecordInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaSignDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeSummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkOvertimeRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksign.req.SfaSignRecordBatchReqVo;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaSignFormsController"})
@Api(tags={"\u8003\u52e4\u7ba1\u7406-\u62a5\u8868\u63a5\u53e3 "})
public class SfaSignFormsController {
    private static final Logger log = LoggerFactory.getLogger(SfaSignFormsController.class);
    @Autowired
    private ISfaSignFormsService service;
    @Resource
    private ISfaWorkSignRecordService sfaWorkSignRecordService;

    @ApiOperation(value="\u8003\u52e4\u5f02\u5e38\u4fe1\u606f\u6279\u91cf\u4fee\u6539\u2014\u2014WEB")
    @PostMapping(value={"/updateBatchSignList"})
    @CrmLog
    public Result updateBatchSignList(@RequestBody SfaSignRecordBatchReqVo sfaSignRecordBatchReqVo) {
        this.sfaWorkSignRecordService.updateBatchList(sfaSignRecordBatchReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u4eba\u5458\u8d26\u53f7\u3001\u804c\u4f4d\u3001\u7ec4\u7ec7\u3001\u6253\u5361\u65e5\u671f\u83b7\u53d6\u589e\u52a0\u8003\u52e4\u65f6\u7684\u76f8\u5173\u4fe1\u606f\u2014\u2014WEB")
    @PostMapping(value={"/getSignAddRecordInfo"})
    @CrmLog
    public Result<SfaSignAddRecordInfoRespVo> getSignAddRecordInfo(@RequestBody SfaSignAddRecordSearchReqVo sfaSignAddRecordSearchReqVo) {
        return Result.ok((Object)this.service.getSignAddRecordInfo(sfaSignAddRecordSearchReqVo));
    }

    @ApiOperation(value="\u65b0\u589e\u8003\u52e4\u8bb0\u5f55\u2014\u2014\u65b0\u589e\u6253\u5361\u2014\u2014WEB")
    @PostMapping(value={"/updateSignRecord"})
    @CrmLog
    public Result updateSignRecord(@RequestBody SfaSignRecordReqVo sfaSignRecordReqVo) {
        this.sfaWorkSignRecordService.updateSignRecord(sfaSignRecordReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u6253\u5361\u7c7b\u578b\u5217\u8868")
    @PostMapping(value={"/getWorkSignType"})
    @CrmLog
    public Result<List<Map<String, String>>> getWorkSignType() {
        return Result.ok(this.service.getWorkSignType());
    }

    @ApiOperation(value="\u8003\u52e4\u660e\u7ec6\u62a5\u8868")
    @PostMapping(value={"/signDetail"})
    @CrmLog
    public Result<PageResult<SfaSignDetailRespVo>> signDetail(@RequestBody SfaSignDetailReqVo reqVo) {
        return Result.ok(this.service.signDetail(reqVo));
    }

    @ApiOperation(value="\u8003\u52e4\u660e\u7ec6\u62a5\u8868\u8be6\u60c5\u2014\u2014web\u7528")
    @GetMapping(value={"/getSignInfo"})
    @CrmLog
    public Result<SfaSignDetailRespVo> getSignInfo(@RequestParam(value="id", required=false) String id, @RequestParam(value="ruleType", required=false) String ruleType) {
        return Result.ok((Object)this.service.getSignInfo(id, ruleType));
    }

    @ApiOperation(value="\u6708\u5ea6\u8003\u52e4\u62a5\u8868")
    @PostMapping(value={"/monthSign"})
    @CrmLog
    public Result<PageResult<SfaMonthSignRespVo>> monthSign(@RequestBody SfaMonthSignReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getYearMonth())) {
            throw new BusinessException("\u62a5\u8868\u5e74\u6708\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.ok(this.service.monthSign(reqVo));
    }

    @ApiOperation(value="\u8bf7\u5047\u7533\u8bf7\u660e\u7ec6")
    @PostMapping(value={"/leaveApplyDetail"})
    @CrmLog
    public Result<PageResult<SfaLeaveApplyDetailRespVo>> leaveApplyDetail(@RequestBody SfaLeaveApplyDetailReqVo reqVo) {
        return Result.ok(this.service.leaveApplyDetail(reqVo));
    }

    @ApiOperation(value="\u8bf7\u5047\u7533\u8bf7\u6c47\u603b")
    @PostMapping(value={"/leaveApplySummary"})
    @CrmLog
    public Result<PageResult<SfaLeaveApplySummaryRespVo>> leaveApplySummary(@RequestBody SfaLeaveApplySummaryReqVo reqVo) {
        return Result.ok(this.service.leaveApplySummary(reqVo));
    }

    @ApiOperation(value="\u5de5\u4f5c\u65e5\u8c03\u6574\u7533\u8bf7\u660e\u7ec6")
    @PostMapping(value={"/workOvertimeDetail"})
    @CrmLog
    public Result<PageResult<SfaWorkOvertimeDetailRespVo>> workOvertimeDetail(@RequestBody SfaWorkOvertimeDetailReqVo reqVo) {
        return Result.ok(this.service.workOvertimeDetail(reqVo));
    }

    @ApiOperation(value="\u5de5\u4f5c\u65e5\u8c03\u6574\u7533\u8bf7\u6c47\u603b")
    @PostMapping(value={"/workOvertimeSummary"})
    @CrmLog
    public Result<PageResult<SfaWorkOvertimeSummaryRespVo>> workOvertimeSummary(@RequestBody SfaWorkOvertimeSummaryReqVo reqVo) {
        return Result.ok(this.service.workOvertimeSummary(reqVo));
    }

    @ApiOperation(value="\u5f02\u5e38\u62a5\u5907\u7533\u8bf7\u660e\u7ec6")
    @PostMapping(value={"/exceptionReportDetail"})
    @CrmLog
    public Result<PageResult<SfaExceptionReportDetailRespVo>> exceptionReportDetail(@RequestBody SfaExceptionReportDetailReqVo reqVo) {
        return Result.ok(this.service.exceptionReportDetail(reqVo));
    }

    @ApiOperation(value="\u6839\u636e\u5ba1\u6838\u4efb\u52a1id\u67e5\u8be2\u5de5\u4f5c\u65e5\u8c03\u6574\u660e\u7ec6")
    @PostMapping(value={"/queryOvertime"})
    @CrmLog
    public Result<SfaWorkOvertimeRespVo> queryOvertime(@RequestBody String id) {
        return Result.ok((Object)this.service.queryOvertiem(id));
    }

    @ApiOperation(value="\u51fa\u5dee\u7533\u8bf7\u660e\u7ec6")
    @PostMapping(value={"/travelDetail"})
    @CrmLog
    public Result<PageResult<SfaTravelRespVo>> travelDetail(@RequestBody SfaTravelReqVo reqVo) {
        return Result.ok(this.service.travelDetail(reqVo));
    }

    @ApiOperation(value="\u6839\u636e\u5ba1\u6838\u4efb\u52a1id\u67e5\u8be2\u8bf7\u5047\u660e\u7ec6")
    @PostMapping(value={"/queryleave"})
    @CrmLog
    public Result<SfaLeaveRespVo> queryleave(@RequestBody String id) {
        return Result.ok((Object)this.service.queryleave(id));
    }

    @ApiOperation(value="\u6839\u636e\u5ba1\u6838\u4efb\u52a1id\u67e5\u8be2\u5f02\u5e38\u62a5\u5907\u660e\u7ec6")
    @PostMapping(value={"/queryException"})
    @CrmLog
    public Result<SfaExceptionReportDetailRespVo> queryException(@RequestBody String id) {
        return Result.ok((Object)this.service.queryException(id));
    }

    @ApiOperation(value="\u6839\u636e\u5ba1\u6838\u4efb\u52a1id\u67e5\u8be2\u9500\u5047\u660e\u7ec6")
    @PostMapping(value={"/queryLeaveCancel"})
    @CrmLog
    public Result<SfaLeaveCancelInfoRespVo> queryLeaveCancel(@RequestBody String id) {
        return Result.ok((Object)this.service.queryLeaveCancel(id));
    }

    @ApiOperation(value="\u6839\u636e\u5ba1\u6838\u4eba\u4efb\u52a1id\u67e5\u8be2\u51fa\u5dee\u660e\u7ec6")
    @PostMapping(value={"/queryTravel"})
    @CrmLog
    public Result<SfaTravelRespVo> queryTravel(@RequestBody String id) {
        return Result.ok((Object)this.service.queryTravel(id));
    }

    @ApiOperation(value="\u4e2a\u4eba\u6708\u5ea6\u8003\u52e4\u62a5\u8868(\u9ed8\u8ba4\u5f53\u524d\u4eba\u5458,\u5f53\u6708)")
    @PostMapping(value={"/appUserByMonthSign"})
    @CrmLog
    public Result<SfaMonthSignRespVo> appUserByMonthSign(@RequestBody SfaMonthSignReqVo reqVo) {
        return Result.ok((Object)this.service.appUserByMonthSign(reqVo));
    }
}

