/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstepdetail.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.component.impl.StockInventoryVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepInfoDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.repositories.SfaVisitStepStockInventoryEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstepdetail.mapper.SfaVisitStepStockInventoryMapper;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockDetailEntity;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEsData;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryRedisData;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockDetailService;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockInventoryService;
import com.biz.crm.visitstepdetail.service.impl.SfaVisitStepStockInventoryServiceEsImpl;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepStockInventoryServiceExpandImpl"})
@Transactional
public class SfaVisitStepStockInventoryServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepStockInventoryMapper, SfaVisitStepStockInventoryEntity>
implements ISfaVisitStepStockInventoryService,
VisitDataDurabilityService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepStockInventoryServiceImpl.class);
    @Resource
    private SfaVisitStepStockInventoryEsDataRepositories sfaVisitStepStockInventoryEsDataRepositories;
    @Resource
    private SfaVisitStepStockInventoryServiceEsImpl sfaVisitStepStockInventoryServiceEsImpl;
    @Resource
    private ISfaVisitStepStockDetailService sfaVisitStepStockDetailService;
    @Resource
    private StockInventoryVisitStepExecutor stockInventoryVisitStepExecutor;

    @Override
    @Transactional
    public List<? extends VisitStepListener.VisitStepListenerCommittedData> dataDurability(List<? extends VisitStepListener.VisitStepListenerCommittedData> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
        if (CollectionUtils.isEmpty(baseEntity)) {
            return Lists.newArrayList();
        }
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData)baseEntity.get(0);
        baseEntity = Lists.newArrayList((Object[])new SfaVisitStepStockInventoryRedisData[]{this.save(redisData)});
        this.doTransToEs(redisData, fromRespVo);
        return baseEntity;
    }

    @Override
    @Transactional
    public SfaVisitStepStockInventoryRedisData save(SfaVisitStepStockInventoryRedisData redisData) {
        redisData.setId(redisData.getVisitPlanInfoId());
        this.saveOrUpdate(redisData);
        this.sfaVisitStepStockDetailService.remove((Wrapper)Wrappers.lambdaQuery(SfaVisitStepStockDetailEntity.class).eq(SfaVisitStepStockDetailEntity::getStockInventoryId, (Object)redisData.getId()));
        List<StockInventoryStepExecuteData.StockDetailReqVo> colletItems = redisData.getVisitStepStockList();
        if (!CollectionUtils.isEmpty(colletItems)) {
            List itemEntities = colletItems.stream().map(v -> {
                SfaVisitStepStockDetailEntity copy = (SfaVisitStepStockDetailEntity)((Object)((Object)CrmBeanUtil.copy((Object)v, SfaVisitStepStockDetailEntity.class)));
                copy.setStockInventoryId(redisData.getId());
                return copy;
            }).collect(Collectors.toList());
            this.sfaVisitStepStockDetailService.saveOrUpdateBatch(itemEntities);
        }
        return redisData;
    }

    protected void doTransToEs(SfaVisitStepStockInventoryRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepStockInventoryEsData oldData;
        SfaVisitStepStockInventoryEsData dataResp = (SfaVisitStepStockInventoryEsData)CrmBeanUtil.copy((Object)redisData, SfaVisitStepStockInventoryEsData.class);
        dataResp.setVisitStepStockList(redisData.getVisitStepStockList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        dataResp.setLastTime(this.lastTime(fromRespVo.getStepCode(), dataResp.getClientCode(), dataResp.getId()));
        if (StringUtils.isNotBlank((CharSequence)dataResp.getVisitPlanInfoId()) && null != (oldData = this.sfaVisitStepStockInventoryEsDataRepositories.findByVisitPlanInfoIdAndStepCode(dataResp.getVisitPlanInfoId(), dataResp.getStepCode()))) {
            dataResp.setId(oldData.getId());
        }
        this.sfaVisitStepStockInventoryEsDataRepositories.save(dataResp);
    }

    private String lastTime(String stepCode, String clientCode, String currentId) {
        SfaVisitStepStockInventoryEsData esData = this.sfaVisitStepStockInventoryServiceEsImpl.getLastTimeRecord(stepCode, clientCode, LocalDateTime.now(), currentId);
        if (null == esData) {
            return null;
        }
        return esData.getStockTime();
    }

    @Override
    public StockInventoryStepInfoDataResp loadInfoPage(ExecutorWorkbenchLoadReq loadParam) {
        StockInventoryStepExecuteDataResp tempData = (StockInventoryStepExecuteDataResp)this.stockInventoryVisitStepExecutor.loadEditPageForWorkbench(loadParam);
        StockInventoryStepInfoDataResp dataResp = (StockInventoryStepInfoDataResp)((Object)CrmBeanUtil.copy((Object)tempData, StockInventoryStepInfoDataResp.class));
        dataResp.stockDetailGroupAndTotalNum(tempData.getVisitStepStockList());
        dataResp.setSfaVisitStepFrom(tempData.getSfaVisitStepFrom());
        return dataResp;
    }
}

