/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.integral.controller;

import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralDetailMqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfaIntegralSaveUtil {
    private static final Logger log = LoggerFactory.getLogger(SfaIntegralSaveUtil.class);
    private static RocketMQProducer rocketMQProducer = (RocketMQProducer)SpringApplicationContextUtil.getApplicationContext().getBean(RocketMQProducer.class);

    public static void saveIntegralDetail(SfaIntegralDetailMqVo reqVo) {
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        if (StringUtils.isNotEmpty((String)reqVo.getPosCode())) {
            rocketMQMessageBody.setTag("INTEGRAL_DETAIL_TAG");
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)reqVo));
            rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
    }

    public static void saveIntegralDetail(String type, String positionCode) {
        if (StringUtils.isNotEmpty((String)positionCode) && StringUtils.isNotEmpty((String)type)) {
            SfaIntegralDetailMqVo detailMqVo = new SfaIntegralDetailMqVo();
            detailMqVo.setIntegralType(type).setPosCode(positionCode);
            SfaIntegralSaveUtil.saveIntegralDetail(detailMqVo);
        }
    }

    public static void saveIntegralDetail(List<? extends VisitStepListener.VisitStepListenerCommittedData> entities) {
        List sfaIntegralDetailMqVos = CrmBeanUtil.copyList(entities, SfaIntegralDetailMqVo.class);
        sfaIntegralDetailMqVos.forEach(o -> {
            if (IntegralEnum.taskType.GETMAP.containsKey(o.getStepCode())) {
                SfaIntegralSaveUtil.saveIntegralDetail(o.getStepCode(), o.getPosCode());
            }
        });
    }
}

