/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaVisitRoleEnum;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepStoreCheckRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstep.repositories.SfaVisitStepStoreCheckEsDataRepositories;
import com.biz.crm.visitstep.req.GetStoreCheckPageReq;
import com.biz.crm.visitstep.req.GetStoreCheckReq;
import com.biz.crm.visitstep.resp.SfaVisitStepStoreCheckTableRespVo;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SfaVisitStepStoreCheckServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepStoreCheckServiceEsImpl.class);
    @Resource
    private SfaVisitStepStoreCheckEsDataRepositories sfaVisitStepStoreCheckEsDataRepositories;

    public PageResult<SfaVisitStepStoreCheckRespVo> getWorkbenchStoreCheckPage(GetStoreCheckPageReq req) {
        Page list = this.sfaVisitStepStoreCheckEsDataRepositories.search((SearchQuery)req.buildQuery());
        return PageResult.builder().data(CrmBeanUtil.copyList((List)list.getContent(), SfaVisitStepStoreCheckRespVo.class)).count(Long.valueOf(list.getTotalElements())).build();
    }

    @EsDataPermission(userName="userName.keyword", position="posCode.keyword", org="orgCode.keyword", customer="clientCode.keyword")
    public PageResult<SfaVisitStepStoreCheckTableRespVo> findStoreCheckReportEsList(GetStoreCheckReq req) {
        Page list = this.sfaVisitStepStoreCheckEsDataRepositories.search((SearchQuery)req.buildQuery());
        List respVos = CrmBeanUtil.copyList((List)list.getContent(), SfaVisitStepStoreCheckTableRespVo.class);
        respVos.forEach(o -> o.setClientTypeName(Objects.requireNonNull(SfaVisitRoleEnum.getSfaVisitRole(o.getClientType())).getDesc()));
        return PageResult.builder().data(respVos).count(Long.valueOf(list.getTotalElements())).build();
    }

    public SfaVisitStepStoreCheckRespVo findStoreCheckReportDetailEs(String id) {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)id));
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        Page list = this.sfaVisitStepStoreCheckEsDataRepositories.search((SearchQuery)query);
        List result = CrmBeanUtil.copyList((List)list.getContent(), SfaVisitStepStoreCheckRespVo.class);
        if (ObjectUtils.isEmpty((Object)result)) {
            return new SfaVisitStepStoreCheckRespVo();
        }
        ((SfaVisitStepStoreCheckRespVo)result.get(0)).setClientTypeName(Objects.requireNonNull(SfaVisitRoleEnum.getSfaVisitRole(((SfaVisitStepStoreCheckRespVo)result.get(0)).getClientType())).getDesc());
        return (SfaVisitStepStoreCheckRespVo)result.get(0);
    }
}

