/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaVisitRoleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRangeRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.biz.crm.visitinfo.service.impl.VisitPlanInfoHelper;
import com.biz.crm.visitnote.mapper.SfaVisitGroupMapper;
import com.biz.crm.visitnote.mapper.SfaVisitPlanMapper;
import com.biz.crm.visitnote.mapper.SfaVisitPlanRangeMapper;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.ISfaVisitPlanRangeService;
import com.biz.crm.visitnote.service.ISfaVisitPlanService;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"sfaVisitPlanServiceExpandImpl"})
public class SfaVisitPlanServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitPlanMapper, SfaVisitPlanEntity>
implements ISfaVisitPlanService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitPlanServiceImpl.class);
    @Resource
    private SfaVisitPlanMapper sfaVisitPlanMapper;
    @Resource
    private SfaVisitPlanRangeMapper sfaVisitPlanRangeMapper;
    @Resource
    private ISfaVisitPlanRangeService iSfaVisitPlanRangeService;
    @Resource
    private RedisService redisService;
    @Resource
    private ISfaVisitPlanInfoService iSfaVisitPlanInfoService;
    @Resource
    private SfaVisitGroupMapper sfaVisitGroupMapper;
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Resource
    private Map<String, SfaVisitPlanResolver> sfaVisitPlanResolverMap;
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;
    @Resource
    private VisitPlanInfoHelper visitPlanInfoHelper;

    @Override
    public PageResult<SfaVisitPlanRespVo> findList(SfaVisitPlanReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitPlanRespVo> list = this.sfaVisitPlanMapper.findList((Page<SfaVisitPlanRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List visitPlanCodes = list.stream().map(SfaVisitPlanRespVo::getVisitPlanCode).collect(Collectors.toList());
            SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
            sfaVisitPlanRangeReqVo.setVisitPlanCodes(visitPlanCodes);
            sfaVisitPlanRangeReqVo.setPageSize(Integer.valueOf(-1));
            List sfaVisitPlanRangeRespVos = this.iSfaVisitPlanRangeService.findList(sfaVisitPlanRangeReqVo).getData();
            Map<String, List<SfaVisitPlanRangeRespVo>> readRespMap = sfaVisitPlanRangeRespVos.stream().collect(Collectors.groupingBy(SfaVisitPlanRangeRespVo::getVisitPlanCode));
            for (SfaVisitPlanRespVo sfaVisitPlanRespVo : list) {
                sfaVisitPlanRespVo.setEnableStatusName(CrmEnableStatusEnum.getDesc((String)sfaVisitPlanRespVo.getEnableStatus()));
                List<SfaVisitPlanRangeRespVo> visitPlanRangeRespVos = readRespMap.get(sfaVisitPlanRespVo.getVisitPlanCode());
                if (visitPlanRangeRespVos == null || visitPlanRangeRespVos.size() <= 0) continue;
                StringBuffer groupNameBuffer = new StringBuffer();
                StringBuffer groupIdBuffer = new StringBuffer();
                for (SfaVisitPlanRangeRespVo visitPlanRangeRespVo : visitPlanRangeRespVos) {
                    if (groupNameBuffer.length() > 0) {
                        groupNameBuffer.append(",");
                    }
                    if (StringUtils.isNotEmpty((String)visitPlanRangeRespVo.getVisitGroupName())) {
                        groupNameBuffer.append(visitPlanRangeRespVo.getVisitGroupName());
                    }
                    if (groupIdBuffer.length() > 0) {
                        groupIdBuffer.append(",");
                    }
                    if (!StringUtils.isNotEmpty((String)visitPlanRangeRespVo.getVisitGroupId())) continue;
                    groupIdBuffer.append(visitPlanRangeRespVo.getVisitGroupId());
                }
                sfaVisitPlanRespVo.setVisitGroupIds(groupIdBuffer.toString());
                sfaVisitPlanRespVo.setVisitGroupNames(groupNameBuffer.toString());
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitPlanRespVo queryDetailById(final String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        SfaVisitPlanReqVo reqVo = new SfaVisitPlanReqVo(){
            {
                this.setId(id);
                this.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
            }
        };
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitPlanRespVo();
        }
        SfaVisitPlanRespVo respVo = (SfaVisitPlanRespVo)list.get(0);
        SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
        sfaVisitPlanRangeReqVo.setVisitPlanCode(respVo.getVisitPlanCode());
        List sfaVisitPlanRangeRespVos = this.iSfaVisitPlanRangeService.findList(sfaVisitPlanRangeReqVo).getData();
        sfaVisitPlanRangeRespVos.forEach(data -> {
            if (respVo.getRouteType().equals(SfaVisitEnum.routeTypeEnum.R1.getVal())) {
                data.setClientRelNum(this.sfaVisitGroupMapper.getCountByVisitGroupId(data.getVisitGroupId()));
            }
        });
        respVo.setSfaVisitPlanRangeRespVos(sfaVisitPlanRangeRespVos);
        return respVo;
    }

    @Override
    public SfaVisitPlanRespVo query(SfaVisitPlanReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            return new SfaVisitPlanRespVo();
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitPlanRespVo();
        }
        SfaVisitPlanRespVo respVo = (SfaVisitPlanRespVo)list.get(0);
        SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
        sfaVisitPlanRangeReqVo.setVisitPlanCode(respVo.getVisitPlanCode());
        List sfaVisitPlanRangeRespVos = this.iSfaVisitPlanRangeService.findList(sfaVisitPlanRangeReqVo).getData();
        sfaVisitPlanRangeRespVos.forEach(data -> {
            if (StringUtils.isNotEmpty((String)data.getClientType())) {
                data.setClientTypeName(SfaVisitRoleEnum.getSfaVisitRole(data.getClientType()).getDesc());
            }
            if (respVo.getRouteType().equals(SfaVisitEnum.routeTypeEnum.R1.getVal())) {
                data.setClientRelNum(this.sfaVisitGroupMapper.getCountByVisitGroupId(data.getVisitGroupId()));
            }
        });
        respVo.setSfaVisitPlanRangeRespVos(sfaVisitPlanRangeRespVos);
        return respVo;
    }

    protected void saveCheck(SfaVisitPlanReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getPlanType(), (String)"\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (!SfaVisitEnum.visitType.GETMAP.containsKey(reqVo.getPlanType())) {
            throw new BusinessException("\u62dc\u8bbf\u7c7b\u578b\u6709\u8bef,\u4e0d\u5b58\u5728\u8be5\u62dc\u8bbf\u7c7b\u578b(\u4e34\u65f6\u62dc\u8bbf\u3001\u8ba1\u5212\u62dc\u8bbf\u3001\u534f\u8bbf)");
        }
        AssertUtils.isNotEmpty((String)reqVo.getRouteType(), (String)"\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a(\u7ebf\u8def\u7ec4\u3001\u7f51\u70b9\u3001\u9891\u7387)");
        if (!SfaVisitEnum.routeTypeEnum.GETMAP.containsKey(reqVo.getRouteType())) {
            throw new BusinessException("\u7ef4\u5ea6\u7c7b\u578b\u6709\u8bef,\u4e0d\u5b58\u5728\u8be5\u7ef4\u5ea6(\u7ebf\u8def\u7ec4\u3001\u7f51\u70b9\u3001\u9891\u7387)");
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitRealName(), (String)"\u8bf7\u9009\u62e9\u4eba\u5458\u59d3\u540d");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosName(), (String)"\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgCode(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgName(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitStartDate(), (String)"\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        LocalDate beginDate = null;
        LocalDate now = LocalDate.now();
        try {
            beginDate = LocalDate.parse(reqVo.getVisitStartDate(), CrmDateUtils.yyyyMMdd);
        }
        catch (Exception e) {
            throw new BusinessException("\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitEndDate(), (String)"\u5faa\u73af\u7ed3\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        LocalDate endDate = null;
        try {
            endDate = LocalDate.parse(reqVo.getVisitEndDate(), CrmDateUtils.yyyyMMdd);
        }
        catch (Exception e) {
            throw new BusinessException("\u5faa\u73af\u7ed3\u7b97\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        if (beginDate.isBefore(now)) {
            throw new BusinessException("\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        if (beginDate.isAfter(endDate)) {
            throw new BusinessException("\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5faa\u73af\u7ed3\u7b97\u65e5\u671f");
        }
        this.checkVisitPlanRange(reqVo, beginDate, endDate);
    }

    protected void checkVisitPlanRange(SfaVisitPlanReqVo reqVo, LocalDate beginDate, LocalDate endDate) {
        if (!CollectionUtil.listNotEmpty((List)reqVo.getSfaVisitPlanRangeReqVos())) {
            throw new BusinessException("\u62dc\u8bbf\u8ba1\u5212\u5236\u5b9a\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int i = 1;
        for (SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo : reqVo.getSfaVisitPlanRangeReqVos()) {
            if (SfaVisitEnum.routeTypeEnum.R1.getVal().equals(reqVo.getRouteType())) {
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getVisitGroupId(), (String)("\u7ebf\u8def\u7ec4" + i + ",\u7ebf\u8def\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getVisitGroupName(), (String)("\u7ebf\u8def\u7ec4" + i + ",\u7ebf\u8def\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            } else {
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientId(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientCode(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientName(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientType(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                if (SfaVisitEnum.routeTypeEnum.R3.getVal().equals(reqVo.getRouteType())) {
                    AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getFirstVisitDate(), (String)("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a"));
                    LocalDate firstVisitDate = null;
                    try {
                        firstVisitDate = LocalDate.parse(sfaVisitPlanRangeReqVo.getFirstVisitDate(), CrmDateUtils.yyyyMMdd);
                    }
                    catch (Exception e) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                    }
                    if (beginDate.isAfter(firstVisitDate) || firstVisitDate.isAfter(endDate)) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u9996\u6b21\u62dc\u8bbf\u65e5\u4e0d\u5728\u5faa\u73af\u65e5\u671f\u5185");
                    }
                    if (null == sfaVisitPlanRangeReqVo.getVisitFrequency()) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    try {
                        String regex = "^[1-9]+[0-9]*$";
                        Pattern p = Pattern.compile(regex);
                        Matcher m = p.matcher(sfaVisitPlanRangeReqVo.getVisitFrequency().toString());
                        if (!m.find()) {
                            System.out.println("falsss");
                            throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570");
                    }
                    if (sfaVisitPlanRangeReqVo.getVisitFrequency() <= 0) {
                        throw new BusinessException("\u7b2c" + i + "\u884c,\u62dc\u8bbf\u9891\u7387\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570");
                    }
                }
            }
            ++i;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitRealName(userRedis.getRealname());
            reqVo.setVisitOrgCode(userRedis.getOrgcode());
            reqVo.setVisitOrgName(userRedis.getOrgname());
            reqVo.setVisitPosCode(userRedis.getPoscode());
            reqVo.setVisitPosName(userRedis.getPosname());
        }
        this.saveCheck(reqVo);
        SfaVisitPlanEntity entity = (SfaVisitPlanEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitPlanEntity.class));
        String code = CodeUtil.getCodeDefault();
        entity.setVisitPlanCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
        this.saveData(reqVo, entity.getVisitPlanCode());
        SfaIntegralSaveUtil.saveIntegralDetail(IntegralEnum.taskType.PLANING_VISIT_PLAN.getValue(), reqVo.getVisitPosCode());
    }

    public void saveData(SfaVisitPlanReqVo reqVo, String visitPlanCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaVisitPlanRangeReqVos())) {
            if (reqVo.getRouteType().equals(SfaVisitEnum.routeTypeEnum.R1.getVal())) {
                Map<String, List<SfaVisitPlanRangeReqVo>> visitPlanRageMap = reqVo.getSfaVisitPlanRangeReqVos().stream().collect(Collectors.groupingBy(SfaVisitPlanRangeReqVo::getVisitGroupId));
                for (Map.Entry<String, List<SfaVisitPlanRangeReqVo>> map : visitPlanRageMap.entrySet()) {
                    if (map.getValue().size() <= 1) continue;
                    throw new BusinessException("\u7ebf\u8def\u7ec4\u6dfb\u52a0\u91cd\u590d");
                }
            }
            List visitPlanRangeEntities = reqVo.getSfaVisitPlanRangeReqVos().stream().map(o -> {
                if (!reqVo.getRouteType().equals(SfaVisitEnum.routeTypeEnum.R1.getVal()) && !SfaVisitEnum.ClientType.GETMAP.containsKey(o.getClientType())) {
                    throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u5ba2\u6237\u7c7b\u578b[" + o.getClientType() + "]");
                }
                SfaVisitPlanRangeEntity receivingEntity = new SfaVisitPlanRangeEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)receivingEntity));
                receivingEntity.setVisitPlanCode(visitPlanCode);
                receivingEntity.setId(null);
                return receivingEntity;
            }).collect(Collectors.toList());
            this.iSfaVisitPlanRangeService.saveBatch(visitPlanRangeEntities);
        }
    }

    @Override
    @Transactional
    public void update(SfaVisitPlanReqVo reqVo) {
        SfaVisitPlanEntity old = this.updateCheck(reqVo);
        SfaVisitPlanEntity updateEntity = new SfaVisitPlanEntity();
        updateEntity.setId(reqVo.getId());
        updateEntity.setVisitEndDate(reqVo.getVisitEndDate());
        updateEntity.setNotWeekSet(reqVo.getNotWeekSet());
        updateEntity.setNotWeekSetDesc(reqVo.getNotWeekSetDesc());
        this.updateById((Object)updateEntity);
        reqVo.setVisitPlanCode(old.getVisitPlanCode());
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, old.getVisitPlanCode());
    }

    protected SfaVisitPlanEntity updateCheck(SfaVisitPlanReqVo reqVo) {
        LocalDate endDateUpdate;
        LocalDate endDate;
        LocalDate beginDate;
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitPlanEntity entity = (SfaVisitPlanEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        String visitEndDate = entity.getVisitEndDate();
        String visitStartDate = entity.getVisitStartDate();
        String visitEndDateUpdate = reqVo.getVisitEndDate();
        try {
            beginDate = LocalDate.parse(visitStartDate, CrmDateUtils.yyyyMMdd);
            endDate = LocalDate.parse(visitEndDate, CrmDateUtils.yyyyMMdd);
            endDateUpdate = LocalDate.parse(visitEndDateUpdate, CrmDateUtils.yyyyMMdd);
        }
        catch (Exception e) {
            throw new BusinessException("\u5faa\u73af\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        if (endDate.compareTo(LocalDate.now()) <= 0) {
            throw new BusinessException("\u5f53\u524d\u65e5\u671f\u5df2\u5927\u4e8e\u6216\u7b49\u4e8e\u539f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f,\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (endDateUpdate.compareTo(LocalDate.now()) < 0) {
            throw new BusinessException("\u4fee\u6539\u540e\u7684\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        this.checkVisitPlanRange(reqVo, beginDate, endDateUpdate);
        return entity;
    }

    @Override
    public void deleteBatch(final List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitPlanReqVo reqVo = new SfaVisitPlanReqVo(){
            {
                this.setIds(ids);
                this.setPageSize(-1);
                this.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
            }
        };
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        for (SfaVisitPlanRespVo data : list) {
            if (data.getEnableStatus().equals(CrmEnableStatusEnum.ENABLE.getCode())) {
                throw new BusinessException("\u542f\u7528\u72b6\u6001\u7684\u62dc\u8bbf\u8ba1\u5212\u89c4\u5219\u4e0d\u80fd\u5220\u9664");
            }
            LocalDate startDate = null;
            LocalDate endDate = null;
            LocalDate now = LocalDate.now();
            LocalDate createDate = LocalDate.parse(data.getCreateDate(), CrmDateUtils.yyyyMMdd);
            try {
                startDate = LocalDate.parse(data.getVisitStartDate(), CrmDateUtils.yyyyMMdd);
                endDate = LocalDate.parse(data.getVisitEndDate(), CrmDateUtils.yyyyMMdd);
            }
            catch (Exception e) {
                throw new BusinessException("\u5220\u9664\u524d\u5faa\u73af\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
            }
            if (startDate.isBefore(now) && endDate.isAfter(now)) {
                throw new BusinessException("\u5df2\u6709\u5386\u53f2\u62dc\u8bbf\u8bb0\u5f55,\u4e0d\u53ef\u5220\u9664");
            }
            if (now.isAfter(endDate)) {
                throw new BusinessException("\u5df2\u5b8c\u6210\u62dc\u8bbf\u8ba1\u5212\u4e0d\u53ef\u5220\u9664");
            }
            if (createDate.isEqual(now)) continue;
            throw new BusinessException("\u4e0d\u53ef\u5220\u9664\u975e\u5f53\u5929\u521b\u5efa\u7684\u62dc\u8bbf\u8ba1\u5212\u89c4\u5219");
        }
        this.sfaVisitPlanMapper.deleteProductsByParams(reqVo);
        List<String> visitPlanCodes = list.stream().map(SfaVisitPlanRespVo::getVisitPlanCode).collect(Collectors.toList());
        reqVo.setVisitPlanCodes(visitPlanCodes);
        this.deleteBatchDate(reqVo);
        this.deleteSfaVisitPlanInfo(visitPlanCodes);
    }

    public void deleteBatchDate(SfaVisitPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitPlanCode()) && CollectionUtil.listEmpty((List)reqVo.getVisitPlanCodes())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitPlanRangeReqVo visitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
        visitPlanRangeReqVo.setVisitPlanCode(reqVo.getVisitPlanCode());
        visitPlanRangeReqVo.setVisitPlanCodes(reqVo.getVisitPlanCodes());
        this.sfaVisitPlanRangeMapper.deleteProductsByParams(visitPlanRangeReqVo);
    }

    public void deleteSfaVisitPlanInfo(List<String> visitPlanCodes) {
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        this.sfaVisitPlanInfoMapper.deleteVisitPlanInfo(visitPlanCodes, now);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitPlanEntities = this.sfaVisitPlanMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanEntities)) {
            sfaVisitPlanEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        List sfaVisitPlanEntities = this.sfaVisitPlanMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanEntities)) {
            sfaVisitPlanEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
            List<String> visitPlanCodeList = sfaVisitPlanEntities.stream().map(SfaVisitPlanEntity::getVisitPlanCode).collect(Collectors.toList());
            this.deleteSfaVisitPlanInfo(visitPlanCodeList);
            this.updateBatchById(sfaVisitPlanEntities);
        }
    }

    private SfaVisitPlanExecuteContext initVisitPlanResolverContext(List<SfaVisitPlanEntity> visitPlanEntities) {
        SfaVisitPlanExecuteContext context = new SfaVisitPlanExecuteContext();
        Map<String, List<SfaVisitPlanEntity>> userPosMapPlan = visitPlanEntities.stream().collect(Collectors.groupingBy(v -> new StringJoiner(":").add(v.getVisitUserName()).add(v.getVisitPosCode()).toString()));
        context.setUserPosMapPlan(userPosMapPlan);
        List visitPlanRangeEntities = this.iSfaVisitPlanRangeService.list((Wrapper)Wrappers.lambdaQuery(SfaVisitPlanRangeEntity.class).in(SfaVisitPlanRangeEntity::getVisitPlanCode, (Collection)visitPlanEntities.stream().map(SfaVisitPlanEntity::getVisitPlanCode).collect(Collectors.toList())));
        Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange = visitPlanRangeEntities.stream().collect(Collectors.groupingBy(SfaVisitPlanRangeEntity::getVisitPlanCode));
        context.setPlanCodeMapPlanRange(planCodeMapPlanRange);
        return context;
    }

    @Override
    @Transactional(readOnly=true)
    public void resolveVisitPlanForWeb(List<String> visitPlanIds) {
        if (org.springframework.util.CollectionUtils.isEmpty(visitPlanIds)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u9700\u8981\u89e3\u6790\u7684\u62dc\u8bbf\u8ba1\u5212");
        }
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        String future = LocalDate.now().plusDays(14L).format(CrmDateUtils.yyyyMMdd);
        List<SfaVisitPlanEntity> visitPlanEntities = this.sfaVisitPlanMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaVisitPlanEntity.class).in(BaseIdEntity::getId, visitPlanIds)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        if (visitPlanEntities.size() != visitPlanIds.size()) {
            throw new BusinessException("\u9009\u62e9\u4e86\u4e0d\u5b58\u5728\u6216\u5df2\u505c\u7528\u7684\u62dc\u8bbf\u8ba1\u5212");
        }
        List<String> visitPosCode = visitPlanEntities.stream().map(SfaVisitPlanEntity::getVisitPosCode).collect(Collectors.toList());
        if ((visitPlanEntities = this.sfaVisitPlanMapper.findListForJob(visitPosCode, now, future)).size() == 0) {
            return;
        }
        SfaVisitPlanExecuteContext context = this.initVisitPlanResolverContext(visitPlanEntities);
        if (!context.isDataReady()) {
            throw new BusinessException(context.getDataReadyMsg());
        }
        this.doResolveVisitPlan(context);
    }

    @Override
    @Transactional
    public void resolveVisitPlanForJob() {
        log.warn("#########################\u62dc\u8bbf\u8ba1\u5212\u89e3\u6790\u5f00\u59cb#########################");
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        String future = LocalDate.now().plusDays(14L).format(CrmDateUtils.yyyyMMdd);
        List<SfaVisitPlanEntity> visitPlanEntities = this.sfaVisitPlanMapper.findListForJob(null, now, future);
        SfaVisitPlanExecuteContext context = this.initVisitPlanResolverContext(visitPlanEntities);
        if (!context.isDataReady()) {
            throw new BusinessException(context.getDataReadyMsg());
        }
        this.doResolveVisitPlan(context);
        log.warn("#########################\u62dc\u8bbf\u8ba1\u5212\u89e3\u6790\u7ed3\u675f#########################");
    }

    private void doResolveVisitPlan(SfaVisitPlanExecuteContext context) {
        Map<String, List<SfaVisitPlanEntity>> userPosMapPlan = context.getUserPosMapPlan();
        for (Map.Entry<String, List<SfaVisitPlanEntity>> entry : userPosMapPlan.entrySet()) {
            List<SfaVisitPlanEntity> sfaVisitPlanEntities = entry.getValue();
            ArrayList planCodeMapFuturePlanInfoOfPlans = Lists.newArrayList();
            for (SfaVisitPlanEntity plan : sfaVisitPlanEntities) {
                context.setCurrentPlanEntity(plan);
                this.resolveVisitPlanInfo(context);
                Map<String, SfaVisitPlanExecuteContext.FuturePlanInfo> planCodeMapFuturePlanInfo = context.getPlanCodeMapFuturePlanInfo();
                if (null != planCodeMapFuturePlanInfo) {
                    planCodeMapFuturePlanInfoOfPlans.add(planCodeMapFuturePlanInfo);
                }
                context.clean();
            }
            String userAndPosition = entry.getKey();
            ArrayList planList = Lists.newArrayList();
            Map<String, Map<String, SfaVisitPlanInfoEntity>> daysPlanInfo = this.mergeFuturePlanInfo(userAndPosition, planCodeMapFuturePlanInfoOfPlans, planList);
            this.injectClientData(planList);
            this.saveVisitPlanInfoToRedisAndEs(daysPlanInfo);
        }
    }

    private void injectClientData(List<SfaVisitPlanInfoEntity> planList) {
        List<String> customerCodes = planList.stream().filter(v -> SfaVisitEnum.ClientType.DEALER.getVal().equals(v.getClientType())).map(SfaVisitPlanInfoEntity::getClientCode).collect(Collectors.toList());
        List<String> terminalCodes = planList.stream().filter(v -> SfaVisitEnum.ClientType.TERMINAL.getVal().equals(v.getClientType())).map(SfaVisitPlanInfoEntity::getClientCode).collect(Collectors.toList());
        Map<String, SfaClientData> clientDataMap = SfaClientHelper.loadClientDataMap(customerCodes, terminalCodes);
        for (SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity : planList) {
            SfaClientData clientData = clientDataMap.get(sfaVisitPlanInfoEntity.getClientType() + sfaVisitPlanInfoEntity.getClientCode());
            CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)clientData, (Object)sfaVisitPlanInfoEntity);
        }
    }

    @Override
    public void saveVisitPlanInfoToRedisAndEs(Map<String, Map<String, SfaVisitPlanInfoEntity>> daysPlanInfo) {
        Map<String, Map<String, List<SfaVisitPlanInfoEntity>>> needDelete = this.visitPlanInfoHelper.flushCounting(daysPlanInfo);
        daysPlanInfo.forEach((redisHash, objectObjectMap) -> {
            Collection<SfaVisitPlanInfoEntity> planInfoEntityList = objectObjectMap.values();
            try {
                Map needDeletePlanInfos = (Map)needDelete.get(redisHash);
                if (null == needDeletePlanInfos) {
                    needDeletePlanInfos = Maps.newHashMap();
                }
                this.saveToES(planInfoEntityList, needDeletePlanInfos);
                objectObjectMap = planInfoEntityList.stream().collect(Collectors.toMap(SfaVisitPlanInfoEntity::getRedisHashKey, v -> v, (r, r2) -> r2));
                this.saveToRedis((String)redisHash, (Map<String, SfaVisitPlanInfoEntity>)objectObjectMap, needDeletePlanInfos.keySet());
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u62dc\u8bbf/\u534f\u8bbf\u8ba1\u5212:\u4fdd\u5b58\u6570\u636e\u5931\u8d25", (Throwable)e);
                throw e;
            }
        });
    }

    private void saveToRedis(String redisHash, Map<String, SfaVisitPlanInfoEntity> objectObjectMap, Set<String> needDeleteRedisHashKeys) {
        boolean redis;
        if (!org.springframework.util.CollectionUtils.isEmpty(needDeleteRedisHashKeys)) {
            Object[] redisHashKeys = needDeleteRedisHashKeys.toArray(new String[needDeleteRedisHashKeys.size()]);
            this.redisService.hdel(redisHash, redisHashKeys);
        }
        if (objectObjectMap.size() > 0 && !(redis = this.redisService.hmset(redisHash, objectObjectMap, 1296000L))) {
            throw new BusinessException("\u89e3\u6790\u62dc\u8bbf\u8ba1\u5212\uff1a\u4fdd\u5b58redis\u5931\u8d25\uff01");
        }
    }

    private void saveToES(Collection<SfaVisitPlanInfoEntity> planInfoEntityList, Map<String, List<SfaVisitPlanInfoEntity>> needDeletePlanInfos) {
        ArrayList valueTemp = Lists.newArrayList();
        for (List<SfaVisitPlanInfoEntity> value : needDeletePlanInfos.values()) {
            valueTemp.addAll(value);
        }
        this.sfaVisitPlanInfoServiceEsImpl.delete(valueTemp);
        if (org.springframework.util.CollectionUtils.isEmpty(planInfoEntityList)) {
            log.warn("\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6\u540c\u6b65ES\u6d88\u606f>>> \u6ca1\u6709\u53ef\u540c\u6b65\u7684\u6570\u636e\uff01");
            return;
        }
        this.sfaVisitPlanInfoServiceEsImpl.saveAll(planInfoEntityList);
    }

    private Map<String, Map<String, SfaVisitPlanInfoEntity>> mergeFuturePlanInfo(String userAndPso, List<Map<String, SfaVisitPlanExecuteContext.FuturePlanInfo>> planCodeMapFuturePlanInfo, List<SfaVisitPlanInfoEntity> planList) {
        LocalDate visitDate = LocalDate.now().plusDays(-1L);
        HashMap daysPlan = Maps.newHashMap();
        for (int i = 0; i < 15; ++i) {
            visitDate = visitDate.plusDays(1L);
            ArrayList total = Lists.newArrayList();
            HashSet hasClientCodes = Sets.newHashSet();
            for (Map<String, SfaVisitPlanExecuteContext.FuturePlanInfo> stringFuturePlanInfoMap : planCodeMapFuturePlanInfo) {
                for (Map.Entry<String, SfaVisitPlanExecuteContext.FuturePlanInfo> entry : stringFuturePlanInfoMap.entrySet()) {
                    SfaVisitPlanExecuteContext.FuturePlanInfo futurePlanInfo = entry.getValue();
                    this.doMerge(total, futurePlanInfo.getPlan(visitDate), hasClientCodes);
                }
            }
            planList.addAll(total);
            Map<String, SfaVisitPlanInfoEntity> dayPlan = total.stream().collect(Collectors.toMap(v -> v.getRedisHashKey(), v -> v, (o, o2) -> o2));
            StringJoiner redisHash = new StringJoiner(":");
            redisHash.add("SFA_VISIT").add("sfa_visit_plan_info").add(SfaVisitEnum.VisitBigType.VISIT.getVal()).add(userAndPso).add(visitDate.format(CrmDateUtils.yyyyMMdd));
            daysPlan.put(redisHash.toString(), dayPlan);
        }
        return daysPlan;
    }

    private void doMerge(List<SfaVisitPlanInfoEntity> total, List<SfaVisitPlanInfoEntity> newData, Set<String> hasClientCodes) {
        for (SfaVisitPlanInfoEntity planInfoEntity : newData) {
            String clientCode = planInfoEntity.getClientCode();
            if (hasClientCodes.contains(clientCode)) continue;
            total.add(planInfoEntity);
            hasClientCodes.add(clientCode);
        }
    }

    private void resolveVisitPlanInfo(SfaVisitPlanExecuteContext context) {
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        SfaVisitPlanResolver planResolver = this.sfaVisitPlanResolverMap.get(sfaVisitPlanEntity.getRouteType() + "Resolver");
        if (null == planResolver) {
            throw new BusinessException("\u62dc\u8bbf\u8ba1\u5212\u89e3\u6790\u6267\u884c\u5931\u8d25\uff0c\u672a\u627e\u5230\u8ba1\u5212\u7ef4\u5ea6\u7c7b\u578b[" + sfaVisitPlanEntity.getRouteType() + "]\u7684\u89e3\u6790\u5b9e\u73b0!");
        }
        planResolver.resolve(context);
    }
}

