/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.integral.service.component;

import com.biz.crm.eunm.mdm.SourceType;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.integral.service.SfaIntegralDetailService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.JsonPropertyUtil;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="TERMINAL_NEW_OR_PASS", consumerGroup="TERMINAL_NEW_OR_PASS${rocketmq.environment-variable}")
public class SfaIntegralDetailClientCreatedMQConsumer
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(SfaIntegralDetailClientCreatedMQConsumer.class);
    @Value(value="${job.runScheduledTask:false}")
    private Boolean runScheduledTask;
    @Resource
    private SfaIntegralDetailService sfaIntegralDetailService;

    protected Object handleMessage(RocketMQMessageBody message) {
        if (this.runScheduledTask.booleanValue()) {
            String msg = message.getMsgBody();
            if (StringUtils.isEmpty((Object)msg)) {
                return "\u6d88\u606f\u4f53\u4e3a\u7a7a!";
            }
            MdmTerminalVo mdmTerminalVo = (MdmTerminalVo)JsonPropertyUtil.toObject((String)msg, MdmTerminalVo.class);
            if (null == mdmTerminalVo) {
                return "\u5e8f\u5217\u5316\u6d88\u606f\u4f53\u5931\u8d25!";
            }
            String sourceType = mdmTerminalVo.getSourceType();
            if (SourceType.WE_CHAT_APP.getValue().equals(sourceType) || SourceType.ANDROID.getValue().equals(sourceType) || SourceType.IOS.getValue().equals(sourceType)) {
                SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
                integralDetailAddReq.setBizId(mdmTerminalVo.getId());
                integralDetailAddReq.setIntegralTaskType(IntegralEnum.taskType.SAVE_TERMINAL.getValue());
                integralDetailAddReq.setPosCode(mdmTerminalVo.getCreatePosCode());
                integralDetailAddReq.setUserName(mdmTerminalVo.getCreateName());
                this.sfaIntegralDetailService.integralDetailAdd(integralDetailAddReq);
                return "\u64cd\u4f5c\u6210\u529f";
            }
            return "sourceType = " + sourceType;
        }
        return "runScheduledTask = false";
    }
}

