/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.achievement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.mapper.SfaAchievementAccomplishRecordMapper;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementTimeTotalRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SfaAchievementAccomplishRecordServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaAchievementAccomplishRecordMapper, SfaAchievementAccomplishRecordEntity>
implements ISfaAchievementAccomplishRecordService {
    @Autowired
    private SfaAchievementAccomplishRecordMapper achievementAccomplishRecordMapper;

    @Override
    public void save(List<SfaAchievementAccomplishRecordReqVo> reqVo) {
        List orgList;
        if (CollectionUtil.listEmpty(reqVo)) {
            throw new BusinessException("\u6570\u636e\u4e3a\u7a7a");
        }
        String createOrgCodeList = "";
        UserRedis user = UserUtils.getUser();
        if (StringUtils.isNotEmpty((CharSequence)user.getOrgcode()) && CollectionUtil.listNotEmpty((List)(orgList = OrgUtil.getParentOrgListIncludeSelf((String)user.getOrgcode())))) {
            createOrgCodeList = orgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.joining(","));
        }
        String finalCreateOrgCodeList = createOrgCodeList;
        reqVo.forEach(o -> {
            if (StringUtils.isEmpty((CharSequence)o.getCreateOrgCodeList())) {
                o.setCreateOrgCodeList(finalCreateOrgCodeList);
            }
        });
        for (SfaAchievementAccomplishRecordReqVo recordReqVo : reqVo) {
            AssertUtils.isNotEmpty((String)recordReqVo.getIndexCode(), (String)"\u6307\u6807\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            recordReqVo.setCreateOrgCodeList(recordReqVo.getCreateOrgCodeList());
            AssertUtils.isNotEmpty((String)recordReqVo.getCreateOrgCodeList(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)recordReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            if (!StringUtils.isEmpty((CharSequence)recordReqVo.getCreateTime())) continue;
            recordReqVo.setCreateTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
            recordReqVo.setCreateYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        }
        List entities = CrmBeanUtil.copyList(reqVo, SfaAchievementAccomplishRecordEntity.class);
        List relationIdList = entities.stream().map(SfaAchievementAccomplishRecordEntity::getRelationId).collect(Collectors.toList());
        List sfaAchievementAccomplishRecordEntity = this.achievementAccomplishRecordMapper.selectList((Wrapper)Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class).in(SfaAchievementAccomplishRecordEntity::getRelationId, relationIdList));
        if (CollectionUtil.listNotEmpty((List)sfaAchievementAccomplishRecordEntity)) {
            List relationIds = sfaAchievementAccomplishRecordEntity.stream().map(SfaAchievementAccomplishRecordEntity::getRelationId).collect(Collectors.toList());
            this.achievementAccomplishRecordMapper.delete((Wrapper)this.lambdaQuery().in(SfaAchievementAccomplishRecordEntity::getRelationId, relationIds));
        }
        this.saveBatch(entities);
    }

    @Override
    public void delete(String relationId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"relation_id", (Object)relationId);
        this.achievementAccomplishRecordMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public void updateDeleteStateByRelationId(String relationId) {
        AssertUtils.isNotEmpty((String)relationId, (String)"\u5173\u8054id\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"relation_id", (Object)relationId);
        SfaAchievementAccomplishRecordEntity entity = (SfaAchievementAccomplishRecordEntity)((Object)this.achievementAccomplishRecordMapper.selectOne((Wrapper)queryWrapper));
        if (!ObjectUtils.isEmpty((Object)((Object)entity))) {
            if (CrmDelFlagEnum.NORMAL.getCode().equals(entity.getDelFlag())) {
                entity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            }
            if (CrmDelFlagEnum.DELETE.getCode().equals(entity.getDelFlag())) {
                entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            }
        }
        this.achievementAccomplishRecordMapper.updateById((Object)entity);
    }

    @Override
    public List<SfaAchievementTimeTotalRespVo> findAccomplishNumByYm(String posCode, String indexCode) {
        return null;
    }

    @Override
    public List<SfaAchievementTimeTotalRespVo> findPosCodeListAccomplishNum(List<String> posCodeList, String indexCode, String startDate, String endDate) {
        return null;
    }

    @Override
    public void save(SfaAchievementAccomplishRecordReqVo reqVo) {
        List entities;
        if (StringUtils.isEmpty((CharSequence)reqVo.getObjectPosCode())) {
            return;
        }
        AssertUtils.isNotEmpty((String)reqVo.getIndexCode(), (String)"\u6307\u6807\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getUsername(), (String)"\u521b\u5efa\u4ebausername\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getObjectPosCode(), (String)"\u521b\u5efa\u4eba\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCreateOrgCodeList(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getRelationId(), (String)"\u5173\u8054id\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((CharSequence)reqVo.getCreateTime())) {
            reqVo.setCreateTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
            reqVo.setCreateYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        }
        if (CollectionUtil.listNotEmpty((List)(entities = this.achievementAccomplishRecordMapper.selectList((Wrapper)Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class).eq(SfaAchievementAccomplishRecordEntity::getRelationId, (Object)reqVo.getRelationId()))))) {
            this.achievementAccomplishRecordMapper.deleteBatchIds(entities.stream().map(BaseIdEntity::getId).collect(Collectors.toList()));
        }
        this.save(CrmBeanUtil.copy((Object)reqVo, SfaAchievementAccomplishRecordEntity.class));
    }

    @Override
    public void deleteByRelationId(String relationId) {
        AssertUtils.isNotEmpty((String)relationId, (String)"\u5173\u8054id\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(SfaAchievementAccomplishRecordEntity::getRelationId, (Object)relationId)).set(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.DELETE.getCode())).update();
    }

    @Override
    public void reuseByRelationId(String relationId) {
        AssertUtils.isNotEmpty((String)relationId, (String)"\u5173\u8054id\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(SfaAchievementAccomplishRecordEntity::getRelationId, (Object)relationId)).set(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).update();
    }
}

