/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.workbench;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.cache.util.WorkUtil;
import com.biz.crm.common.CrmIdsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.freesignconfig.service.ISfaFreesignConfigService;
import com.biz.crm.moblie.controller.workbench.resp.SfaNoticeRespVo;
import com.biz.crm.nebular.sfa.worksign.req.ClockReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditListLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaSignHistoryListReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaSignHistoryListRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignPictureRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.model.NeedClock;
import com.biz.crm.worksign.model.SfaWorkSignPictureEntity;
import com.biz.crm.worksign.service.ISfaLeaveCancelService;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaTravelService;
import com.biz.crm.worksign.service.ISfaWorkSignPictureService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/worksignrule"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u5de5\u4f5c\u53f0\u9875\u9762-\u8003\u52e4\u7ba1\u7406 "})
public class SfaWorkSignController {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignController.class);
    @Autowired
    private ISfaWorkSignRuleInfoService sfaWorkSignRuleInfoService;
    @Autowired
    private ISfaWorkSignRecordService sfaWorkSignRecordService;
    @Autowired
    private ISfaWorkSignPictureService sfaWorkSignPictureService;
    @Autowired
    private ISfaFreesignConfigService sfaFreesignConfigService;
    @Autowired
    private ISfaLeaveService iSfaLeaveService;
    @Autowired
    ISfaLeaveCancelService iSfaLeaveCancelService;
    @Autowired
    private ISfaTravelService iSfaTravelService;
    @Autowired
    private WorkUtil workUtil;

    @ApiOperation(value="\u5de5\u4f5c\u53f0\u9875\u9762\u2014\u2014\u7edf\u4e00\u6c14\u6ce1\u63a5\u53e3")
    @PostMapping(value={"/getAllNotice"})
    public Result<SfaNoticeRespVo> getAllNotice() {
        UserRedis userRedis = UserUtils.getUser();
        return Result.ok((Object)this.workUtil.getObj(userRedis.getPoscode()));
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u5f53\u524d\u65f6\u95f4\u4e0a\u73ed\u7b7e\u5230")
    @PostMapping(value={"/fingGotoWorkClockIn"})
    @CrmLog
    @CrmDictMethod
    public Result<SfaWorkSignRecordRespVo> fingGotoWorkClockIn() {
        return Result.ok((Object)this.sfaWorkSignRuleInfoService.findSignRecordByNow(SfaWorkSignEnum.WorkSignType.CLOCK_IN));
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u5730\u70b9\u5f53\u524d\u767b\u5f55\u4eba\u662f\u5426\u5730\u70b9\u5f02\u5e38")
    @PostMapping(value={"/getPlaceStatus"})
    @CrmLog
    public Result getPlaceStatus(@RequestBody ClockReqVo clockReqVo) {
        return this.sfaWorkSignRecordService.getPlaceStatus(clockReqVo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u65f6\u95f4\u4e4b\u524d\uff0c\u6253\u5361\u65f6\u662f\u5426\u6709\u5176\u4ed6\u65f6\u95f4\u6bb5\u7684\u6253\u5361\u660e\u7ec6\u3002")
    @GetMapping(value={"/getOtherTimeRecordInfo"})
    @CrmLog
    @ApiImplicitParams(value={@ApiImplicitParam(name="workSignType", value="\u67e5\u8be2\u7684\u6253\u5361\u7c7b\u578b", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="id", value="\u5f53\u524d\u7684\u6253\u5361id\u4e0d\u80fd\u4e3a\u7a7a", required=true, dataType="String", paramType="query")})
    public Result getOtherTimeRecordInfo(@RequestParam(value="workSignType", required=false) String workSignType, @RequestParam(value="id", required=false) String id) {
        return Result.ok(this.sfaWorkSignRecordService.getOtherTimeRecordInfo(workSignType, id));
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u5f53\u524d\u65f6\u95f4\u4e0b\u73ed\u7b7e\u9000")
    @PostMapping(value={"/fingGooffWorkSignOut"})
    @CrmLog
    @CrmDictMethod
    public Result<SfaWorkSignRecordRespVo> fingGooffWorkSignOut() {
        return Result.ok((Object)this.sfaWorkSignRuleInfoService.findSignRecordByNow(SfaWorkSignEnum.WorkSignType.CLOCK_OUT));
    }

    @ApiOperation(value="\u6253\u5361\u63a5\u53e3")
    @PostMapping(value={"/gotoWorkClock"})
    @CrmLog
    public Result gotoWorkClock(@RequestBody ClockReqVo clockReqVo) {
        Result result = this.sfaWorkSignRecordService.gotoWorkClock(clockReqVo);
        return result;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u662f\u5426\u9700\u8981\u6253\u5361")
    @PostMapping(value={"/needWorkSign"})
    @CrmLog
    public Result<NeedClock> needWorkSign() {
        return Result.ok((Object)this.sfaWorkSignRecordService.needWorkSign());
    }

    @ApiOperation(value="\u8bf7\u5047-\u5217\u8868\u67e5\u8be2(\u6211\u7684\u63d0\u4ea4\u7684)")
    @PostMapping(value={"/findSfaLeaveBpmList"})
    @CrmLog
    public Result<PageResult<SfaLeaveRespVo>> findSfaLeaveBpmList(@RequestBody SfaLeaveListReqVo sfaLeaveReqVo) {
        PageResult<SfaLeaveRespVo> result = new PageResult<SfaLeaveRespVo>();
        UserRedis userRedis = UserUtils.getUser();
        if (null != userRedis && StringUtil.isNotEmpty((String)userRedis.getUsername())) {
            if (StringUtils.isEmpty((String)sfaLeaveReqVo.getUserName())) {
                sfaLeaveReqVo.setUserName(userRedis.getUsername());
            }
            result = this.iSfaLeaveService.findList(sfaLeaveReqVo);
        }
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u8bf7\u5047-\u8be6\u60c5")
    @PostMapping(value={"/findSfaLeaveById"})
    @CrmLog
    public Result<SfaLeaveRespVo> findSfaLeaveById(@RequestBody CrmIdsReqVo idsReqVo) {
        Result result = new Result();
        if (idsReqVo == null || idsReqVo.getIds() == null || idsReqVo.getIds().size() == 0) {
            result.error500("\u8bf7\u8f93\u5165\u4e1a\u52a1\u4e3b\u952e");
            return result;
        }
        SfaLeaveListReqVo sfaLeaveReqVo = new SfaLeaveListReqVo();
        sfaLeaveReqVo.setId((String)idsReqVo.getIds().get(0));
        PageResult<SfaLeaveRespVo> pageResult = this.iSfaLeaveService.findList(sfaLeaveReqVo);
        if (pageResult == null || !CollectionUtil.listNotEmptyNotSizeZero((List)pageResult.getData())) {
            throw new BusinessException((String)idsReqVo.getIds().get(0) + "\u6570\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728\u4e86");
        }
        result.setResult(pageResult.getData().get(0));
        return result;
    }

    @ApiOperation(value="\u8bf7\u5047-\u7533\u8bf7")
    @PostMapping(value={"/goApplyLeave"})
    @CrmLog
    public Result goApplyLeave(@RequestBody SfaLeaveReqVo sfaLeaveReqVo) {
        Result result = this.iSfaLeaveService.goApplyLeave(sfaLeaveReqVo);
        return result;
    }

    @ApiOperation(value="\u8bf7\u5047-\u8ba1\u7b97\u65f6\u957f")
    @PostMapping(value={"/countApplyDays"})
    @CrmLog
    public Result countApplyDays(@RequestBody SfaLeaveReqVo reqVo) {
        Result result = Result.ok();
        result.setResult((Object)this.iSfaLeaveService.countApplyDays(reqVo).getLeaveDuration());
        return result;
    }

    @ApiOperation(value="\u8bf7\u5047-\u8ffd\u56de")
    @PostMapping(value={"/rollbackLeave"})
    @CrmLog
    public Result rollbackLeave(@RequestBody CrmIdsReqVo idsReqVo) {
        Result result = new Result();
        if (idsReqVo == null || idsReqVo.getIds() == null || idsReqVo.getIds().size() == 0) {
            result.error500("\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        result = this.iSfaLeaveService.rollbackLeave((String)idsReqVo.getIds().get(0));
        return result;
    }

    @ApiOperation(value="\u8bf7\u5047-\u8ffd\u52a0\u9644\u4ef6\u4fe1\u606f")
    @PostMapping(value={"/addAttachment"})
    @CrmLog
    public Result addAttachmentLeave(@RequestBody SfaLeaveReqVo sfaLeaveReqVo) {
        Result result = this.iSfaLeaveService.addAttachment(sfaLeaveReqVo);
        return result;
    }

    @ApiOperation(value="\u8bf7\u5047-\u9500\u5047")
    @PostMapping(value={"/cancelLeave"})
    @CrmLog
    public Result cancelLeave(@RequestBody SfaAuditCancelReqVo reqVo) {
        return this.iSfaLeaveService.cancelLeave(reqVo);
    }

    @ApiOperation(value="\u9500\u5047-\u8be6\u60c5")
    @PostMapping(value={"/findSfaLeaveCancelById"})
    @CrmLog
    public Result<SfaLeaveCancelInfoRespVo> findSfaLeaveCancelById(final @RequestBody CrmIdsReqVo idsReqVo) {
        AssertUtils.isNotNull((Object)idsReqVo.getIds(), (String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u7ec4\u4ef6");
        SfaAuditListLeaveCancelReqVo reqVo = new SfaAuditListLeaveCancelReqVo(){
            {
                this.setId((String)idsReqVo.getIds().get(0));
            }
        };
        PageResult<SfaLeaveCancelInfoRespVo> pageResult = this.iSfaLeaveCancelService.findInfoList(reqVo);
        if (pageResult == null || pageResult.getCount() != 1L) {
            throw new BusinessException("\u9500\u5047id\u9519\u8bef");
        }
        return Result.ok(pageResult.getData().get(0));
    }

    @ApiOperation(value="\u8003\u52e4\u5386\u53f2")
    @PostMapping(value={"/signHistoryList"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaSignHistoryListRespVo>> signHistoryList(@RequestBody SfaSignHistoryListReqVo reqVo) {
        PageResult<SfaSignHistoryListRespVo> pageResult = this.sfaWorkSignRecordService.findSignHistory(reqVo);
        if (pageResult != null && pageResult.getData() != null && pageResult.getData().size() > 0) {
            pageResult.getData().forEach(history -> history.setWorkSignStatusDesc(SfaWorkSignEnum.WorkSignStatus.getDesc((String)history.getWorkSignStatus())));
        }
        return Result.ok(pageResult);
    }

    @ApiOperation(value="\u7b7e\u5230\u8be6\u60c5")
    @PostMapping(value={"/signInfo"})
    @CrmLog
    @CrmDictMethod
    public Result<SfaSignHistoryListRespVo> signInfo(@RequestBody CrmIdsReqVo reqVo) {
        if (reqVo == null || reqVo.getIds() == null || reqVo.getIds().size() == 0) {
            Result result = new Result();
            return result.error500("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaSignHistoryListReqVo listReqVo = new SfaSignHistoryListReqVo();
        listReqVo.setId((String)reqVo.getIds().get(0));
        SfaSignHistoryListRespVo vo = new SfaSignHistoryListRespVo();
        Result<PageResult<SfaSignHistoryListRespVo>> result = this.signHistoryList(listReqVo);
        if (((PageResult)result.getResult()).getData() != null && ((PageResult)result.getResult()).getData().size() > 0) {
            vo = (SfaSignHistoryListRespVo)((PageResult)result.getResult()).getData().get(0);
            vo.setGooffTime(vo.getSfaSignTime());
            vo.setGotoTime(vo.getSfaSignTime());
            List pictureEntities = this.sfaWorkSignPictureService.list((Wrapper)Wrappers.lambdaQuery(SfaWorkSignPictureEntity.class).eq(SfaWorkSignPictureEntity::getWsRecordId, (Object)vo.getId()));
            List sfaWorkSignPictureRespVos = CrmBeanUtil.copyList((List)pictureEntities, SfaWorkSignPictureRespVo.class);
            vo.setPictureList(sfaWorkSignPictureRespVos);
        }
        return Result.ok((Object)vo);
    }
}

