/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.checkin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.checkin.mapper.SfaCheckInSignRecordMapper;
import com.biz.crm.checkin.model.SfaCheckInSignRecordEntity;
import com.biz.crm.checkin.model.SfaCheckInSignRecordPictureEntity;
import com.biz.crm.checkin.service.ISfaCheckInDateService;
import com.biz.crm.checkin.service.ISfaCheckInGroupService;
import com.biz.crm.checkin.service.ISfaCheckInSignGroupReportService;
import com.biz.crm.checkin.service.ISfaCheckInSignRecordPictureService;
import com.biz.crm.checkin.service.ISfaCheckInSignRecordService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.VisitStepFromEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupReqVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInSignRecordReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInDateRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInPlaceRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInSignRecordRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInTypeRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaSignHistoryListReqVo;
import com.biz.crm.util.AssertDateTimeUtils;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DistanceUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import io.jsonwebtoken.lang.Collections;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaCheckInSignRecordServiceExpandImpl"})
public class SfaCheckInSignRecordServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaCheckInSignRecordMapper, SfaCheckInSignRecordEntity>
implements ISfaCheckInSignRecordService {
    private static final Logger log = LoggerFactory.getLogger(SfaCheckInSignRecordServiceImpl.class);
    @Resource
    private SfaCheckInSignRecordMapper sfaCheckInSignRecordMapper;
    @Autowired
    private ISfaCheckInSignRecordPictureService iSfaCheckInSignRecordPictureService;
    @Autowired
    private ISfaCheckInGroupService iSfaCheckInGroupService;
    @Autowired
    private ISfaSignFormsService formsService;
    @Autowired
    private ISfaCheckInSignGroupReportService iSfaCheckInSignGroupReportService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private ISfaCheckInDateService iSfaCheckInDateService;

    @Override
    public PageResult<SfaCheckInSignRecordRespVo> findList(SfaSignHistoryListReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaCheckInSignRecordRespVo> list = this.sfaCheckInSignRecordMapper.findSignHistory((Page<SfaCheckInSignRecordRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaCheckInSignRecordRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u4f20\u5165ID\u53c2\u6570\u4e3a\u7a7a");
        SfaCheckInSignRecordEntity entity = (SfaCheckInSignRecordEntity)((Object)this.sfaCheckInSignRecordMapper.selectOne((Wrapper)Wrappers.lambdaQuery(SfaCheckInSignRecordEntity.class).eq(BaseIdEntity::getId, (Object)id)));
        if (entity == null) {
            throw new BusinessException("\u7b7e\u5230\u8bb0\u5f55id\u9519\u8bef");
        }
        SfaCheckInSignRecordRespVo respVo = (SfaCheckInSignRecordRespVo)CrmBeanUtil.copy((Object)((Object)entity), SfaCheckInSignRecordRespVo.class);
        respVo.setPictureRespVoList(this.iSfaCheckInSignRecordPictureService.findList(entity.getId()));
        return respVo;
    }

    @Override
    public PageResult<SfaCheckInGroupRespVo> myCheckInGroup(PageVo pageVo) {
        UserRedis user = UserUtils.getUser();
        if (user == null) {
            throw new BusinessException("\u8bf7\u767b\u5f55");
        }
        SfaCheckInGroupReqVo reqVo = new SfaCheckInGroupReqVo();
        reqVo.setPageNum(pageVo.getPageNum());
        reqVo.setPageSize(pageVo.getPageSize());
        reqVo.setEnableStatus(CrmDelFlagEnum.NORMAL.getCode());
        reqVo.setCheckInDate(LocalDate.now().toString());
        reqVo.setUserOrOrgByUser(user.getUsername());
        reqVo.setUserOrOrgByOrg(user.getOrgcode());
        return this.iSfaCheckInGroupService.myCheckInGroup(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void checkInGroupSign(SfaCheckInSignRecordReqVo reqVo) {
        LocalDateTime localDateTime = LocalDateTime.now();
        String signDate = localDateTime.format(CrmDateUtils.yyyyMMdd);
        SfaCheckInSignRecordEntity entityOld = new SfaCheckInSignRecordEntity();
        if (StringUtils.isNotEmpty((String)reqVo.getGroupCode())) {
            AssertUtils.isNotEmpty((String)reqVo.getCheckInTypeId(), (String)"\u8bf7\u9009\u62e9\u7b7e\u5230\u7c7b\u578b");
            entityOld = (SfaCheckInSignRecordEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaCheckInSignRecordEntity::getGroupCode, (Object)reqVo.getGroupCode())).eq(SfaCheckInSignRecordEntity::getCheckInTypeId, (Object)reqVo.getCheckInTypeId())).eq(SfaCheckInSignRecordEntity::getSignDate, (Object)signDate)).one());
            if (null == entityOld) {
                entityOld = (SfaCheckInSignRecordEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaCheckInSignRecordEntity.class));
            } else {
                throw new BusinessException("\u4eca\u65e5\u5df2\u5b58\u5728\u8be5\u7c7b\u578b\u7684\u81ea\u7531\u7b7e\u5230\uff01");
            }
        }
        CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)reqVo, (Object)((Object)entityOld));
        SfaCheckInSignRecordEntity entity = entityOld;
        UserRedis user = UserUtils.getUser();
        if (user == null) {
            throw new BusinessException("\u8bf7\u767b\u5f55");
        }
        if (!Collections.isEmpty((Collection)reqVo.getPictureReqVos())) {
            reqVo.getPictureReqVos().forEach(vo -> {
                if (StringUtils.isEmpty((String)vo.getPicUrl()) && StringUtils.isEmpty((String)vo.getPicPath())) {
                    throw new BusinessException("\u7167\u7247\u4fe1\u606f\u4e0d\u5b8c\u6574");
                }
            });
        }
        entity.setUserName(user.getUsername());
        entity.setRealName(user.getRealname());
        entity.setOrgName(user.getOrgname());
        entity.setOrgCode(user.getOrgcode());
        entity.setPosName(user.getPosname());
        entity.setPosCode(user.getPoscode());
        MdmPositionUserOrgRespVo mdm = this.formsService.getUserOrgInfo(entity.getUserName());
        entity.setParentOrgCode(mdm.getParentOrgCode());
        entity.setParentOrgName(mdm.getParentOrgName());
        entity.setSignDate(signDate);
        entity.setSignTime(localDateTime.format(CrmDateUtils.HHmmss));
        entity.setSignPlace(reqVo.getWorkSignPlace());
        if (StringUtils.isNotEmpty((String)entity.getGroupCode())) {
            SfaCheckInSignRecordEntity old;
            AssertUtils.isNotEmpty((String)entity.getCheckInTypeId(), (String)"\u6253\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            SfaCheckInGroupRespVo groupRespVo = this.iSfaCheckInGroupService.getByGroupCode(entity.getGroupCode());
            if (groupRespVo == null) {
                throw new BusinessException("\u7b7e\u5230\u7ec4\u7f16\u7801\u9519\u8bef");
            }
            if (VisitStepFromEnum.timeType.DIY_TIME.getValue().equals(groupRespVo.getTimeType())) {
                List dateRespVos = groupRespVo.getDateRespVos().stream().filter(vo -> {
                    LocalDate dateStart = LocalDate.parse(vo.getStartTime());
                    LocalDate dateEnd = LocalDate.parse(vo.getEndTime());
                    LocalDate dateSignDate = LocalDate.parse(entity.getSignDate());
                    int compareToStart = dateStart.compareTo(dateSignDate);
                    int compareToEnd = dateEnd.compareTo(dateSignDate);
                    return compareToStart <= 0 && compareToEnd >= 0;
                }).collect(Collectors.toList());
                if (dateRespVos == null || dateRespVos.size() == 0 || dateRespVos.get(0) == null) {
                    throw new BusinessException("\u5f53\u524d\u65e5\u671f\u4e0d\u80fd\u6253\u5361");
                }
                SfaCheckInDateRespVo dateRespVo = (SfaCheckInDateRespVo)dateRespVos.get(0);
                entity.setCheckInDateId(dateRespVo.getId());
            } else {
                entity.setCheckInDateId(null);
            }
            List typeRespVos = groupRespVo.getTypeRespVos().stream().filter(vo -> vo.getId().equals(entity.getCheckInTypeId())).collect(Collectors.toList());
            if (typeRespVos == null || typeRespVos.size() == 0 || typeRespVos.get(0) == null) {
                throw new BusinessException("\u6253\u5361\u7c7b\u578bid\u4e0d\u5b58\u5728");
            }
            SfaCheckInTypeRespVo typeRespVo = (SfaCheckInTypeRespVo)typeRespVos.get(0);
            if (YesNoEnum.yesNoEnum.YES.getValue().equals(typeRespVo.getPhotograph())) {
                AssertUtils.isNotEmpty((Collection)reqVo.getPictureReqVos(), (String)"\u6253\u5361\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (YesNoEnum.yesNoEnum.YES.getValue().equals(typeRespVo.getAppointTime())) {
                AssertDateTimeUtils.checkBetweenTime((String)entity.getSignTime(), (String)typeRespVo.getBeginTime(), (String)typeRespVo.getEndTime(), (String)"\u5f53\u524d\u65f6\u95f4\u4e0d\u80fd\u6253\u5361");
            }
            if ((old = (SfaCheckInSignRecordEntity)((Object)this.sfaCheckInSignRecordMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaCheckInSignRecordEntity.class).eq(SfaCheckInSignRecordEntity::getGroupCode, (Object)entity.getGroupCode())).eq(SfaCheckInSignRecordEntity::getCheckInDateId, (Object)entity.getCheckInDateId())).eq(SfaCheckInSignRecordEntity::getCheckInTypeId, (Object)entity.getCheckInTypeId())).eq(SfaCheckInSignRecordEntity::getUserName, (Object)entity.getUserName())))) != null) {
                throw new BusinessException("\u5f53\u524d\u6253\u5361\u7c7b\u578b\u5df2\u7ecf\u7b7e\u5230\uff0c\u8bf7\u52ff\u91cd\u590d\u6253\u5361\uff01");
            }
            YesNoEnum.yesNoEnum yesNoEnum2 = this.checkSignPlace(groupRespVo, entity);
            entity.setGroupName(groupRespVo.getGroupName());
            entity.setCheckInTypeName(typeRespVo.getTypeName());
            this.saveOrUpdate((Object)entity);
            this.iSfaCheckInSignGroupReportService.refreshReportByUserName(entity, yesNoEnum2);
        }
        this.saveOrUpdate((Object)entity);
        if (!Collections.isEmpty((Collection)reqVo.getPictureReqVos())) {
            reqVo.getPictureReqVos().forEach(vo -> {
                SfaCheckInSignRecordPictureEntity pictureEntity = (SfaCheckInSignRecordPictureEntity)((Object)((Object)CrmBeanUtil.copy((Object)vo, SfaCheckInSignRecordPictureEntity.class)));
                pictureEntity.setSignRecordId(entity.getId());
                this.iSfaCheckInSignRecordPictureService.save((Object)pictureEntity);
            });
        }
    }

    private YesNoEnum.yesNoEnum checkSignPlace(SfaCheckInGroupRespVo groupRespVo, SfaCheckInSignRecordEntity entity) {
        String electronFenceType = groupRespVo.getElectronFenceType();
        if (SfaWorkSignEnum.ElectronFenceEnum.NONE.getVal().equals(electronFenceType)) {
            return YesNoEnum.yesNoEnum.NO;
        }
        boolean outOfRange = true;
        List placeRespVos = groupRespVo.getPlaceRespVos();
        if (CollectionUtil.listNotEmpty((List)placeRespVos)) {
            for (SfaCheckInPlaceRespVo placeRespVo : placeRespVos) {
                double distance = Double.parseDouble(placeRespVo.getSignPlaceScope());
                double latinOne = Double.parseDouble(placeRespVo.getPlaceLatin());
                double lnginOne = Double.parseDouble(placeRespVo.getPlaceLngin());
                double lnginTwo = Double.parseDouble(entity.getLngIn());
                double latinTwo = Double.parseDouble(placeRespVo.getPlaceLatin());
                double distanceTrue = DistanceUtil.getDistance((double)latinOne, (double)lnginOne, (double)latinTwo, (double)lnginTwo);
                if (!(distance > distanceTrue)) continue;
                outOfRange = false;
                break;
            }
        }
        if (outOfRange) {
            if (SfaWorkSignEnum.ElectronFenceEnum.NO_OUT_SIGN.getVal().equals(electronFenceType)) {
                throw new BusinessException("\u79bb\u89c4\u5b9a\u6253\u5361\u5730\u70b9\u8fc7\u8fdc");
            }
            if (SfaWorkSignEnum.ElectronFenceEnum.OUT_SIGN_EX.getVal().equals(electronFenceType)) {
                return YesNoEnum.yesNoEnum.YES;
            }
            return YesNoEnum.yesNoEnum.NO;
        }
        return YesNoEnum.yesNoEnum.NO;
    }
}

