/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.util;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignPersonnelEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignPersonnelService;
import com.biz.crm.worksignrule.service.ISfaWorkSignRuleService;
import com.biz.crm.worksignrule.service.ISfaWorkSignTimeService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class SignRuleUtils {
    private static ISfaWorkSignRuleService sfaWorkSignRuleService = (ISfaWorkSignRuleService)SpringApplicationContextUtil.getApplicationContext().getBean(ISfaWorkSignRuleService.class);
    private static ISfaWorkSignTimeService iSfaWorkSignTimeService = (ISfaWorkSignTimeService)SpringApplicationContextUtil.getApplicationContext().getBean(ISfaWorkSignTimeService.class);
    private static ISfaWorkSignPersonnelService iSfaWorkSignPersonnelService = (ISfaWorkSignPersonnelService)SpringApplicationContextUtil.getApplicationContext().getBean(ISfaWorkSignPersonnelService.class);

    private SignRuleUtils() {
    }

    public static SfaWorkSignRuleEntity hitUserSignRuleCode(String userOrgCode, Map<String, List<SfaWorkSignPersonnelEntity>> personnelEntitiesGroupByOrgCode, Map<String, SfaWorkSignPersonnelEntity> personnelEntityRuleCodeMappingOfLevelCode, List<MdmOrgRespVo> userOrgAndParentOrg, Map<String, SfaWorkSignRuleEntity> ruleEntityMap) {
        List<SfaWorkSignPersonnelEntity> personnelEntitiesOfOrgCode = personnelEntitiesGroupByOrgCode.get(userOrgCode);
        SignRuleCode ruleCode2 = SignRuleUtils.doHitRuleCode(personnelEntitiesOfOrgCode, personnelEntityRuleCodeMappingOfLevelCode, ruleEntityMap);
        SfaWorkSignRuleEntity hitOfOrgCodeAndLevelCode = ruleCode2.getHitOfOrgCodeAndLevelCode();
        if (null != hitOfOrgCodeAndLevelCode) {
            return hitOfOrgCodeAndLevelCode;
        }
        SfaWorkSignRuleEntity hitOfOrgRuleEntity = null;
        Map<String, String> orgCodeMapParentCode = userOrgAndParentOrg.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, MdmOrgRespVo::getParentCode, (s, s2) -> s2));
        while (orgCodeMapParentCode.containsKey(userOrgCode)) {
            String parentCode;
            if (null == hitOfOrgRuleEntity && null != ruleCode2.getHitOfOrgCode()) {
                hitOfOrgRuleEntity = ruleCode2.getHitOfOrgCode();
            }
            if (StringUtils.isBlank((CharSequence)(parentCode = orgCodeMapParentCode.get(userOrgCode)))) {
                return hitOfOrgRuleEntity;
            }
            personnelEntitiesOfOrgCode = personnelEntitiesGroupByOrgCode.get(userOrgCode);
            ruleCode2 = SignRuleUtils.doHitRuleCode(personnelEntitiesOfOrgCode, personnelEntityRuleCodeMappingOfLevelCode, ruleEntityMap);
            hitOfOrgCodeAndLevelCode = ruleCode2.getHitOfOrgCodeAndLevelCode();
            if (null != hitOfOrgCodeAndLevelCode) {
                return hitOfOrgCodeAndLevelCode;
            }
            userOrgCode = parentCode;
        }
        return hitOfOrgRuleEntity;
    }

    public static SignRuleCode doHitRuleCode(List<SfaWorkSignPersonnelEntity> personnelEntitiesOfOrgCode, Map<String, SfaWorkSignPersonnelEntity> personnelEntityRuleCodeMappingOfLevelCode, Map<String, SfaWorkSignRuleEntity> ruleEntityMap) {
        if (CollectionUtils.isEmpty(personnelEntitiesOfOrgCode)) {
            return SignRuleCode.builder().build();
        }
        SfaWorkSignPersonnelEntity entity = null;
        for (SfaWorkSignPersonnelEntity personnelEntity : personnelEntitiesOfOrgCode) {
            String ruleCode2 = personnelEntity.getRuleCode();
            if (personnelEntityRuleCodeMappingOfLevelCode.containsKey(ruleCode2) && ruleEntityMap.containsKey(ruleCode2)) {
                return SignRuleCode.builder().hitOfOrgCodeAndLevelCode(ruleEntityMap.get(ruleCode2)).build();
            }
            entity = personnelEntity;
        }
        if (null == entity || StringUtils.isBlank((CharSequence)entity.getRuleCode())) {
            return SignRuleCode.builder().build();
        }
        return SignRuleCode.builder().hitOfOrgCode(ruleEntityMap.get(entity.getRuleCode())).build();
    }

    public static SfaWorkSignRuleEntity getUserSignRuleCode(MdmPositionRespVo primaryPosition) {
        if (null == primaryPosition) {
            return null;
        }
        String positionLevelCode = primaryPosition.getPositionLevelCode();
        if (StringUtils.isBlank((CharSequence)positionLevelCode)) {
            throw new BusinessException("\u8be5\u7528\u6237\u4e3b\u804c\u4f4d\u4fe1\u606f\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\uff01");
        }
        Map<String, SfaWorkSignPersonnelEntity> personnelEntityRuleCodeMappingOfLevelCode = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)iSfaWorkSignPersonnelService.lambdaQuery().eq(SfaWorkSignPersonnelEntity::getWspCode, (Object)positionLevelCode)).eq(SfaWorkSignPersonnelEntity::getCodeType, (Object)WorkSignEnum.codeType.POS_LEVEL.getVal())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list().stream().collect(Collectors.toMap(SfaWorkSignPersonnelEntity::getRuleCode, v -> v, (t, t2) -> t2));
        String userOrgCode = primaryPosition.getOrgCode();
        List userOrgAndParentOrg = OrgUtil.getParentOrgListIncludeSelf((String)userOrgCode);
        Set orgCodes = userOrgAndParentOrg.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toSet());
        Map<String, List<SfaWorkSignPersonnelEntity>> personnelEntitiesGroupByOrgCode = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)iSfaWorkSignPersonnelService.lambdaQuery().in(SfaWorkSignPersonnelEntity::getWspCode, orgCodes)).eq(SfaWorkSignPersonnelEntity::getCodeType, (Object)WorkSignEnum.codeType.ORG.getVal())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list().stream().collect(Collectors.groupingBy(SfaWorkSignPersonnelEntity::getWspCode));
        Map<String, SfaWorkSignRuleEntity> ruleEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)sfaWorkSignRuleService.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list().stream().collect(Collectors.toMap(SfaWorkSignRuleEntity::getRuleCode, v -> v, (t, t2) -> t2));
        return SignRuleUtils.hitUserSignRuleCode(userOrgCode, personnelEntitiesGroupByOrgCode, personnelEntityRuleCodeMappingOfLevelCode, userOrgAndParentOrg, ruleEntityList);
    }

    public static SfaWorkSignRuleInfoEntity buildSfaWorkSignRuleInfoEntity(SfaWorkSignRuleEntity ruleEntity, MdmPositionRespVo primaryPosition, String ruleDate) {
        SfaWorkSignRuleInfoEntity infoEntity = SfaWorkSignRuleInfoEntity.buildRuleInfoEntity(ruleEntity, ruleDate);
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode((String)primaryPosition.getOrgCode());
        infoEntity.setOrgCode(mdmOrgRespVo.getOrgCode());
        infoEntity.setOrgName(mdmOrgRespVo.getOrgName());
        infoEntity.setParentOrgCode(mdmOrgRespVo.getParentCode());
        infoEntity.setParentOrgName(mdmOrgRespVo.getParentName());
        infoEntity.setPosCode(primaryPosition.getPositionCode());
        infoEntity.setPosName(primaryPosition.getPositionName());
        infoEntity.setRealName(primaryPosition.getFullName());
        infoEntity.setUserName(primaryPosition.getUserName());
        return infoEntity;
    }

    public static List<SfaWorkSignRecordEntity> buildSfaWorkSignRecordEntity(SfaWorkSignRuleInfoEntity infoEntity) {
        List sfaWorkSignTimeEntities = ((LambdaQueryChainWrapper)iSfaWorkSignTimeService.lambdaQuery().eq(SfaWorkSignTimeEntity::getRuleCode, (Object)infoEntity.getRuleCode())).list();
        ArrayList recordEntities = Lists.newArrayList();
        for (SfaWorkSignTimeEntity sfaWorkSignTimeEntity : sfaWorkSignTimeEntities) {
            List<SfaWorkSignRecordEntity> temp = SfaWorkSignRecordEntity.buildClockInOut(infoEntity, sfaWorkSignTimeEntity);
            recordEntities.addAll(temp);
        }
        return recordEntities;
    }

    protected static class SignRuleCode {
        private SfaWorkSignRuleEntity hitOfOrgCodeAndLevelCode;
        private SfaWorkSignRuleEntity hitOfOrgCode;

        SignRuleCode(SfaWorkSignRuleEntity hitOfOrgCodeAndLevelCode, SfaWorkSignRuleEntity hitOfOrgCode) {
            this.hitOfOrgCodeAndLevelCode = hitOfOrgCodeAndLevelCode;
            this.hitOfOrgCode = hitOfOrgCode;
        }

        public static SignRuleCodeBuilder builder() {
            return new SignRuleCodeBuilder();
        }

        public SfaWorkSignRuleEntity getHitOfOrgCodeAndLevelCode() {
            return this.hitOfOrgCodeAndLevelCode;
        }

        public SfaWorkSignRuleEntity getHitOfOrgCode() {
            return this.hitOfOrgCode;
        }

        public void setHitOfOrgCodeAndLevelCode(SfaWorkSignRuleEntity hitOfOrgCodeAndLevelCode) {
            this.hitOfOrgCodeAndLevelCode = hitOfOrgCodeAndLevelCode;
        }

        public void setHitOfOrgCode(SfaWorkSignRuleEntity hitOfOrgCode) {
            this.hitOfOrgCode = hitOfOrgCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignRuleCode)) {
                return false;
            }
            SignRuleCode other = (SignRuleCode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SfaWorkSignRuleEntity this$hitOfOrgCodeAndLevelCode = this.getHitOfOrgCodeAndLevelCode();
            SfaWorkSignRuleEntity other$hitOfOrgCodeAndLevelCode = other.getHitOfOrgCodeAndLevelCode();
            if (this$hitOfOrgCodeAndLevelCode == null ? other$hitOfOrgCodeAndLevelCode != null : !((Object)((Object)this$hitOfOrgCodeAndLevelCode)).equals((Object)other$hitOfOrgCodeAndLevelCode)) {
                return false;
            }
            SfaWorkSignRuleEntity this$hitOfOrgCode = this.getHitOfOrgCode();
            SfaWorkSignRuleEntity other$hitOfOrgCode = other.getHitOfOrgCode();
            return !(this$hitOfOrgCode == null ? other$hitOfOrgCode != null : !((Object)((Object)this$hitOfOrgCode)).equals((Object)other$hitOfOrgCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignRuleCode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SfaWorkSignRuleEntity $hitOfOrgCodeAndLevelCode = this.getHitOfOrgCodeAndLevelCode();
            result = result * 59 + ($hitOfOrgCodeAndLevelCode == null ? 43 : ((Object)((Object)$hitOfOrgCodeAndLevelCode)).hashCode());
            SfaWorkSignRuleEntity $hitOfOrgCode = this.getHitOfOrgCode();
            result = result * 59 + ($hitOfOrgCode == null ? 43 : ((Object)((Object)$hitOfOrgCode)).hashCode());
            return result;
        }

        public String toString() {
            return "SignRuleUtils.SignRuleCode(hitOfOrgCodeAndLevelCode=" + (Object)((Object)this.getHitOfOrgCodeAndLevelCode()) + ", hitOfOrgCode=" + (Object)((Object)this.getHitOfOrgCode()) + ")";
        }

        public static class SignRuleCodeBuilder {
            private SfaWorkSignRuleEntity hitOfOrgCodeAndLevelCode;
            private SfaWorkSignRuleEntity hitOfOrgCode;

            SignRuleCodeBuilder() {
            }

            public SignRuleCodeBuilder hitOfOrgCodeAndLevelCode(SfaWorkSignRuleEntity hitOfOrgCodeAndLevelCode) {
                this.hitOfOrgCodeAndLevelCode = hitOfOrgCodeAndLevelCode;
                return this;
            }

            public SignRuleCodeBuilder hitOfOrgCode(SfaWorkSignRuleEntity hitOfOrgCode) {
                this.hitOfOrgCode = hitOfOrgCode;
                return this;
            }

            public SignRuleCode build() {
                return new SignRuleCode(this.hitOfOrgCodeAndLevelCode, this.hitOfOrgCode);
            }

            public String toString() {
                return "SignRuleUtils.SignRuleCode.SignRuleCodeBuilder(hitOfOrgCodeAndLevelCode=" + (Object)((Object)this.hitOfOrgCodeAndLevelCode) + ", hitOfOrgCode=" + (Object)((Object)this.hitOfOrgCode) + ")";
            }
        }
    }
}

