/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.StockInventoryWorkbenchDataReq;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.repositories.SfaVisitStepStockInventoryEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEsData;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryRedisData;
import com.biz.crm.visitstepdetail.service.impl.SfaVisitStepStockInventoryServiceEsImpl;
import com.biz.crm.visitstepdetail.service.impl.SfaVisitStepStockInventoryServiceImpl;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnMissingBean(name={"stockInventoryVisitStepExecutorExpandImpl"})
public class StockInventoryVisitStepExecutor<ExecuteReq extends StockInventoryStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, StockInventoryStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(StockInventoryVisitStepExecutor.class);
    @Resource
    private SfaVisitStepStockInventoryEsDataRepositories sfaVisitStepStockInventoryEsDataRepositories;
    @Resource
    private SfaVisitStepStockInventoryServiceEsImpl sfaVisitStepStockInventoryServiceEsImpl;
    @Resource
    private SfaVisitStepStockInventoryServiceImpl sfaVisitStepStockInventoryService;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return this.sfaVisitStepStockInventoryService;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_STOCK.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepStockInventoryRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        String id = UUIDGenerator.generate();
        visitStepExecuteReq.setRedisHashKey("WORKBENCH");
        this.check(null, visitStepExecuteReq);
        SfaVisitStepStockInventoryRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        StockInventoryWorkbenchDataReq dataReq = (StockInventoryWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        redisData.setId(id);
        redisData.setVisitPlanInfoId(id);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList((Object[])new SfaVisitStepStockInventoryRedisData[]{redisData}), fromRespVo);
    }

    protected SfaVisitStepStockInventoryRedisData buildRedisData(VisitStepExecuteReq<? extends StockInventoryStepExecuteData> visitStepExecuteReq) {
        StockInventoryStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData)CrmBeanUtil.copy((Object)executeData, SfaVisitStepStockInventoryRedisData.class);
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setVisitStepStockList(executeData.getVisitStepStockList());
        redisData.setStockTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setStockDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        redisData.setStockYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        redisData.setStockYear(LocalDateTime.now().format(CrmDateUtils.yyyy));
        return redisData;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepStockInventoryRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        this.buildClientData(redisData, sfaVisitPlanInfoEntity.getClientCode(), sfaVisitPlanInfoEntity.getClientType());
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getRealname());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        StockInventoryStepExecuteData stepExecuteData = (StockInventoryStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getStockAddress())) {
            throw new BusinessException("\u5730\u5740\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getLatitude())) {
            throw new BusinessException("\u7ef4\u5ea6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getLongitude())) {
            throw new BusinessException("\u7ecf\u5ea6\u4e3a\u7a7a");
        }
        List<StockInventoryStepExecuteData.StockDetailReqVo> visitStepStockList = stepExecuteData.getVisitStepStockList();
        if (CollectionUtils.isEmpty(visitStepStockList)) {
            throw new BusinessException("\u76d8\u70b9\u660e\u7ec6\u4e3a\u7a7a");
        }
        for (StockInventoryStepExecuteData.StockDetailReqVo stockDetailReqVo : visitStepStockList) {
            if (StringUtils.isBlank((CharSequence)stockDetailReqVo.getProductLevelCode())) {
                throw new BusinessException("\u7cfb\u5217\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)stockDetailReqVo.getProductLevelName())) {
                throw new BusinessException("\u7cfb\u5217\u540d\u79f0\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)stockDetailReqVo.getProductCode())) {
                throw new BusinessException("\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)stockDetailReqVo.getProductName())) {
                throw new BusinessException("\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)stockDetailReqVo.getSaleUnit())) {
                throw new BusinessException("\u5355\u4f4d\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)stockDetailReqVo.getSaleUnitName())) {
                throw new BusinessException("\u5355\u4f4d\u540d\u79f0\u4e3a\u7a7a");
            }
            if (null != stockDetailReqVo.getQuantity()) continue;
            throw new BusinessException("\u4ea7\u54c1\u6570\u91cf\u4e3a\u7a7a");
        }
    }

    @Override
    protected StockInventoryStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData)this.redisService.hmget(SfaVisitStepStockInventoryRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey());
        if (null == redisData) {
            redisData = new SfaVisitStepStockInventoryRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setVisitStepStockList(list);
                }
            };
        }
        StockInventoryStepExecuteDataResp dataResp = (StockInventoryStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, StockInventoryStepExecuteDataResp.class);
        dataResp.setVisitStepStockList(redisData.getVisitStepStockList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        SfaVisitStepStockInventoryEsData esData = this.sfaVisitStepStockInventoryEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional optional = this.sfaVisitStepStockInventoryEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (StepExecuteDataResp)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
    }

    @Override
    protected StockInventoryStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (StringUtils.isNotBlank((CharSequence)visitPlanInfoId)) {
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            SfaVisitStepStockInventoryEsData redisData = (SfaVisitStepStockInventoryEsData)this.getEsDataByVisitPlanInfo(visitPlanInfoId, loadParam.getStepCode());
            return this.buildDataResp(redisData);
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            StockInventoryStepExecuteDataResp dataResp = new StockInventoryStepExecuteDataResp(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setVisitStepStockList(list);
                }
            };
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        }
        SfaVisitStepStockInventoryEsData esData = (SfaVisitStepStockInventoryEsData)this.getEsDataById(bizId);
        return this.buildDataResp(esData);
    }

    private StockInventoryStepExecuteDataResp buildDataResp(SfaVisitStepStockInventoryEsData esData) {
        if (null == esData) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
        }
        StockInventoryStepExecuteDataResp dataResp = (StockInventoryStepExecuteDataResp)CrmBeanUtil.copy((Object)esData, StockInventoryStepExecuteDataResp.class);
        dataResp.setVisitStepStockList(esData.getVisitStepStockList());
        dataResp.setSfaVisitStepFrom(esData.getSfaVisitStepFrom());
        return dataResp;
    }

    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData)this.redisService.hmget(SfaVisitStepStockInventoryRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), (Object)loadParam.getRedisHashKey());
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)loadParam)));
            return null;
        }
        return Lists.newArrayList((Object[])new SfaVisitStepStockInventoryRedisData[]{redisData});
    }
}

