/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BusinessException;
import com.biz.crm.calculatesalary.service.ISfaCalculateSalaryDateService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkOvertimeListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkOvertimeReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListOvertimeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkOvertimeRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.SfaActivitiUtils;
import com.biz.crm.util.SfaSignUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaWorkOvertimeMapper;
import com.biz.crm.worksign.model.SfaLeaveEntity;
import com.biz.crm.worksign.model.SfaWorkOvertimeEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeTimeInfoService;
import com.biz.crm.worksignrule.service.impl.SfaWorkSignRuleServiceImpl;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"sfaWorkOvertimeServiceExpandImpl"})
public class SfaWorkOvertimeServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkOvertimeMapper, SfaWorkOvertimeEntity>
implements ISfaWorkOvertimeService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkOvertimeServiceImpl.class);
    @Resource
    private SfaWorkOvertimeMapper mapper;
    @Autowired
    private ISfaWorkOvertimeTimeInfoService overtimeTimeInfoService;
    @Autowired
    private SfaWorkSignRuleServiceImpl signRuleService;
    @Autowired
    private TaActBaseFeign taActBaseFeign;
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private ISfaSignFormsService formsService;
    @Autowired
    private ISfaLeaveService leaveService;
    @Autowired
    private ISfaCalculateSalaryDateService dateService;

    @Override
    public PageResult<SfaWorkOvertimeRespVo> findList(SfaWorkOvertimeListReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkOvertimeRespVo> list = this.mapper.findList((Page<SfaWorkOvertimeRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> vo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkOvertimeRespVo query(String id) {
        SfaWorkOvertimeListReqVo reqVo = new SfaWorkOvertimeListReqVo();
        reqVo.setId(id);
        PageResult<SfaWorkOvertimeRespVo> result = this.findList(reqVo);
        if (result == null || result.getCount() != 1L) {
            throw new BusinessException("id\u9519\u8bef");
        }
        return (SfaWorkOvertimeRespVo)result.getData().get(0);
    }

    @Override
    public SfaWorkOvertimeRespVo queryByAuditTaskId(String auditTaskId) {
        SfaWorkOvertimeListReqVo reqVo = new SfaWorkOvertimeListReqVo();
        reqVo.setAuditTaskIdList(Arrays.asList(auditTaskId));
        PageResult<SfaWorkOvertimeRespVo> result = this.findList(reqVo);
        if (result == null || result.getCount() != 1L) {
            throw new BusinessException("\u5ba1\u6838\u4efb\u52a1ID\u9519\u8bef");
        }
        return (SfaWorkOvertimeRespVo)result.getData().get(0);
    }

    @Override
    @Transactional(readOnly=true)
    public boolean hasOvertime(SfaWorkSignRuleInfoEntity workSignRuleInfoEntity) {
        List entities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaWorkOvertimeEntity::getUserName, (Object)workSignRuleInfoEntity.getUserName())).in(SfaWorkOvertimeEntity::getBpmStatus, (Collection)Lists.newArrayList((Object[])new String[]{SfaCommonEnum.dataBpmStatus.COMMIT.getValue(), SfaCommonEnum.dataBpmStatus.APPROVAL.getValue(), SfaCommonEnum.dataBpmStatus.PASS.getValue()}))).le(SfaWorkOvertimeEntity::getBeginTime, (Object)workSignRuleInfoEntity.getRuleDate())).ge(SfaWorkOvertimeEntity::getEndTime, (Object)workSignRuleInfoEntity.getRuleDate())).list();
        return !CollectionUtils.isEmpty((Collection)entities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result apply(SfaWorkOvertimeReqVo reqVo) {
        UserRedis userRedis;
        Result result = new Result();
        SfaWorkOvertimeEntity entity = (SfaWorkOvertimeEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkOvertimeEntity.class));
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            SfaWorkOvertimeEntity old = (SfaWorkOvertimeEntity)((Object)this.mapper.selectById((Serializable)((Object)reqVo.getId())));
            if (old == null) {
                return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
            }
            if (SfaCommonEnum.dataBpmStatus.REJECT.getValue().equals(old.getBpmStatus())) {
                entity.setId(null);
            } else if (SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue().equals(old.getBpmStatus())) {
                entity.setId(old.getId());
            } else {
                return Result.error((String)"\u8be5\u7533\u8bf7\u4e0d\u652f\u6301\u7f16\u8f91");
            }
        }
        if (null == (userRedis = UserUtils.getUser()) || StringUtil.isEmpty((String)userRedis.getUsername())) {
            result.error401("\u8bf7\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        if (StringUtils.isEmpty((String)entity.getUserName())) {
            entity.setUserName(userRedis.getUsername());
        }
        MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo = this.formsService.getUserOrgInfo(entity.getUserName());
        entity.setRealName(mdmPositionUserOrgRespVo.getFullName());
        entity.setPosCode(mdmPositionUserOrgRespVo.getPositionCode());
        entity.setPosName(mdmPositionUserOrgRespVo.getPositionName());
        String orgCode = mdmPositionUserOrgRespVo.getOrgCode();
        entity.setOrgCode(orgCode);
        entity.setOrgName(mdmPositionUserOrgRespVo.getOrgName());
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode((String)orgCode);
        if (null != mdmOrgRespVo) {
            entity.setParentOrgCode(mdmOrgRespVo.getParentCode());
            entity.setParentOrgName(mdmOrgRespVo.getParentName());
        }
        if (StringUtils.isEmpty((String)entity.getUserName()) || StringUtil.isEmpty((String)entity.getRealName()) || StringUtil.isEmpty((String)entity.getPosCode()) || StringUtil.isEmpty((String)entity.getOrgCode())) {
            return Result.error((String)"\u7533\u8bf7\u4eba\u5458\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u4ee5\u4e0b\u4fe1\u606f\uff1a\u4eba\u5458\u8d26\u53f7\u3001\u4eba\u5458\u59d3\u540d\u3001\u5c97\u4f4d\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\uff0c\u8bf7\u6838\u5bf9");
        }
        SfaSignUtils.verifyApply((String)entity.getBeginTime(), (String)entity.getEndTime(), (List)reqVo.getTimeInfoList(), (String)entity.getOvertimeDuration());
        SfaWorkSignRuleRespVo ruleRespVo = this.signRuleService.getSignRuleByOrgCode(entity.getOrgCode());
        String overtimeType = ActivitiEnum.SfaOvertimeSmallTypeEnum.NORMAL.getVal();
        for (Object timeInfo : SfaSignUtils.fillTimeInfoAndCheck((List)reqVo.getTimeInfoList(), (String)entity.getBeginTime(), (String)entity.getEndTime())) {
            String workType = SfaSignUtils.isWorkDay((SfaWorkSignRuleRespVo)ruleRespVo, (String)timeInfo.getTimeStr(), this.dateService.findHolidayByDate(timeInfo.getTimeStr()));
            if (YesNoEnum.yesNoEnum.ZERO.getValue().equals(workType)) {
                return Result.error((String)("\u65e5\u671f\u4e0d\u80fd\u8c03\u6574-\u5de5\u4f5c\u65e5\uff1a" + timeInfo.getTimeStr()));
            }
            if (!YesNoEnum.yesNoEnum.THREE.getValue().equals(workType)) continue;
            overtimeType = ActivitiEnum.SfaOvertimeSmallTypeEnum.LEGAL.getVal();
        }
        entity.setOvertimeType(overtimeType);
        List<SfaWorkOvertimeRespVo> repeatList = this.mapper.findRepeatByDates(entity.getUserName(), entity.getBeginTime(), entity.getEndTime(), entity.getId());
        if (repeatList != null && repeatList.size() > 0) {
            for (SfaWorkOvertimeRespVo vo : repeatList) {
                SfaSignUtils.verifyDateRepeat((String)entity.getBeginTime(), (String)entity.getEndTime(), (String)vo.getBeginTime(), (String)vo.getEndTime(), (List)reqVo.getTimeInfoList(), (List)JSON.parseArray((String)vo.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class));
            }
        }
        entity.setTimeInfoListJson(JSON.toJSONString((Object)reqVo.getTimeInfoList()));
        entity.setApplicationDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        this.saveOrUpdate((Object)entity);
        entity.setAuditTaskId(entity.getId());
        StartProcessReqVo startProcessReqVO = SfaActivitiUtils.createStartProcessReqVO((String)entity.getUserName(), (String)entity.getPosCode(), (String)entity.getAuditTaskId(), (ActivitiEnum.FormTypeEnum)ActivitiEnum.FormTypeEnum.OVERTIME, (String)entity.getBeginTime(), (String)entity.getEndTime(), (String)entity.getOrgCode());
        String isHoliday = YesNoEnum.yesNoEnum.NO.getValue();
        if (ActivitiEnum.SfaOvertimeSmallTypeEnum.LEGAL.getVal().equals(entity.getOvertimeType())) {
            isHoliday = YesNoEnum.yesNoEnum.YES.getValue();
        }
        startProcessReqVO.getVariables().put("isHoliday", isHoliday);
        result = this.taActBaseFeign.startProcess(startProcessReqVO);
        if (!result.isSuccess()) {
            return result;
        }
        this.saveOrUpdate((Object)entity);
        return result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result rollback(String id) {
        SfaWorkOvertimeEntity entity = (SfaWorkOvertimeEntity)((Object)this.mapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!SfaCommonEnum.dataBpmStatus.COMMIT.getValue().equals(entity.getBpmStatus())) {
            return Result.error((String)"\u5f53\u524d\u7533\u8bf7\u4e0d\u80fd\u8ffd\u56de");
        }
        CancelProcessReqVO reqVO = new CancelProcessReqVO(entity.getAuditTaskId(), UserUtils.getUser().getUsername(), ActivitiEnum.FormTypeEnum.OVERTIME.getCostType(), ActivitiEnum.getFormType());
        Result result = this.mobileFeign.cancelProcess(reqVO);
        if (!result.isSuccess()) {
            return result;
        }
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue());
        this.saveOrUpdate((Object)entity);
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result auditCommit(String id) {
        SfaWorkOvertimeEntity entity = (SfaWorkOvertimeEntity)((Object)this.mapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
        }
        if (!entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.COMMIT.getValue()) && !entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue())) {
            return Result.error((String)"\u8be5\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u9519\u8bef");
        }
        if (!SfaCommonEnum.dataBpmStatus.APPROVAL.getValue().equals(entity.getBpmStatus())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue());
            this.saveOrUpdate((Object)entity);
        }
        return Result.ok();
    }

    @Override
    public PageResult<SfaAuditListOvertimeRespVo> findAuditList(PageResult<TaskRspVO> taskRspVOPageResult, SfaWorkOvertimeListReqVo reqVo) {
        if (taskRspVOPageResult != null && taskRspVOPageResult.getCount() > 0L) {
            Map<String, TaskRspVO> taskMap = taskRspVOPageResult.getData().stream().collect(Collectors.toMap(TaskRspVO::getFormNo, vo -> vo, (key1, key2) -> key2));
            reqVo.setAuditTaskIdList(new ArrayList<String>(taskMap.keySet()));
            PageResult<SfaWorkOvertimeRespVo> pageResult = this.findList(reqVo);
            if (pageResult.getCount() > 0L) {
                List data = pageResult.getData().stream().sorted((x, y) -> CrmDateUtils.parseyyyyMMddHHmmss((String)y.getApplicationDate()).compareTo(CrmDateUtils.parseyyyyMMddHHmmss((String)x.getApplicationDate()))).collect(Collectors.toList());
                pageResult.setData(data);
                ArrayList list = new ArrayList();
                pageResult.getData().forEach(vo -> list.add(new SfaAuditListOvertimeRespVo(vo, (TaskRspVO)taskMap.get(vo.getAuditTaskId()))));
                return PageResult.builder().data(list).count(pageResult.getCount()).build();
            }
        }
        return PageResult.builder().data(null).count(Long.valueOf(0L)).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditFinish(SfaAuditFinishReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkOvertimeEntity::getAuditTaskId, (Object)reqVo.getFormId());
        SfaWorkOvertimeEntity entity = (SfaWorkOvertimeEntity)((Object)this.mapper.selectOne((Wrapper)wrapper));
        if (ActivitiEnum.AuditResultType.PASS.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.PASS.getValue());
            entity.setPassStatusDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
            this.overtimeTimeInfoService.saveTimeInfo(entity);
            BigDecimal holidayDays = new BigDecimal(0);
            List timeInfoList = SfaSignUtils.fillTimeInfoAndCheck((List)JSON.parseArray((String)entity.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class), (String)entity.getBeginTime(), (String)entity.getEndTime());
            for (SfaApplyTimeInfoReqVo vo : timeInfoList) {
                if (!this.dateService.isCalculateSalary(vo.getTimeStr())) continue;
                if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(vo.getTimeType())) {
                    holidayDays = holidayDays.add(new BigDecimal(1));
                    continue;
                }
                holidayDays = holidayDays.add(new BigDecimal(0.5));
            }
            BigDecimal lastDays = new BigDecimal(entity.getOvertimeDuration()).subtract(holidayDays);
            List<SfaLeaveEntity> leaveList = this.leaveService.findNotUseDaysList(entity.getUserName());
            if (leaveList != null && lastDays.compareTo(BigDecimal.ZERO) > 0) {
                for (SfaLeaveEntity leaveEntity : leaveList) {
                    BigDecimal days = lastDays.subtract(leaveEntity.getLastDays());
                    days = days.compareTo(BigDecimal.ZERO) > 0 ? leaveEntity.getLastDays() : lastDays;
                    lastDays = lastDays.subtract(leaveEntity.getLastDays());
                    leaveEntity.setUseDeductionIds(SfaSignUtils.addDeductionIds((String)leaveEntity.getUseDeductionIds(), (String)entity.getId(), (BigDecimal)days));
                    leaveEntity.setUseDays(leaveEntity.getUseDays().add(days));
                    leaveEntity.setLastDays(leaveEntity.getLastDays().subtract(days));
                    this.leaveService.saveOrUpdate((Object)leaveEntity);
                    entity.setUseDeductionIds(SfaSignUtils.addDeductionIds((String)entity.getUseDeductionIds(), (String)leaveEntity.getId(), (BigDecimal)days));
                    if (lastDays.compareTo(BigDecimal.ZERO) > 0) continue;
                    break;
                }
            }
            entity.setLastDays(lastDays);
            entity.setUseDays(new BigDecimal(entity.getOvertimeDuration()).subtract(holidayDays).subtract(lastDays));
            entity.setHolidayDays(holidayDays);
        } else if (ActivitiEnum.AuditResultType.REJECT.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.REJECT.getValue());
        } else if (ActivitiEnum.AuditResultType.RECOVER.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue());
        } else {
            throw new BusinessException("\u5ba1\u6279\u5931\u8d25");
        }
        this.saveOrUpdate((Object)entity);
    }

    @Override
    public int getOvertimeIndate() {
        Map map = DictUtil.getDictValueMapsByCodes((String)SfaWorkSignEnum.SignRuleIndateKey.SIGN_RULE_INDATE.getVal());
        if (map != null && map.get(SfaWorkSignEnum.SignRuleIndateKey.OVERTIME_INDATE.getVal()) != null) {
            try {
                return Integer.parseInt((String)map.get(SfaWorkSignEnum.SignRuleIndateKey.OVERTIME_INDATE.getVal()));
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u5b57\u5178" + SfaWorkSignEnum.SignRuleIndateKey.SIGN_RULE_INDATE.getVal() + "\u914d\u7f6e\u9519\u8bef");
            }
        }
        return 0;
    }

    @Override
    public List<SfaWorkOvertimeEntity> findNotUseDaysList(String userName) {
        return this.mapper.findNotUseDays(userName, this.getOvertimeIndate());
    }
}

