/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JobHelper;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageDataAdviser;
import com.biz.crm.util.Result;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.req.PlanInfoSettlementReq;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VisitPlanInfoHelper {
    private static final Logger log = LoggerFactory.getLogger(VisitPlanInfoHelper.class);
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    private RedisService redisService;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private JobHelper jobHelper;
    @Resource
    private RocketMQProducer rocketMQProducer;

    public void planInfoSettlementJob(String visitDateTemp, Boolean compulsive) {
        if (StringUtils.isBlank((CharSequence)visitDateTemp)) {
            visitDateTemp = LocalDate.now().plusDays(-1L).format(CrmDateUtils.yyyyMMdd);
        }
        String visitDate = visitDateTemp;
        JobHelper.JobContext context = new JobHelper.JobContext();
        context.setCompulsive(compulsive);
        context.setJobTime(visitDate);
        context.setJob(JobHelper.Job.PLAN_INFO_SETTLEMENT_JOB);
        context.setExecutor(() -> this.doPlanInfoSettlementJob(visitDate));
        this.jobHelper.executeJob(context);
    }

    private void doPlanInfoSettlementJob(String visitDate) {
        PageDataAdviser pageDataAdviser = new PageDataAdviser(this.jobHelper.getJobBizDataPageSize());
        long total = this.jobHelper.getJobBizDataPageSize();
        while (pageDataAdviser.hasNext(Long.valueOf(total))) {
            MdmPositionPageReqVo reqVo = new MdmPositionPageReqVo();
            reqVo.setPageNum(pageDataAdviser.nextPage());
            reqVo.setPageSize(pageDataAdviser.getPageSize());
            PageResult pageResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmPositionFeign.positionAndUserPage(reqVo), (boolean)true);
            List users = pageResult.getData();
            this.sendMq(users, visitDate);
            total = pageResult.getCount();
        }
    }

    private void sendMq(List<MdmPositionPageRespVo> users, String visitDate) {
        RocketMQMessageBody mqMessageBody = new RocketMQMessageBody();
        for (MdmPositionPageRespVo mdmPositionPageRespVo : users) {
            PlanInfoSettlementReq settlementReq = new PlanInfoSettlementReq();
            settlementReq.setVisitDate(visitDate);
            String visitUserName = mdmPositionPageRespVo.getUserName();
            String visitPositionCode = mdmPositionPageRespVo.getPositionCode();
            if (StringUtils.isBlank((CharSequence)visitPositionCode) || StringUtils.isBlank((CharSequence)visitUserName)) continue;
            settlementReq.setVisitPositionCode(visitPositionCode);
            settlementReq.setVisitUserName(visitUserName);
            mqMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)settlementReq));
            mqMessageBody.setTag("VISIT_PLAN_INFO_SETTLEMENT");
            this.rocketMQProducer.convertAndSend(mqMessageBody);
        }
    }

    public void planInfoSettlementForWeb(PlanInfoSettlementReq req) {
        this.planInfoSettlement(req);
    }

    public void planInfoSettlementForJob(PlanInfoSettlementReq req) {
        this.planInfoSettlement(req);
    }

    public void planInfoSettlement(PlanInfoSettlementReq req) {
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.loadUserVisitPlan(req);
        for (SfaVisitPlanInfoEntity planInfoEntity : planInfoEntities) {
            SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = null;
            if (this.hasRedisData(planInfoEntity)) {
                sfaVisitPlanInfoRedisData = (SfaVisitPlanInfoRedisData)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), (Object)planInfoEntity.getRedisHashKey());
            }
            this.sfaVisitPlanInfoService.dataDurability(planInfoEntity, sfaVisitPlanInfoRedisData);
            this.redisService.hmset(planInfoEntity.redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), planInfoEntity.buildRedisDataForWrite(), 1296000L);
            if (null == sfaVisitPlanInfoRedisData) continue;
            this.redisService.hmset(sfaVisitPlanInfoRedisData.redisHash(planInfoEntity.getVisitDate(), planInfoEntity.getVisitUserName(), planInfoEntity.getVisitPosCode(), planInfoEntity.getVisitBigType()).toString(), sfaVisitPlanInfoRedisData.buildRedisDataForWrite(), 1296000L);
        }
    }

    private boolean hasRedisData(SfaVisitPlanInfoEntity planInfoEntity) {
        return SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(planInfoEntity.getVisitBigType()) ? SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(planInfoEntity.getVisitStatus()) : SfaVisitEnum.visitStatus.V5.getVal().equals(planInfoEntity.getVisitStatus());
    }

    private List<SfaVisitPlanInfoEntity> loadUserVisitPlan(PlanInfoSettlementReq settlementReq) {
        GetVisitListReq req = (GetVisitListReq)CrmBeanUtil.copy((Object)settlementReq, GetVisitListReq.class);
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        List<SfaVisitPlanInfoEntity> planInfoTemps = this.sfaVisitPlanInfoService.doGetVisitInfoList(req);
        req.setVisitBigType(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
        planInfoTemps.addAll(this.sfaVisitPlanInfoService.doGetVisitInfoList(req));
        req.setVisitBigType(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal());
        planInfoTemps.addAll(this.sfaVisitPlanInfoService.doGetVisitInfoList(req));
        List<SfaVisitPlanInfoEntity> planInfoEntities = planInfoTemps.stream().filter(v -> {
            if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(v.getVisitBigType())) {
                if (SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal());
                    v.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getDesc());
                    return true;
                }
                if (SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal());
                    v.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getDesc());
                    v.setRemarks("\u8be5\u7528\u6237\u5728\u6267\u884c\u4e1a\u52a1\u65f6\u672a\u4e3b\u52a8\u63d0\u4ea4\u6267\u884c\u6570\u636e\uff08\u4efb\u52a1/\u540e\u53f0\u6279\u91cf\u7ed3\u7b97\uff09");
                    return true;
                }
            } else {
                if (SfaVisitEnum.visitStatus.V1.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.visitStatus.V6.getVal());
                    v.setVisitStatusName(SfaVisitEnum.visitStatus.V6.getDesc());
                    return true;
                }
                if (SfaVisitEnum.visitStatus.V2.getVal().equals(v.getVisitStatus())) {
                    v.setVisitStatus(SfaVisitEnum.visitStatus.V5.getVal());
                    v.setVisitStatusName(SfaVisitEnum.visitStatus.V5.getDesc());
                    v.setRemarks("\u8be5\u7528\u6237\u5728\u6267\u884c\u4e1a\u52a1\u65f6\u672a\u4e3b\u52a8\u63d0\u4ea4\u6267\u884c\u6570\u636e\uff08\u4efb\u52a1/\u540e\u53f0\u6279\u91cf\u7ed3\u7b97\uff09");
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        return planInfoEntities;
    }

    public Map<String, Map<String, SfaVisitPlanInfoEntity>> flushCounting(Map<String, Map<String, SfaVisitPlanInfoEntity>> daysPlanInfoTemp) {
        HashMap needDelete = Maps.newHashMap();
        for (Map.Entry<String, Map<String, SfaVisitPlanInfoEntity>> entry : daysPlanInfoTemp.entrySet()) {
            String redisHash = entry.getKey();
            Map oldPlan = this.redisService.hmget(redisHash);
            if (null == oldPlan) continue;
            Map needDeletePlanInfos = (Map)needDelete.get(redisHash);
            if (null == needDeletePlanInfos) {
                needDeletePlanInfos = Maps.newHashMap();
            }
            Map<String, SfaVisitPlanInfoEntity> newPlan = entry.getValue();
            Collection oldValues = oldPlan.values();
            for (SfaVisitPlanInfoEntity oldValue : oldValues) {
                String oldValueRedisHashKey = oldValue.getRedisHashKey();
                if (!SfaVisitEnum.visitStatus.V1.getVal().equals(oldValue.getVisitStatus())) {
                    newPlan.remove(oldValueRedisHashKey);
                    continue;
                }
                if (SfaVisitEnum.visitType.TEMP_VISIT.getVal().equals(oldValue.getVisitType())) {
                    if (!newPlan.containsKey(oldValueRedisHashKey)) continue;
                    needDeletePlanInfos.put(oldValueRedisHashKey, oldValue);
                    continue;
                }
                if (newPlan.containsKey(oldValueRedisHashKey)) {
                    newPlan.remove(oldValueRedisHashKey);
                    continue;
                }
                needDeletePlanInfos.put(oldValueRedisHashKey, oldValue);
            }
            needDelete.put(redisHash, needDeletePlanInfos);
        }
        return needDelete;
    }
}

