/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstepdetail.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockInventoryRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitstep.repositories.SfaVisitStepStockInventoryEsDataRepositories;
import com.biz.crm.visitstep.req.GetStockInventoryPageReq;
import com.biz.crm.visitstep.req.GetStockInventoryTableReq;
import com.biz.crm.visitstepdetail.mapper.SfaVisitStepStockInventoryMapper;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockDetailEntity;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEsData;
import com.biz.crm.visitstepdetail.model.resp.SfaVisitStepStockInventoryTableDetailRespVo;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockDetailService;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class SfaVisitStepStockInventoryServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepStockInventoryServiceEsImpl.class);
    @Resource
    private SfaVisitStepStockInventoryEsDataRepositories sfaVisitStepStockInventoryEsDataRepositories;
    @Resource
    private SfaVisitStepStockInventoryMapper sfaVisitStepStockInventoryMapper;
    @Resource
    private ISfaVisitStepStockDetailService sfaVisitStepStockDetailService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public PageResult<SfaVisitStepStockInventoryRespVo> getWorkbenchStockInventoryPage(GetStockInventoryPageReq req) {
        Page page = PageUtil.buildPage((Integer)req.getPageNum(), (Integer)req.getPageSize());
        List<SfaVisitStepStockInventoryRespVo> list = this.sfaVisitStepStockInventoryMapper.findStockInventoryReportListByClientCode((Page<SfaVisitStepStockInventoryRespVo>)page, req.getClientCode());
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    public SfaVisitStepStockInventoryEsData getLastTimeRecord(String stepCode, String clientCode, LocalDateTime stockTime, String currentId) {
        if (StringUtils.isBlank((CharSequence)stepCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        if (StringUtils.isBlank((CharSequence)clientCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u7f16\u7801");
        }
        if (null == stockTime) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6267\u884c\u65f6\u95f4");
        }
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"stepCode.keyword", (String)stepCode));
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode.keyword", (String)clientCode));
        builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"stockTime").lte((Object)stockTime.format(CrmDateUtils.yyyyMMddHHmmss)));
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)0, (int)2));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"stockTime").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        List list = this.sfaVisitStepStockInventoryEsDataRepositories.search((SearchQuery)query).getContent();
        if (list.size() > 0) {
            SfaVisitStepStockInventoryEsData data;
            SfaVisitStepStockInventoryEsData dataCurrent = (SfaVisitStepStockInventoryEsData)list.get(0);
            SfaVisitStepStockInventoryEsData sfaVisitStepStockInventoryEsData = data = list.size() > 1 ? (SfaVisitStepStockInventoryEsData)list.get(1) : null;
            if (dataCurrent.getId().equals(currentId)) {
                return data;
            }
            return dataCurrent;
        }
        return null;
    }

    protected SearchRequest buildQuery(GetStockInventoryTableReq req) {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isBlank((CharSequence)req.getStepCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"stepCode.keyword", (String)req.getStepCode()));
        if (StringUtils.isNotEmpty((CharSequence)req.getClientCode())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode.keyword", (String)req.getClientCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getClientName())) {
            builder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"clientName", (Object)req.getClientName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getClientType())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientType.keyword", (String)req.getClientType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getRealName())) {
            builder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"realName", (Object)req.getRealName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getProductCode())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"productCode.keyword", (String)req.getProductCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getProductName())) {
            builder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"productName", (Object)req.getProductName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getStockTime())) {
            builder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"stockTime", (Object)req.getStockTime()));
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getUserName())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"userName", (String)req.getUserName()));
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{"sfa_visit_step_stock_inventory_es_data"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)builder);
        searchSourceBuilder.collapse(new CollapseBuilder("clientCode.keyword"));
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"count").field("clientCode.keyword"));
        searchSourceBuilder.from(req.getPageNum() - 1);
        searchSourceBuilder.size(req.getPageSize().intValue());
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchSourceBuilder.sort(SortBuilders.fieldSort((String)"stockTime").order(SortOrder.DESC));
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    protected Long getTotal(SearchResponse searchResponse) {
        Aggregation agg = searchResponse.getAggregations().get("count");
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)agg), Map.class);
        if (null == map) {
            return 0L;
        }
        Integer value = (Integer)map.get("value");
        return (long)value;
    }

    @EsDataPermission(userName="userName.keyword", position="posCode.keyword", org="orgCode.keyword", customer="clientCode.keyword")
    public PageResult<SfaVisitStepStockInventoryRespVo> findStockInventoryReportList(GetStockInventoryTableReq req) {
        Page page = PageUtil.buildPage((Integer)req.getPageNum(), (Integer)req.getPageSize());
        List<SfaVisitStepStockInventoryRespVo> list = this.sfaVisitStepStockInventoryMapper.findStockInventoryReportList((Page<SfaVisitStepStockInventoryRespVo>)page, req);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private SfaVisitStepStockInventoryRespVo countData(SfaVisitStepStockInventoryEsData req, String stepCode) {
        SfaVisitStepStockInventoryRespVo sfaVisitStepStockInventoryRespVo = (SfaVisitStepStockInventoryRespVo)CrmBeanUtil.copy((Object)req, SfaVisitStepStockInventoryRespVo.class);
        sfaVisitStepStockInventoryRespVo.setLastStockTime(req.getLastTime());
        return sfaVisitStepStockInventoryRespVo;
    }

    private SfaVisitStepStockInventoryTableDetailRespVo getStockDetailNum(List<StockInventoryStepExecuteData.StockDetailReqVo> stockList) {
        int stockNum = 0;
        long typeNum = 0L;
        long seriesNum = 0L;
        if (CollectionUtil.listNotEmpty(stockList)) {
            stockNum = stockList.stream().mapToInt(StockInventoryStepExecuteData.StockDetailReqVo::getQuantity).sum();
            typeNum = stockList.stream().map(StockInventoryStepExecuteData.StockDetailReqVo::getProductCode).count();
            seriesNum = stockList.stream().map(StockInventoryStepExecuteData.StockDetailReqVo::getProductLevelCode).count();
        }
        SfaVisitStepStockInventoryTableDetailRespVo respVo = new SfaVisitStepStockInventoryTableDetailRespVo();
        respVo.setStockNum(stockNum).setTypeNum(String.valueOf(typeNum)).setSeriesNum(String.valueOf(seriesNum));
        return respVo;
    }

    public PageResult<SfaVisitStepStockInventoryTableDetailRespVo> findStockInventoryReportDetail(GetStockInventoryPageReq req) {
        if (StringUtils.isBlank((CharSequence)req.getClientCode())) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        }
        Page page = PageUtil.buildPage((Integer)req.getPageNum(), (Integer)req.getPageSize());
        List<SfaVisitStepStockInventoryRespVo> list = this.sfaVisitStepStockInventoryMapper.findStockInventoryReportListByClientCode((Page<SfaVisitStepStockInventoryRespVo>)page, req.getClientCode());
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List result = CrmBeanUtil.copyList(list, SfaVisitStepStockInventoryTableDetailRespVo.class);
            List idList = list.stream().map(UuidVo::getId).collect(Collectors.toList());
            List detailEntityList = ((LambdaQueryChainWrapper)this.sfaVisitStepStockDetailService.lambdaQuery().in(SfaVisitStepStockDetailEntity::getStockInventoryId, idList)).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)detailEntityList)) {
                Map<String, List<SfaVisitStepStockDetailEntity>> map = detailEntityList.stream().collect(Collectors.groupingBy(SfaVisitStepStockDetailEntity::getStockInventoryId));
                result.forEach(o -> {
                    o.setVisitStepStockList(CrmBeanUtil.copyList((List)((List)map.get(o.getId())), StockInventoryStepExecuteData.StockDetailReqVo.class));
                    SfaVisitStepStockInventoryTableDetailRespVo stockDetailNum = this.getStockDetailNum(o.getVisitStepStockList());
                    o.setStockNum(stockDetailNum.getStockNum());
                    o.setTypeNum(String.valueOf(stockDetailNum.getTypeNum()));
                    o.setSeriesNum(String.valueOf(stockDetailNum.getSeriesNum()));
                });
            }
            return PageResult.builder().data(result).count(Long.valueOf(page.getTotal())).build();
        }
        return PageResult.builder().data((List)Lists.newArrayList()).count(Long.valueOf(page.getTotal())).build();
    }
}

