/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.mapper.SfaCustomerBusinessDetailMapper;
import com.biz.crm.customer.model.SfaCustomerBusinessDetailEntity;
import com.biz.crm.customer.service.SfaCustomerBusinessDetailService;
import com.biz.crm.nebular.sfa.customer.req.SfaCustomerBusinessDetailReqVo;
import com.biz.crm.nebular.sfa.customer.resp.SfaCustomerBusinessDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.stereotype.Service;

@Service
public class SfaCustomerBusinessDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaCustomerBusinessDetailMapper, SfaCustomerBusinessDetailEntity>
implements SfaCustomerBusinessDetailService {
    private static final Logger log = LoggerFactory.getLogger(SfaCustomerBusinessDetailServiceImpl.class);
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private SfaCustomerBusinessDetailMapper sfaCustomerBusinessDetailMapper;

    @Override
    public PageResult<SfaCustomerBusinessDetailRespVo> findList(SfaCustomerBusinessDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaCustomerBusinessDetailRespVo> list = this.sfaCustomerBusinessDetailMapper.findList((Page<SfaCustomerBusinessDetailRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void save(SfaCustomerBusinessDetailReqVo reqVo) {
        this.deCheck(reqVo);
        SfaCustomerBusinessDetailEntity entity = (SfaCustomerBusinessDetailEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaCustomerBusinessDetailEntity.class));
        this.save((Object)entity);
    }

    @Override
    public void saveList(List<SfaCustomerBusinessDetailReqVo> reqVo) {
        if (CollectionUtil.listNotEmpty(reqVo)) {
            reqVo.forEach(this::deCheck);
            List entity = CrmBeanUtil.copyList(reqVo, SfaCustomerBusinessDetailEntity.class);
            entity.forEach(o -> {
                o.setId(null);
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(SfaCustomerBusinessDetailEntity::getBusinessCode, (Object)o.getBusinessCode())).eq(SfaCustomerBusinessDetailEntity::getStepCode, (Object)o.getStepCode())).remove();
            });
            this.saveBatch(entity);
        }
    }

    public void deCheck(SfaCustomerBusinessDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBusinessType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBusinessCode(), (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getStepCode(), (String)"\u62dc\u8bbf\u6b65\u9aa4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPlanInfoId(), (String)"\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientSubclass(), (String)"\u5ba2\u6237\u7ec6\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

