/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mqconsumer;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.activity.req.ActivityExecutionResolveData;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityDisplayExecutionEsDataRepositories;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepActivityExecutionServiceImpl;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="SFA_ACTIVITY_EXECUTION_RESOLVE", consumerGroup="SFA_ACTIVITY_EXECUTION_RESOLVE${rocketmq.environment-variable}", consumeMode=ConsumeMode.CONCURRENTLY)
public class SfaActivityExecutionResolveConsumer
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(SfaActivityExecutionResolveConsumer.class);
    @Resource
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;
    @Resource
    private SfaVisitStepActivityExecutionServiceImpl sfaVisitStepActivityExecutionServiceImpl;
    @Resource
    private SfaVisitStepActivityDisplayExecutionEsDataRepositories sfaVisitStepActivityDisplayExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;

    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return this.sfaVisitStepActivityExecutionServiceImpl;
    }

    protected Object handleMessage(RocketMQMessageBody message) {
        String msgBody = message.getMsgBody();
        ActivityExecutionResolveData resolveData = (ActivityExecutionResolveData)JsonPropertyUtil.toObject((String)msgBody, ActivityExecutionResolveData.class);
        if (this.hasOldData(resolveData)) {
            return "\u5df2\u7ecf\u5b58\u5728\u6267\u884c\u8fc7\u7684\u8001\u6570\u636e,\u8df3\u8fc7\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u5199\u5165";
        }
        SfaVisitStepActivityExecutionRedisData redisData = this.buildRedisData(resolveData);
        this.getVisitDataDurabilityService().dataDurability(Lists.newArrayList((Object[])new SfaVisitStepActivityExecutionRedisData[]{redisData}), null);
        return "SFA\u6d3b\u52a8\u6267\u884c\u660e\u7ec6\u89e3\u6790\u5b8c\u6210";
    }

    protected boolean hasOldData(ActivityExecutionResolveData resolveData) {
        SfaVisitStepActivityExecutionRedisData data;
        String resolveDate = resolveData.getResolveDate();
        SfaActivityExecutionEntity executionEntity = resolveData.getActivityExecutionEntity();
        SfaClientData clientData = resolveData.getClientData();
        LambdaQueryChainWrapper lambdaQueryChainWrapper = (LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitStepActivityExecutionService.lambdaQuery().eq(SfaVisitStepActivityExecutionEntity::getActivityExecutionId, (Object)executionEntity.getId())).eq(SfaVisitStepActivityExecutionEntity::getClientCode, (Object)clientData.getClientCode());
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(executionEntity.getActivityType())) {
            data = this.sfaVisitStepActivityCostExecutionEsDataRepositories.findByActivityExecutionIdAndClientCode(executionEntity.getId(), clientData.getClientCode());
        } else {
            data = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.findByActivityExecutionIdAndClientCodeAndActivityDate(executionEntity.getId(), clientData.getClientCode(), resolveDate);
            lambdaQueryChainWrapper.eq(SfaVisitStepActivityExecutionEntity::getActivityDate, (Object)resolveDate);
        }
        if (null != data) {
            return true;
        }
        SfaVisitStepActivityExecutionEntity stepActivityExecutionEntity = (SfaVisitStepActivityExecutionEntity)lambdaQueryChainWrapper.one();
        return null != stepActivityExecutionEntity;
    }

    protected SfaVisitStepActivityExecutionRedisData buildRedisData(ActivityExecutionResolveData resolveData) {
        SfaClientData clientData = resolveData.getClientData();
        LocalDate resolveDate = LocalDate.parse(resolveData.getResolveDate(), CrmDateUtils.yyyyMMdd);
        SfaActivityExecutionEntity executionEntity = resolveData.getActivityExecutionEntity();
        SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData)CrmBeanUtil.copy((Object)((Object)executionEntity), SfaVisitStepActivityExecutionRedisData.class);
        CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)clientData, (Object)redisData);
        redisData.setExecuteStatus(SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal());
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(executionEntity.getActivityType())) {
            redisData.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_COST.getVal());
        } else {
            redisData.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_DISPLAY.getVal());
        }
        redisData.setActivityDate(resolveDate.format(CrmDateUtils.yyyyMMdd));
        redisData.setActivityYearMonth(resolveDate.format(CrmDateUtils.yyyyMM));
        redisData.setActivityYear(resolveDate.format(CrmDateUtils.yyyy));
        redisData.setActivityExecutionId(executionEntity.getId());
        redisData.setId(null);
        return redisData;
    }
}

