/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.VisitInfoPlanListener;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractVisitInfoPlanListener
implements VisitInfoPlanListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractVisitInfoPlanListener.class);
    public static final Map<String, List<Class<? extends AbstractVisitInfoPlanListener>>> VISIT_STEP_LISTENER_CLASS_MAPPING = new HashMap<String, List<Class<? extends AbstractVisitInfoPlanListener>>>();

    public static List<AbstractVisitInfoPlanListener> getListeners(String visitBigType) {
        List<Class<? extends AbstractVisitInfoPlanListener>> clazz = AbstractVisitInfoPlanListener.getListenerClazz(visitBigType);
        ArrayList listeners = Lists.newArrayList();
        for (Class<? extends AbstractVisitInfoPlanListener> aClass : clazz) {
            if (null == aClass) continue;
            AbstractVisitInfoPlanListener listener = (AbstractVisitInfoPlanListener)SpringApplicationContextUtil.getApplicationContext().getBean(aClass);
            if (null == listener) {
                log.warn("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6\u76d1\u542c\u5668[" + aClass.getName() + "]\u7684\u5b9e\u4f8b,\u5ffd\u7565\u8be5\u76d1\u542c\u5668\uff01");
            }
            listeners.add(listener);
        }
        return listeners;
    }

    public static List<Class<? extends AbstractVisitInfoPlanListener>> getListenerClazz(String visitBigType) {
        ArrayList classes = Lists.newArrayList();
        List<Class<? extends AbstractVisitInfoPlanListener>> temp = VISIT_STEP_LISTENER_CLASS_MAPPING.get(visitBigType);
        if (null != temp) {
            classes.addAll(temp);
        }
        if (null != (temp = VISIT_STEP_LISTENER_CLASS_MAPPING.get(SfaVisitEnum.VisitBigType.LISTENER_ALL))) {
            classes.addAll(temp);
        }
        return classes;
    }

    @PostConstruct
    public final void constructed() {
        Set<String> visitBigTypes = this.visitBigTypeRegistry();
        if (CollectionUtils.isEmpty(visitBigTypes)) {
            throw new BusinessException("\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6\u76d1\u542c\u5668\u6ce8\u518c\u5931\u8d25: \u8bf7\u6307\u5b9a\u76d1\u542c\u5668[" + this.getClass().getName() + "]\u7684\u62dc\u8bbf\u5927\u7c7b\u7f16\u7801");
        }
        for (String visitBigType : visitBigTypes) {
            if (StringUtils.isBlank((CharSequence)visitBigType)) {
                throw new BusinessException("\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6\u76d1\u542c\u5668\u6ce8\u518c\u5931\u8d25: \u76d1\u542c\u5668[" + this.getClass().getName() + "]\u6307\u5b9a\u4e86\u7a7a\u503c\u7684\u62dc\u8bbf\u5927\u7c7b\u7f16\u7801");
            }
            ArrayList classes = VISIT_STEP_LISTENER_CLASS_MAPPING.get(visitBigType);
            if (null == classes) {
                classes = Lists.newArrayList();
            }
            classes.add(this.getClass());
            VISIT_STEP_LISTENER_CLASS_MAPPING.put(visitBigType, classes);
        }
    }

    protected abstract Set<String> visitBigTypeRegistry();

    public void doListenerEvent(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        VisitInfoPlanListener.DoneEvent doneEvent = new VisitInfoPlanListener.DoneEvent();
        doneEvent.setPlanInfoEntity(sfaVisitPlanInfoEntity);
        doneEvent.setSfaVisitPlanInfoRedisData(sfaVisitPlanInfoRedisData);
        if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitBigType())) {
            if (SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.begin(doneEvent);
            }
            if (SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus()) || SfaVisitEnum.HelpVisitStatus.EX.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.committed(doneEvent);
            }
            if (SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.noCommit(doneEvent);
            }
            if (SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.overdue(doneEvent);
            }
        } else {
            if (SfaVisitEnum.visitStatus.V2.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.begin(doneEvent);
            }
            if (SfaVisitEnum.visitStatus.V3.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus()) || SfaVisitEnum.visitStatus.V4.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.committed(doneEvent);
            }
            if (SfaVisitEnum.visitStatus.V5.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.noCommit(doneEvent);
            }
            if (SfaVisitEnum.visitStatus.V6.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
                this.overdue(doneEvent);
            }
        }
    }
}

