/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPlaceReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPlaceRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksignrule.mapper.SfaWorkSignPlaceMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignPlaceEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignPlaceService;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"SfaWorkSignPlaceServiceExpandImpl"})
public class SfaWorkSignPlaceServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkSignPlaceMapper, SfaWorkSignPlaceEntity>
implements ISfaWorkSignPlaceService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignPlaceServiceImpl.class);
    @Resource
    private SfaWorkSignPlaceMapper sfaWorkSignPlaceMapper;

    @Override
    @CrmLog
    public PageResult<SfaWorkSignPlaceRespVo> findList(SfaWorkSignPlaceReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignPlaceRespVo> list = this.sfaWorkSignPlaceMapper.findList((Page<SfaWorkSignPlaceRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public Map<String, List<SfaWorkSignPlaceEntity>> selectMappingByRuleCodes(Set<String> ruleCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(ruleCodes)) {
            return Maps.newHashMap();
        }
        return this.sfaWorkSignPlaceMapper.selectList((Wrapper)Wrappers.lambdaQuery(SfaWorkSignPlaceEntity.class).in(SfaWorkSignPlaceEntity::getRuleCode, ruleCodes)).stream().collect(Collectors.groupingBy(SfaWorkSignPlaceEntity::getRuleCode));
    }

    @Override
    @CrmLog
    public SfaWorkSignPlaceRespVo query(SfaWorkSignPlaceReqVo reqVo) {
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new SfaWorkSignPlaceRespVo();
        }
        SfaWorkSignPlaceRespVo sfaWorkSignPersonnelRespVo = (SfaWorkSignPlaceRespVo)list.get(0);
        return sfaWorkSignPersonnelRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaWorkSignPlaceReqVo reqVo) {
        SfaWorkSignPlaceEntity entity = (SfaWorkSignPlaceEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignPlaceEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaWorkSignPlaceReqVo reqVo) {
        SfaWorkSignPlaceEntity entity = (SfaWorkSignPlaceEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaWorkSignPlaceReqVo reqVo) {
        List sfaWorkSignPlaceEntities = this.sfaWorkSignPlaceMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignPlaceEntities)) {
            sfaWorkSignPlaceEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSignPlaceEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaWorkSignPlaceReqVo reqVo) {
        List sfaWorkSignPlaceEntities = this.sfaWorkSignPlaceMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignPlaceEntities)) {
            sfaWorkSignPlaceEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignPlaceEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaWorkSignPlaceReqVo reqVo) {
        List sfaWorkSignPlaceEntities = this.sfaWorkSignPlaceMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignPlaceEntities)) {
            sfaWorkSignPlaceEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignPlaceEntities);
    }

    @Override
    @CrmLog
    public void saveCheck(SfaWorkSignPlaceReqVo placeReqVo) {
        if (StringUtils.isEmpty((String)placeReqVo.getPlaceSignType())) {
            placeReqVo.setPlaceSignType(SfaWorkSignEnum.WorkSignType.CLOCK_ALL.getVal());
        }
        AssertUtils.isNotEmpty((String)placeReqVo.getWspNo(), (String)"\u6253\u5361\u5730\u70b9\uff0c\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)placeReqVo.getPlaceName(), (String)("\u5e8f\u53f7" + placeReqVo.getWspNo() + "\u6253\u5361\u5730\u70b9\uff0c\u6253\u5361\u5730\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        AssertUtils.isNotEmpty((String)placeReqVo.getPlaceLngin(), (String)("\u5e8f\u53f7" + placeReqVo.getWspNo() + "\u6253\u5361\u5730\u70b9\uff0c\u5730\u70b9\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a"));
        AssertUtils.isNotEmpty((String)placeReqVo.getPlaceLatin(), (String)("\u5e8f\u53f7" + placeReqVo.getWspNo() + "\u6253\u5361\u5730\u70b9\uff0c\u5730\u70b9\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a"));
        AssertUtils.isNotEmpty((String)placeReqVo.getPlaceSignType(), (String)("\u5e8f\u53f7" + placeReqVo.getWspNo() + "\u6253\u5361\u5730\u70b9\uff0c\u6253\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
        AssertUtils.isNotEmpty((String)SfaWorkSignEnum.WorkSignType.getDesc((String)placeReqVo.getPlaceSignType()), (String)("\u5e8f\u53f7" + placeReqVo.getWspNo() + "\u6253\u5361\u5730\u70b9\uff0c\u6253\u5361\u7c7b\u578b\u9519\u8bef"));
        AssertUtils.isNotEmpty((String)placeReqVo.getPlaceRange(), (String)("\u5e8f\u53f7" + placeReqVo.getWspNo() + "\u6253\u5361\u5730\u70b9\uff0c\u6253\u5361\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a"));
    }
}

