/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.ActivityExecuteHelper;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityCostStepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityCostExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.impl.SfaVisitStepActivityExecutionServiceImpl;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnMissingBean(name={"activityCostVisitStepExecutorExpandImpl"})
public class ActivityCostVisitStepExecutor<ExecuteReq extends ActivityStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, ActivityCostStepExecuteDataResp, ActivityExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(ActivityCostVisitStepExecutor.class);
    @Resource
    private SfaVisitStepActivityExecutionServiceImpl sfaVisitStepActivityExecutionServiceImpl;
    @Resource
    private ActivityExecuteHelper activityExecuteHelper;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return this.sfaVisitStepActivityExecutionServiceImpl;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_COST.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepActivityExecutionRedisData redisData = this.doExecute(visitStepExecuteReq, sfaVisitPlanInfoEntity.getId(), SfaActivityEnum.StepActivityExecuteStatus.EXECUTING, SfaVisitEnum.VISIT_OFF_LINE.online);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepActivityExecutionRedisData redisData = this.doExecute(visitStepExecuteReq, sfaVisitPlanInfoEntity.getId(), SfaActivityEnum.StepActivityExecuteStatus.EXECUTING, SfaVisitEnum.VISIT_OFF_LINE.offline);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
    }

    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        this.check(null, visitStepExecuteReq);
        ActivityStepExecuteData executeReq = (ActivityStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        visitStepExecuteReq.setRedisHashKey(executeReq.getId());
        this.doExecute(visitStepExecuteReq, executeReq.getId(), SfaActivityEnum.StepActivityExecuteStatus.COMPLETE, SfaVisitEnum.VISIT_OFF_LINE.online);
    }

    protected SfaVisitStepActivityExecutionRedisData doExecute(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq, String visitPlanInfoId, SfaActivityEnum.StepActivityExecuteStatus executeStatus, SfaVisitEnum.VISIT_OFF_LINE lineType) {
        this.check(null, visitStepExecuteReq);
        SfaVisitStepActivityExecutionRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setExecuteStatus(executeStatus.getVal());
        redisData.setVisitPlanInfoId(visitPlanInfoId);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList((Object[])new SfaVisitStepActivityExecutionRedisData[]{redisData}), fromRespVo);
        return redisData;
    }

    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        List<SfaVisitStepActivityExecutionRedisData> data = this.sfaVisitStepActivityExecutionServiceImpl.loadVisitActivityList(loadParam.getVisitInfoId(), SfaActivityEnum.activityType.COST_ACTIVITY.getVal());
        return data.stream().filter(v -> SfaActivityEnum.StepActivityExecuteStatus.EXECUTING.getVal().equals(v.getExecuteStatus()) || SfaActivityEnum.StepActivityExecuteStatus.COMPLETE.getVal().equals(v.getExecuteStatus())).map(v -> {
            v.setExecuteStatus(SfaActivityEnum.StepActivityExecuteStatus.COMPLETE.getVal());
            return v;
        }).collect(Collectors.toList());
    }

    protected SfaVisitStepActivityExecutionRedisData buildRedisData(VisitStepExecuteReq<? extends ActivityStepExecuteData> visitStepExecuteReq) {
        ActivityStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepActivityCostExecutionEsData esData = (SfaVisitStepActivityCostExecutionEsData)this.getEsDataById(executeData.getId());
        CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)executeData, (Object)esData);
        esData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        esData.setActivityRequireReqVoList(executeData.getActivityRequireReqVoList());
        esData.setActivityTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        UserRedis userRedis = UserUtils.getUser();
        esData.setUserName(userRedis.getUsername());
        esData.setRealName(userRedis.getUsername());
        esData.setPosCode(userRedis.getPoscode());
        esData.setPosName(userRedis.getPosname());
        esData.setOrgCode(userRedis.getOrgcode());
        esData.setOrgName(userRedis.getOrgname());
        return esData;
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        if (StringUtils.isBlank((CharSequence)visitStepExecuteReq.getFormId())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8868\u5355id");
        }
        ActivityStepExecuteData stepExecuteData = (ActivityStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getId())) {
            throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u660e\u7ec6id\u4e3a\u7a7a");
        }
        List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList = stepExecuteData.getActivityRequireReqVoList();
        if (!CollectionUtils.isEmpty(activityRequireReqVoList)) {
            for (ActivityStepExecuteData.ActivityRequireReqVo requireReqVo : activityRequireReqVoList) {
                List<CrmAttachment> pictureList = requireReqVo.getPictureList();
                this.checkPics(pictureList, 1, 5, requireReqVo.getActivityRequireName());
            }
        }
    }

    @Override
    protected ActivityCostStepExecuteDataResp doLoad(ActivityExecutorLoadReq loadParam) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(loadParam.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(loadParam.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(loadParam.getFormId());
        ExecutorWorkbenchLoadReq param = new ExecutorWorkbenchLoadReq();
        param.setBizId(loadParam.getId());
        ActivityCostStepExecuteDataResp dataResp = this.doLoadEditPageForWorkbench(param);
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional optional = this.sfaVisitStepActivityCostExecutionEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (StepExecuteDataResp)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6d3b\u52a8\u6267\u884c\u660e\u7ec6\u6570\u636e!");
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        return null;
    }

    @Override
    protected ActivityCostStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq param) {
        if (StringUtils.isBlank((CharSequence)param.getBizId())) {
            throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u660e\u7ec6[BizId]\u4e3a\u7a7a");
        }
        SfaVisitStepActivityCostExecutionEsData redisData = (SfaVisitStepActivityCostExecutionEsData)this.getEsDataById(param.getBizId());
        ActivityCostStepExecuteDataResp dataResp = (ActivityCostStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, ActivityCostStepExecuteDataResp.class);
        dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
        SfaVisitStepFromRespVo sfaVisitStepFrom = redisData.getSfaVisitStepFrom();
        if (null == sfaVisitStepFrom) {
            sfaVisitStepFrom = this.getFormData(redisData.getClientType(), redisData.getStepCode(), param.getVisitBigType(), redisData.getClientSubclass());
        }
        dataResp.setSfaVisitStepFrom(sfaVisitStepFrom);
        return dataResp;
    }
}

