/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.integral.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.cache.util.IntegralUserUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.integral.service.SfaIntegralDetailService;
import com.biz.crm.integral.service.component.SfaIntegralMonthJobExecutor;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralDetailReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralDetailUserReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralRankAppReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralRankReqVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralDetailRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRankRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralUserRankRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaIntegralDetail"})
@Api(tags={"\u79ef\u5206\u660e\u7ec6"})
public class SfaIntegralDetailController {
    private static final Logger log = LoggerFactory.getLogger(SfaIntegralDetailController.class);
    @Resource
    private SfaIntegralDetailService sfaIntegralDetailService;
    @Resource
    private SfaIntegralMonthJobExecutor sfaIntegralMonthJobExecutor;
    @Resource
    private IntegralUserUtil integralUserUtil;

    @ApiOperation(value="\u89e6\u53d1\u6708\u5ea6\u79ef\u5206\u7ed3\u7b97\u4efb\u52a1")
    @GetMapping(value={"/integralDetailJob"})
    @CrmLog
    public Result integralDetailJob(@RequestParam(required=false) String yearMonth) {
        this.sfaIntegralMonthJobExecutor.integralDetailJob(yearMonth);
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u5f97\u79ef\u5206\u660e\u7ec6\u62a5\u8868")
    @PostMapping(value={"/pageDetail"})
    @CrmDictMethod
    @CrmLog
    public Result<PageResult<SfaIntegralDetailRespVo>> integralDetailReport(@RequestBody SfaIntegralDetailReqVo sfaIntegralDetailReqVo) {
        return Result.ok(this.sfaIntegralDetailService.integralDetailReport(sfaIntegralDetailReqVo));
    }

    @ApiOperation(value="\u83b7\u5f97\u79ef\u5206\u6392\u540d\u62a5\u8868")
    @PostMapping(value={"/pageIntegralRank"})
    @CrmLog
    public Result<PageResult<SfaIntegralRankRespVo>> pageIntegralRank(@RequestBody SfaIntegralRankReqVo sfaIntegralRankReqVo) {
        return Result.ok(this.sfaIntegralDetailService.pageIntegralRank(sfaIntegralRankReqVo));
    }

    @ApiOperation(value="\u83b7\u5f97\u4e2a\u4eba\u7684\u79ef\u5206\u660e\u7ec6-\u5c0f\u7a0b\u5e8f\u7aef")
    @PostMapping(value={"/pageDetailByLoginUser"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaIntegralDetailRespVo>> pageDetailByLoginUser(@RequestBody SfaIntegralDetailUserReqVo sfaIntegralDetailUserReqVo) {
        return Result.ok(this.sfaIntegralDetailService.pageDetailByLoginUser(sfaIntegralDetailUserReqVo));
    }

    @ApiOperation(value="\u83b7\u5f97\u767b\u9646\u7528\u6237\u7684\u603b\u79ef\u5206-\u5c0f\u7a0b\u5e8f\u7aef")
    @PostMapping(value={"/countIntegralNum"})
    @CrmLog
    public Result<SfaIntegralUserRankRespVo> countIntegralNum() {
        UserRedis userRedis = UserUtils.getUser();
        return Result.ok((Object)this.integralUserUtil.getObj(userRedis.getUsername()));
    }

    @ApiOperation(value="\u83b7\u5f97\u79ef\u5206\u6392\u540d\u4fe1\u606f-\u5c0f\u7a0b\u5e8f\u7aef")
    @PostMapping(value={"/pageIntegralRankToApp"})
    @CrmLog
    public Result<PageResult<SfaIntegralRankRespVo>> pageIntegralRankToApp(@RequestBody SfaIntegralRankAppReqVo sfaIntegralRankAppReqVo) {
        return Result.ok(this.sfaIntegralDetailService.pageIntegralRankToApp(sfaIntegralRankAppReqVo));
    }
}

