/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.achievement.controller.AchievementRecordsMQSend;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.asexecution.service.ISfaAsExecutionService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.base.utils.ProcessUtil;
import com.biz.crm.enums.SfaOrderSourceEnum;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.OrderAsExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.OrderStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.moblie.controller.workbench.req.OrderWorkbenchDataReq;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsExecuteOrderProductReqVo;
import com.biz.crm.tpmact.model.SfaTpmActBaseEntity;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEsData;
import com.biz.crm.visitstep.model.SfaVisitStepOrderItemEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepOrderEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepOrderServiceImpl;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnMissingBean(name={"orderVisitStepExecutorExpandImpl"})
public class OrderVisitStepExecutor<ExecuteReq extends OrderStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, OrderStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(OrderVisitStepExecutor.class);
    @Resource
    private SfaVisitStepOrderEsDataRepositories sfaVisitStepOrderEsDataRepositories;
    @Resource
    private ISfaAsExecutionService sfaAsExecutionService;
    @Resource
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;
    @Resource
    protected SfaVisitStepOrderServiceImpl sfaVisitStepOrderServiceImpl;
    @Resource
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Resource
    private ISfaVisitStepOrderItemService sfaVisitStepOrderItemService;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return this.sfaVisitStepOrderServiceImpl;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_ORDER.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setOrderSource(SfaOrderSourceEnum.VISIT.getCode());
        redisData.setOrderSourceName(SfaOrderSourceEnum.VISIT.getDesc());
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.online);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        super.check(visitStepExecuteReq);
        this.checkHead(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        this.checkBizData(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setOrderSource(SfaOrderSourceEnum.VISIT.getCode());
        redisData.setOrderSourceName(SfaOrderSourceEnum.VISIT.getDesc());
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.offline);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 1296000L);
    }

    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderWorkbenchDataReq dataReq = (OrderWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        dataReq.convert();
        SfaVisitStepOrderEsData sfaVisitStepOrderEsData = null;
        if (StringUtils.isNotEmpty((String)dataReq.getId())) {
            Optional optionalVisitStepOrderEsData = this.sfaVisitStepOrderEsDataRepositories.findById(dataReq.getId());
            if (!optionalVisitStepOrderEsData.isPresent()) {
                throw new BusinessException("\u4fee\u6539\u5931\u8d25\u672a\u5728ES\u627e\u5230id\u5bf9\u5e94\u6570\u636e");
            }
            sfaVisitStepOrderEsData = (SfaVisitStepOrderEsData)optionalVisitStepOrderEsData.get();
            OrderStepExecuteData stepExecuteData = (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData();
            stepExecuteData.setOrderSource(sfaVisitStepOrderEsData.getOrderSource());
        }
        this.checkForWorkbench(null, visitStepExecuteReq);
        if (null != sfaVisitStepOrderEsData) {
            this.updateOrderEsData(visitStepExecuteReq, sfaVisitStepOrderEsData);
            this.buildRedisDataForUpate(sfaVisitStepOrderEsData, (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData());
            this.dataDurability(Lists.newArrayList((Object[])new SfaVisitStepOrderEsData[]{sfaVisitStepOrderEsData}), sfaVisitStepOrderEsData.getSfaVisitStepFrom());
            return;
        }
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        String id = UUIDGenerator.generate();
        redisData.setId(id);
        redisData.setRedisHashKey(id);
        redisData.setVisitPlanInfoId(id);
        this.doExecuteForWorkbench(redisData, visitStepExecuteReq, SfaOrderSourceEnum.WORKBENCH);
    }

    public void executeForAs(OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo> dataReq) {
        dataReq.convert();
        VisitStepExecuteReq<OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo>> visitStepExecuteReq = new VisitStepExecuteReq<OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo>>();
        visitStepExecuteReq.setRedisHashKey("WORKBENCH");
        visitStepExecuteReq.setFormId(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_ORDER.getVal());
        visitStepExecuteReq.setStepExecuteData(dataReq);
        this.checkForAs(null, visitStepExecuteReq);
        Optional optionalVisitStepOrderEsData = this.sfaVisitStepOrderEsDataRepositories.findById(dataReq.getId());
        if (optionalVisitStepOrderEsData.isPresent()) {
            SfaVisitStepOrderEsData sfaVisitStepOrderEsData = (SfaVisitStepOrderEsData)optionalVisitStepOrderEsData.get();
            this.updateOrderEsData(visitStepExecuteReq, sfaVisitStepOrderEsData);
            return;
        }
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setId(dataReq.getId());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dataReq.getVisitPlanInfoId())) {
            redisData.setVisitPlanInfoId(dataReq.getId());
        } else {
            redisData.setVisitPlanInfoId(dataReq.getVisitPlanInfoId());
        }
        this.buildEntity(dataReq, redisData);
        this.doExecuteForWorkbench(redisData, visitStepExecuteReq, SfaOrderSourceEnum.SCHEME);
    }

    protected void doExecuteForWorkbench(SfaVisitStepOrderRedisData redisData, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq, SfaOrderSourceEnum orderSourceEnum) {
        redisData.setOrderSource(orderSourceEnum.getCode());
        redisData.setOrderSourceName(orderSourceEnum.getDesc());
        ClientReq dataReq = (ClientReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList((Object[])new SfaVisitStepOrderRedisData[]{redisData}), fromRespVo);
        UserRedis user = UserUtils.getUser();
        SfaAchievementAccomplishRecordReqVo reqVo = (SfaAchievementAccomplishRecordReqVo)CrmBeanUtil.copy((Object)dataReq, SfaAchievementAccomplishRecordReqVo.class);
        reqVo.setRelationId(redisData.getId()).setIndexCode(SfaVisitEnum.indexType.XD.getCode()).setCustomerCode(dataReq.getClientCode()).setUsername(user.getUsername()).setObjectPosCode(user.getPoscode()).setCreateOrgCode(user.getOrgcode());
        AchievementRecordsMQSend.saveAchievementRecordsMQ(reqVo);
    }

    public void updateOrderApprovalStatus(ActivitiCallBackVo activitiCallBackVo) {
        String processState2 = activitiCallBackVo.getProcessState().toString();
        Optional repositoriesById = this.sfaVisitStepOrderEsDataRepositories.findById(activitiCallBackVo.getFormNo());
        SfaVisitStepOrderEsData sfaVisitStepOrderEsData = (SfaVisitStepOrderEsData)repositoriesById.get();
        if (ActivitiEnum.processState.PASS.getVal().equals(processState2)) {
            sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
            sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.NORMAL.getDesc());
            this.sfaAchievementAccomplishRecordService.reuseByRelationId(sfaVisitStepOrderEsData.getId());
            if (SfaOrderSourceEnum.SCHEME.getCode().equals(sfaVisitStepOrderEsData.getOrderSource())) {
                OrderAsExecuteDataResp orderAsExecuteDataResp = new OrderAsExecuteDataResp();
                orderAsExecuteDataResp.setSfaVisitStepOrderItems(sfaVisitStepOrderEsData.getSfaVisitStepOrderItems());
                orderAsExecuteDataResp.convert();
                SfaAsExecuteOrderProductReqVo sfaAsExecuteOrderProductReqVo = new SfaAsExecuteOrderProductReqVo();
                sfaAsExecuteOrderProductReqVo.setExecuteId(sfaVisitStepOrderEsData.getId());
                sfaAsExecuteOrderProductReqVo.setSfaActSchemeSetmealRespVos(orderAsExecuteDataResp.getSfaActSchemeSetmealRespVos());
                this.sfaAsExecutionService.updateExecutionProduct(sfaAsExecuteOrderProductReqVo);
            }
        }
        if (ActivitiEnum.processState.REJECT.getVal().equals(processState2)) {
            sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.REJECT.getValue());
            sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.REJECT.getDesc());
        }
        if (ActivitiEnum.processState.ROLLBACK.getVal().equals(processState2)) {
            sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.ROLLBACK.getValue());
            sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.ROLLBACK.getDesc());
        }
        this.dataDurability(Lists.newArrayList((Object[])new SfaVisitStepOrderEsData[]{sfaVisitStepOrderEsData}), sfaVisitStepOrderEsData.getSfaVisitStepFrom());
    }

    private void updateOrderEsData(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq, SfaVisitStepOrderEsData sfaVisitStepOrderEsData) {
        OrderStepExecuteData orderStepExecuteData = (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)orderStepExecuteData, (Object)sfaVisitStepOrderEsData);
        sfaVisitStepOrderEsData.setSfaVisitStepOrderItems(orderStepExecuteData.getSfaVisitStepOrderItems());
        sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.APPROVAL.getValue());
        sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.APPROVAL.getDesc());
        sfaVisitStepOrderEsData.setProcessNo(ProcessUtil.startProcess(sfaVisitStepOrderEsData.getId(), ActivitiEnum.FormTypeEnum.ORDER));
        this.sfaAchievementAccomplishRecordService.deleteByRelationId(sfaVisitStepOrderEsData.getId());
    }

    protected SfaVisitStepOrderRedisData buildRedisData(VisitStepExecuteReq<? extends OrderStepExecuteData> visitStepExecuteReq) {
        OrderStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)CrmBeanUtil.copy((Object)executeData, SfaVisitStepOrderRedisData.class);
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setOrderTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setOrderDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        redisData.setOrderYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        redisData.setOrderYear(LocalDateTime.now().format(CrmDateUtils.yyyy));
        redisData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
        redisData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.NORMAL.getDesc());
        redisData.setCustomerCode(executeData.getCustomerCode());
        redisData.setCustomerName(executeData.getCustomerName());
        this.buildRedisDataForUpate(redisData, executeData);
        return redisData;
    }

    protected void buildRedisDataForUpate(SfaVisitStepOrderRedisData redisData, OrderStepExecuteData executeData) {
        List<OrderAsDataReq.OrderItemAsReqVo> itemAsReqVos = executeData.getSfaVisitStepOrderItems();
        redisData.setSfaVisitStepOrderItems(itemAsReqVos);
        redisData.setAddress(executeData.getAddress());
        redisData.setContacts(executeData.getContacts());
        redisData.setTelephone(executeData.getTelephone());
        redisData.setExpectReceive(executeData.getExpectReceive());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)executeData.getRemarks())) {
            redisData.setRemarks(executeData.getRemarks());
        }
        BigDecimal price = BigDecimal.ZERO;
        for (OrderAsDataReq.OrderItemAsReqVo itemAsReqVo : itemAsReqVos) {
            if (null == itemAsReqVo.getPrice() || null == itemAsReqVo.getQuantity()) continue;
            price = price.add(itemAsReqVo.getPrice().multiply(itemAsReqVo.getQuantity()));
        }
        redisData.setTotalPrice(price);
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepOrderRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        if (sfaVisitPlanInfoEntity instanceof SfaVisitPlanInfoEntity) {
            this.buildClientData(redisData, (SfaVisitPlanInfoEntity)sfaVisitPlanInfoEntity);
        } else {
            this.buildClientData(redisData, sfaVisitPlanInfoEntity.getClientCode(), sfaVisitPlanInfoEntity.getClientType());
        }
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getRealname());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void checkHead(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderStepExecuteData stepExecuteData = (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        if (!SfaOrderSourceEnum.SCHEME.getCode().equals(stepExecuteData.getOrderSource()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getAddress())) {
            throw new BusinessException("\u6536\u8d27\u5730\u5740\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getContacts())) {
            throw new BusinessException("\u8054\u7cfb\u4eba\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getTelephone())) {
            throw new BusinessException("\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a");
        }
    }

    protected void check(SfaVisitPlanInfoEntity entity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderStepExecuteData stepExecuteData = (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getId())) {
            super.check(visitStepExecuteReq);
        }
        this.controlDataTrans(visitStepExecuteReq);
        super.checkLongitudeAndLatitude(visitStepExecuteReq, entity, stepExecuteData.getLongitude(), stepExecuteData.getLatitude());
        this.checkHead(entity, visitStepExecuteReq);
        this.checkBizData(entity, visitStepExecuteReq);
    }

    protected void checkBizData(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderStepExecuteData stepExecuteData = (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        List sfaVisitStepOrderItems = stepExecuteData.getSfaVisitStepOrderItems();
        if (CollectionUtils.isEmpty(sfaVisitStepOrderItems)) {
            throw new BusinessException("\u5546\u54c1\u6e05\u5355\u4e3a\u7a7a");
        }
        OrderStepExecuteData.OrderItemReqVo sfaVisitStepOrderItemTemp = null;
        for (OrderStepExecuteData.OrderItemReqVo sfaVisitStepOrderItem : sfaVisitStepOrderItems) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getProductCode())) {
                throw new BusinessException("\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getProductName())) {
                throw new BusinessException("\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getSeriesCode())) {
                throw new BusinessException("\u5546\u54c1\u7cfb\u5217\u7f16\u7801\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getSeriesName())) {
                throw new BusinessException("\u5546\u54c1\u7cfb\u5217\u540d\u79f0\u4e3a\u7a7a");
            }
            if (!SfaOrderSourceEnum.SCHEME.getCode().equals(stepExecuteData.getOrderSource())) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getUnit())) {
                    throw new BusinessException("\u5546\u54c1\u5355\u4f4d\u4e3a\u7a7a");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getUnitName())) {
                    throw new BusinessException("\u5546\u54c1\u5355\u4f4d\u540d\u79f0\u4e3a\u7a7a");
                }
            }
            if (null == sfaVisitStepOrderItem.getQuantity()) {
                throw new BusinessException("\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a");
            }
            sfaVisitStepOrderItemTemp = sfaVisitStepOrderItem;
        }
        if (sfaVisitStepOrderItemTemp instanceof OrderStepExecuteData.OrderItemReqVo) {
            List orderItemAsReqVos = CrmBeanUtil.copyList(sfaVisitStepOrderItems, OrderAsDataReq.OrderItemAsReqVo.class);
            stepExecuteData.setSfaVisitStepOrderItems(orderItemAsReqVos);
        }
    }

    protected void checkForWorkbench(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)visitStepExecuteReq.getFormId())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8868\u5355id");
        }
        this.checkHead(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        this.checkBizData(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        OrderWorkbenchDataReq stepExecuteData = (OrderWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getClientCode())) {
            throw new BusinessException("\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getClientName())) {
            throw new BusinessException("\u7f51\u70b9\u540d\u79f0\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getClientType())) {
            throw new BusinessException("\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
        }
    }

    protected void checkForAs(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderStepExecuteData stepExecuteData = (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        List sfaVisitStepOrderItems = stepExecuteData.getSfaVisitStepOrderItems();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getId())) {
            throw new BusinessException("\u8ba2\u5355id\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(sfaVisitStepOrderItems)) {
            throw new BusinessException("\u5546\u54c1\u6e05\u5355\u4e3a\u7a7a");
        }
        for (OrderAsDataReq.OrderItemAsReqVo sfaVisitStepOrderItem : sfaVisitStepOrderItems) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getItmeType())) {
                throw new BusinessException("\u8ba2\u5355\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getSetmealId())) continue;
            throw new BusinessException("\u8ba2\u5355\u5546\u54c1\u65b9\u6848\u5957\u9910id\u4e3a\u7a7a");
        }
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        SfaVisitStepOrderEsData esData = this.sfaVisitStepOrderEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional optional = this.sfaVisitStepOrderEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (StepExecuteDataResp)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
    }

    @Override
    protected OrderStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)visitPlanInfoId)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            return this.buildDataResp(visitPlanInfoId, loadParam.getStepCode(), null);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bizId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            OrderStepExecuteDataResp dataResp = new OrderStepExecuteDataResp(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitStepOrderItems(list);
                }
            };
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        }
        return this.buildDataResp(null, null, bizId);
    }

    private OrderStepExecuteDataResp buildDataResp(SfaVisitStepOrderEsData esData) {
        OrderStepExecuteDataResp dataResp;
        if (null == esData) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
        }
        if (SfaOrderSourceEnum.SCHEME.getCode().equals(esData.getOrderSource())) {
            dataResp = (OrderStepExecuteDataResp)CrmBeanUtil.copy((Object)esData, OrderAsExecuteDataResp.class);
            dataResp.setSfaVisitStepOrderItems(CrmBeanUtil.copyList(esData.getSfaVisitStepOrderItems(), OrderAsDataReq.OrderItemAsReqVo.class));
        } else {
            dataResp = (OrderStepExecuteDataResp)CrmBeanUtil.copy((Object)esData, OrderStepExecuteDataResp.class);
            dataResp.setSfaVisitStepOrderItems(esData.getSfaVisitStepOrderItems());
        }
        dataResp.convert();
        dataResp.setSfaVisitStepFrom(esData.getSfaVisitStepFrom());
        List itemReqVos = dataResp.getSfaVisitStepOrderItems();
        BigDecimal totalPrice = BigDecimal.ZERO;
        totalPrice.setScale(2, 0);
        if (null != itemReqVos) {
            for (OrderStepExecuteData.OrderItemReqVo itemReqVo : itemReqVos) {
                BigDecimal temp = itemReqVo.getPrice();
                BigDecimal quantity = itemReqVo.getQuantity();
                if (null == temp || null == quantity) continue;
                totalPrice = totalPrice.add(temp.multiply(quantity));
            }
        }
        dataResp.setTotalPrice(totalPrice);
        return dataResp;
    }

    private OrderStepExecuteDataResp buildDataResp(String visitPlanInfoId, String stepCode, String bizId) {
        LambdaQueryChainWrapper wrapper = this.sfaVisitStepOrderService.lambdaQuery();
        SfaVisitStepOrderEntity orderEntity = (SfaVisitStepOrderEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)wrapper.eq(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)visitPlanInfoId), SfaTpmActBaseEntity::getVisitPlanInfoId, (Object)visitPlanInfoId)).eq(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)stepCode), SfaTpmActBaseEntity::getStepCode, (Object)stepCode)).eq(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bizId), BaseIdEntity::getId, (Object)bizId)).one();
        OrderStepExecuteDataResp dataResp = (OrderStepExecuteDataResp)CrmBeanUtil.copy((Object)orderEntity, OrderStepExecuteDataResp.class);
        if (null != orderEntity) {
            List itemEntityList = ((LambdaQueryChainWrapper)this.sfaVisitStepOrderItemService.lambdaQuery().eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)orderEntity.getId())).list();
            List itemReqVos = CrmBeanUtil.copyList((List)itemEntityList, OrderStepExecuteData.OrderItemReqVo.class);
            dataResp.setSfaVisitStepOrderItems(itemReqVos);
        }
        return dataResp;
    }

    @Override
    protected OrderStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)this.redisService.hmget(SfaVisitStepOrderRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey());
        if (null == redisData) {
            redisData = new SfaVisitStepOrderRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitStepOrderItems(list);
                }
            };
        }
        OrderStepExecuteDataResp dataResp = (OrderStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, OrderStepExecuteDataResp.class);
        dataResp.setSfaVisitStepOrderItems(redisData.getSfaVisitStepOrderItems());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        this.controlDataToObj(dataResp);
        return dataResp;
    }

    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)this.redisService.hmget(SfaVisitStepOrderRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), (Object)loadParam.getRedisHashKey());
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)loadParam)));
            return null;
        }
        return Lists.newArrayList((Object[])new SfaVisitStepOrderRedisData[]{redisData});
    }
}

