/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.collection.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.collection.mapper.SfaDirectoryInputMapper;
import com.biz.crm.collection.model.SfaDirectoryInputEntity;
import com.biz.crm.collection.service.ISfaDirectoryInputService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryInputReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaDirectoryInputRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaDirectoryInputServiceExpandImpl"})
public class SfaDirectoryInputServiceImpl
extends ServiceImpl<SfaDirectoryInputMapper, SfaDirectoryInputEntity>
implements ISfaDirectoryInputService {
    private static final Logger log = LoggerFactory.getLogger(SfaDirectoryInputServiceImpl.class);
    @Resource
    private SfaDirectoryInputMapper sfaDirectoryInputMapper;

    @Override
    @CrmLog
    public PageResult<SfaDirectoryInputRespVo> findList(SfaDirectoryInputReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaDirectoryInputRespVo> list = this.sfaDirectoryInputMapper.findList((Page<SfaDirectoryInputRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public SfaDirectoryInputRespVo query(SfaDirectoryInputReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaDirectoryInputReqVo reqVo) {
        SfaDirectoryInputEntity entity = (SfaDirectoryInputEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaDirectoryInputEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaDirectoryInputReqVo reqVo) {
        SfaDirectoryInputEntity entity = (SfaDirectoryInputEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaDirectoryInputReqVo reqVo) {
        List sfaDirectoryInputEntities = this.sfaDirectoryInputMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaDirectoryInputEntities)) {
            sfaDirectoryInputEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaDirectoryInputEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaDirectoryInputReqVo reqVo) {
        List sfaDirectoryInputEntities = this.sfaDirectoryInputMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaDirectoryInputEntities)) {
            sfaDirectoryInputEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaDirectoryInputEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaDirectoryInputReqVo reqVo) {
        List sfaDirectoryInputEntities = this.sfaDirectoryInputMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaDirectoryInputEntities)) {
            sfaDirectoryInputEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaDirectoryInputEntities);
    }
}

