/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.customer.mapper.SfaCustomerInventoryRecordsMapper;
import com.biz.crm.customer.service.SfaCustomerInventoryRecordsService;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.nebular.sfa.customer.resp.SfaCustomerInventoryRecordsRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.repositories.SfaVisitStepStockInventoryEsDataRepositories;
import com.biz.crm.visitstep.req.GetStockInventoryPageReq;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEsData;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SfaCustomerInventoryRecordsServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaCustomerInventoryRecordsMapper, SfaVisitStepStockInventoryEntity>
implements SfaCustomerInventoryRecordsService {
    private static final Logger log = LoggerFactory.getLogger(SfaCustomerInventoryRecordsServiceImpl.class);
    @Autowired
    private SfaCustomerInventoryRecordsMapper sfacustomerInventoryRecordsMapper;
    @Resource
    private SfaVisitStepStockInventoryEsDataRepositories sfaVisitStepStockInventoryEsDataRepositories;

    @Override
    public SfaCustomerInventoryRecordsRespVo findInventoryRecords(String clientCode) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page(1L, 2L);
        List<SfaCustomerInventoryRecordsRespVo> records = this.sfacustomerInventoryRecordsMapper.findInventoryRecords((com.baomidou.mybatisplus.extension.plugins.pagination.Page<SfaCustomerInventoryRecordsRespVo>)page, clientCode);
        if (ObjectUtils.isEmpty(records)) {
            return new SfaCustomerInventoryRecordsRespVo();
        }
        if (records.size() == 1) {
            return records.get(0).setQuantityDifference(records.get(0).getQuantity());
        }
        SfaCustomerInventoryRecordsRespVo respVo = records.get(0);
        BigDecimal thisQuantity = new BigDecimal(records.get(0).getQuantity());
        BigDecimal lastQuantity = new BigDecimal(records.get(1).getQuantity());
        respVo.setQuantityDifference(thisQuantity.subtract(lastQuantity).toString());
        return respVo;
    }

    @Override
    public SfaCustomerInventoryRecordsRespVo findInventoryRecordsEs(String clientCode) {
        GetStockInventoryPageReq req = new GetStockInventoryPageReq();
        req.setClientCode(clientCode);
        req.setStepCode("sfa_step_code_stock");
        Page list = this.sfaVisitStepStockInventoryEsDataRepositories.search((SearchQuery)req.buildQuery());
        if (CollectionUtil.listEmpty((List)list.getContent())) {
            return new SfaCustomerInventoryRecordsRespVo();
        }
        SfaCustomerInventoryRecordsRespVo respVo = (SfaCustomerInventoryRecordsRespVo)CrmBeanUtil.copy(list.getContent().get(0), SfaCustomerInventoryRecordsRespVo.class);
        List<StockInventoryStepExecuteData.StockDetailReqVo> visitStepStockList = ((SfaVisitStepStockInventoryEsData)list.getContent().get(0)).getVisitStepStockList();
        if (CollectionUtil.listEmpty(visitStepStockList)) {
            return new SfaCustomerInventoryRecordsRespVo();
        }
        Integer stockNum = visitStepStockList.stream().mapToInt(StockInventoryStepExecuteData.StockDetailReqVo::getQuantity).sum();
        respVo.setQuantity(stockNum.toString());
        Long seriesNum = visitStepStockList.stream().map(StockInventoryStepExecuteData.StockDetailReqVo::getProductLevelCode).count();
        respVo.setSeriesNum(seriesNum.toString());
        Long typeNum = visitStepStockList.stream().map(StockInventoryStepExecuteData.StockDetailReqVo::getProductCode).count();
        respVo.setTypeNum(typeNum.toString());
        Integer lastStockNum = stockNum;
        respVo.setQuantityDifference(BigDecimal.valueOf(stockNum.intValue()).subtract(BigDecimal.valueOf(lastStockNum.intValue())).toString());
        if (list.getContent().size() == 1) {
            return respVo;
        }
        lastStockNum = ((SfaVisitStepStockInventoryEsData)list.getContent().get(1)).getVisitStepStockList().stream().mapToInt(StockInventoryStepExecuteData.StockDetailReqVo::getQuantity).sum();
        respVo.setQuantityDifference(BigDecimal.valueOf(stockNum.intValue()).subtract(BigDecimal.valueOf(lastStockNum.intValue())).toString());
        return respVo;
    }
}

