/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.integral.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.integral.service.SfaIntegralRuleService;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.position.MdmPositionLevelFeign;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTreeRespVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralRuleReqVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRulePageRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRuleRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaIntegralRule"})
@Api(tags={"\u79ef\u5206\u89c4\u5219"})
public class SfaIntegralRuleController {
    private static final Logger log = LoggerFactory.getLogger(SfaIntegralRuleController.class);
    @Autowired
    SfaIntegralRuleService sfaIntegralRuleService;
    @Autowired
    MdmPositionLevelFeign mdmPositionLevelFeign;
    @Autowired
    MdmOrgFeign mdmOrgFeign;

    @ApiOperation(value="\u804c\u4f4d\u7b49\u7ea7\u4e0b\u62c9")
    @PostMapping(value={"/selectPosList"})
    @CrmLog
    public Result selectPosList(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo) {
        return this.mdmPositionLevelFeign.selectList(mdmPositionLevelReqVo);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6811\u4e0b\u62c9\u6570\u636e")
    @PostMapping(value={"/selectOrgList"})
    @CrmLog
    public Result<List<MdmOrgTreeRespVo>> selectOrgList() {
        return this.mdmOrgFeign.orgSearchTree(new MdmOrgReqVo());
    }

    @ApiOperation(value="\u65b0\u589e\u79ef\u5206\u89c4\u5219")
    @PostMapping(value={"/saveRule"})
    @CrmLog
    public Result saveRule(@RequestBody SfaIntegralRuleReqVo sfaIntegralRuleReqVo) {
        this.sfaIntegralRuleService.saveIntegralRule(sfaIntegralRuleReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7f16\u8f91\u79ef\u5206\u89c4\u5219")
    @PostMapping(value={"/updateRule"})
    @CrmLog
    public Result updateRule(@RequestBody SfaIntegralRuleReqVo sfaIntegralRuleReqVo) {
        this.sfaIntegralRuleService.updateIntegralRule(sfaIntegralRuleReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u79ef\u5206\u89c4\u5219\u6279\u91cf\u7981\u7528")
    @PostMapping(value={"/disableRule"})
    @CrmLog
    public Result disableRule(@RequestBody List<String> ids) {
        this.sfaIntegralRuleService.disableByIds(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u79ef\u5206\u89c4\u5219\u6279\u91cf\u542f\u7528")
    @PostMapping(value={"/enableRule"})
    @CrmLog
    public Result enableRule(@RequestBody List<String> ids) {
        this.sfaIntegralRuleService.enableByIds(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u79ef\u5206\u89c4\u5219\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteRule"})
    @CrmLog
    public Result deleteRule(@RequestBody List<String> ids) {
        this.sfaIntegralRuleService.deleteByIds(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u79ef\u5206\u89c4\u5219\u6839\u636eId\u83b7\u53d6\u89c4\u5219\u4fe1\u606f")
    @GetMapping(value={"/queryRule"})
    @CrmLog
    public Result queryRule(@RequestParam String id) {
        return Result.ok((Object)this.sfaIntegralRuleService.queryById(id));
    }

    @ApiOperation(value="\u79ef\u5206\u89c4\u5219\u83b7\u53d6\u89c4\u5219\u4fe1\u606f\u5217\u8868")
    @PostMapping(value={"/listRule"})
    @CrmLog
    public Result<PageResult<SfaIntegralRulePageRespVo>> listRule(@RequestBody SfaIntegralRuleReqVo sfaIntegralRuleReqVo) {
        return Result.ok(this.sfaIntegralRuleService.pageIntegralRule(sfaIntegralRuleReqVo));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u79ef\u5206\u89c4\u5219\u7684\u8be6\u60c5\u2014\u2014\u5c0f\u7a0b\u5e8f\u7aef")
    @PostMapping(value={"/getTaskByLoginUser"})
    @CrmLog
    public Result<SfaIntegralRuleRespVo> getTaskByLoginUser() {
        return Result.ok((Object)this.sfaIntegralRuleService.getTaskByLoginUser());
    }
}

