/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.integral.service.component;

import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepListener;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class SfaIntegralStepListener
extends AbstractVisitStepListener {
    protected static Map<String, String> stepMappingIntegralTaskType = Maps.newHashMap();

    @Override
    protected Set<String> visitStepCodeRegistry() {
        return Sets.newHashSet((Object[])new String[]{SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_STOCK.getVal(), SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_ORDER.getVal(), SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_COMPETITOR.getVal(), SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_COST.getVal(), SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_DISPLAY.getVal()});
    }

    @Override
    public void visitDone(VisitStepListener.VisitStepListenerDoneEvent doneEvent) {
    }

    @Override
    public void committed(VisitStepListener.VisitStepListenerCommittedEvent committedEvent) {
        List<? extends VisitStepListener.VisitStepListenerCommittedData> entities = committedEvent.getEntities();
        entities.forEach(entity -> {
            SfaIntegralDetailAddReq reqVo = (SfaIntegralDetailAddReq)((Object)((Object)CrmBeanUtil.copy((Object)entity, SfaIntegralDetailAddReq.class)));
            String integralTaskType = stepMappingIntegralTaskType.get(entity.getStepCode());
            reqVo.setBizId(integralTaskType + ":" + entity.getId());
            reqVo.setIntegralTaskType(integralTaskType);
            reqVo.setExtParam(null);
            SfaIntegralSaveUtil.saveIntegralDetail(reqVo);
        });
    }

    static {
        stepMappingIntegralTaskType.put(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_STOCK.getVal(), IntegralEnum.taskType.SFA_STEP_CODE_STOCK.getValue());
        stepMappingIntegralTaskType.put(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_ORDER.getVal(), IntegralEnum.taskType.SFA_STEP_CODE_ORDER.getValue());
        stepMappingIntegralTaskType.put(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_COMPETITOR.getVal(), IntegralEnum.taskType.SFA_STEP_CODE_COMPETITOR.getValue());
        stepMappingIntegralTaskType.put(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_COST.getVal(), IntegralEnum.taskType.SFA_STEP_CODE_COST.getValue());
        stepMappingIntegralTaskType.put(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_DISPLAY.getVal(), IntegralEnum.taskType.SFA_STEP_CODE_DISPLAY.getValue());
    }
}

