/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.map.service;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.map.mapper.SfaTencentMapDataMapper;
import com.biz.crm.map.model.SfaTencentMapDataEntity;
import com.biz.crm.map.model.req.SfaTencentMapData;
import com.biz.crm.map.model.resp.SfaTencentMapDataRespVo;
import com.biz.crm.map.service.SfaTencentMapDataService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SfaTencentMapDataServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaTencentMapDataMapper, SfaTencentMapDataEntity>
implements SfaTencentMapDataService {
    private static final Logger log = LoggerFactory.getLogger(SfaTencentMapDataServiceImpl.class);
    @Resource
    private SfaTencentMapDataMapper sfaTencentMapDataMapper;

    @Override
    public void save(List<SfaTencentMapDataEntity> reqVo) {
        HashSet data = new HashSet();
        reqVo.forEach(o -> {
            if (StringUtils.isEmpty((String)o.getMapId()) || StringUtils.isEmpty((String)o.getLongitude()) || StringUtils.isEmpty((String)o.getLatitude()) || StringUtils.isEmpty((String)o.getName())) {
                return;
            }
            data.add(o);
        });
        ArrayList entities = Lists.newArrayList(data);
        List idList = entities.stream().map(SfaTencentMapDataEntity::getMapId).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(SfaTencentMapDataEntity::getMapId, idList)).remove();
        this.saveBatch(CrmBeanUtil.copyList((List)entities, SfaTencentMapDataEntity.class));
    }

    @Override
    public PageResult<SfaTencentMapDataRespVo> findList(SfaTencentMapData.SfaTencentMapDataReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaTencentMapDataRespVo> result = this.sfaTencentMapDataMapper.findList((Page<SfaTencentMapDataRespVo>)page, reqVo);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(result).build();
    }
}

